/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.ClassPathEntry;
import proguard.io.DataEntryNameFilter;
import proguard.io.DataEntryReader;
import proguard.io.FilteredDataEntryReader;
import proguard.io.JarReader;
import proguard.io.PrefixStrippingDataEntryReader;
import proguard.util.ExtensionMatcher;
import proguard.util.FileNameParser;
import proguard.util.ListParser;

public class DataEntryReaderFactory {
    public static DataEntryReader createDataEntryReader(String messagePrefix, ClassPathEntry classPathEntry, DataEntryReader reader) {
        boolean isApk = classPathEntry.isApk();
        boolean isJar = classPathEntry.isJar();
        boolean isAar = classPathEntry.isAar();
        boolean isWar = classPathEntry.isWar();
        boolean isEar = classPathEntry.isEar();
        boolean isJmod = classPathEntry.isJmod();
        boolean isZip = classPathEntry.isZip();
        List filter = classPathEntry.getFilter();
        List apkFilter = classPathEntry.getApkFilter();
        List jarFilter = classPathEntry.getJarFilter();
        List aarFilter = classPathEntry.getAarFilter();
        List warFilter = classPathEntry.getWarFilter();
        List earFilter = classPathEntry.getEarFilter();
        List jmodFilter = classPathEntry.getJmodFilter();
        List zipFilter = classPathEntry.getZipFilter();
        System.out.println(messagePrefix + (isApk ? "apk" : (isJar ? "jar" : (isAar ? "aar" : (isWar ? "war" : (isEar ? "ear" : (isJmod ? "jmod" : (isZip ? "zip" : "directory"))))))) + " [" + classPathEntry.getName() + "]" + (filter != null || apkFilter != null || jarFilter != null || aarFilter != null || warFilter != null || earFilter != null || jmodFilter != null || zipFilter != null ? " (filtered)" : ""));
        if (filter != null) {
            reader = new FilteredDataEntryReader(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(filter)), reader);
        }
        reader = DataEntryReaderFactory.wrapInJarReader(reader, false, false, isApk, apkFilter, ".apk");
        if (!isApk) {
            reader = DataEntryReaderFactory.wrapInJarReader(reader, false, false, isJar, jarFilter, ".jar");
            if (!isJar) {
                reader = DataEntryReaderFactory.wrapInJarReader(reader, false, false, isAar, aarFilter, ".aar");
                if (!isAar) {
                    reader = DataEntryReaderFactory.wrapInJarReader(reader, true, false, isWar, warFilter, ".war");
                    if (!isWar) {
                        reader = DataEntryReaderFactory.wrapInJarReader(reader, false, false, isEar, earFilter, ".ear");
                        if (!isEar) {
                            reader = DataEntryReaderFactory.wrapInJarReader(reader, true, true, isJmod, jmodFilter, ".jmod");
                            if (!isJmod) {
                                reader = DataEntryReaderFactory.wrapInJarReader(reader, false, false, isZip, zipFilter, ".zip");
                            }
                        }
                    }
                }
            }
        }
        return reader;
    }

    private static DataEntryReader wrapInJarReader(DataEntryReader reader, boolean stripClassesPrefix, boolean stripJmodHeader, boolean isJar, List jarFilter, String jarExtension) {
        if (stripClassesPrefix) {
            reader = new FilteredDataEntryReader(new DataEntryNameFilter(new ExtensionMatcher(".class")), new PrefixStrippingDataEntryReader("classes/", reader), reader);
        }
        DataEntryReader jarReader = new JarReader(reader, stripJmodHeader);
        if (isJar) {
            return jarReader;
        }
        if (jarFilter != null) {
            jarReader = new FilteredDataEntryReader(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(jarFilter)), jarReader);
        }
        return new FilteredDataEntryReader(new DataEntryNameFilter(new ExtensionMatcher(jarExtension)), jarReader, reader);
    }
}

