/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner;

import android.app.Instrumentation;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.test.annotation.Beta;
import androidx.test.internal.util.Checks;
import androidx.test.internal.util.LogUtil;
import androidx.test.internal.util.ParcelableIBinder;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.runner.MonitoringInstrumentation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

@Beta
public class InstrumentationConnection {
    private static final String TAG = "InstrConnection";
    private static final InstrumentationConnection DEFAULT_INSTANCE = new InstrumentationConnection(InstrumentationRegistry.getInstrumentation().getTargetContext());
    private static final String BUNDLE_KEY_CLIENTS = "instr_clients";
    private static final String BUNDLE_KEY_CLIENT_TYPE = "instr_client_type";
    private static final String BUNDLE_KEY_CLIENT_MESSENGER = "instr_client_msgr";
    private static final String BUNDLE_KEY_UUID = "instr_uuid";
    @VisibleForTesting
    static final String BUNDLE_BR_NEW_BINDER = "new_instrumentation_binder";
    public static final String BROADCAST_FILTER = "androidx.test.runner.InstrumentationConnection.event";
    private static final int MSG_REMOTE_ADD_CLIENT = 0;
    private static final int MSG_REMOTE_REMOVE_CLIENT = 1;
    private static final int MSG_TERMINATE = 2;
    private static final int MSG_HANDLE_INSTRUMENTATION_FROM_BROADCAST = 3;
    @VisibleForTesting
    static final int MSG_ADD_INSTRUMENTATION = 4;
    private static final int MSG_REMOVE_INSTRUMENTATION = 5;
    @VisibleForTesting
    static final int MSG_ADD_CLIENTS_IN_BUNDLE = 6;
    private static final int MSG_REMOVE_CLIENTS_IN_BUNDLE = 7;
    private static final int MSG_REG_CLIENT = 8;
    private static final int MSG_UN_REG_CLIENT = 9;
    @VisibleForTesting
    static final int MSG_REMOTE_CLEANUP_REQUEST = 10;
    private static final int MSG_PERFORM_CLEANUP = 11;
    private static final int MSG_PERFORM_CLEANUP_FINISHED = 12;
    private Context targetContext;
    private static Instrumentation instrumentation;
    private static MonitoringInstrumentation.ActivityFinisher activityFinisher;
    IncomingHandler incomingHandler;
    @VisibleForTesting
    final BroadcastReceiver messengerReceiver = new MessengerReceiver();

    @VisibleForTesting
    InstrumentationConnection(@NonNull Context context) {
        this.targetContext = Checks.checkNotNull(context, "Context can't be null");
    }

    public static InstrumentationConnection getInstance() {
        return DEFAULT_INSTANCE;
    }

    public synchronized void init(Instrumentation instrumentation, MonitoringInstrumentation.ActivityFinisher finisher) {
        LogUtil.logDebugWithProcess(TAG, "init", new Object[0]);
        if (null == this.incomingHandler) {
            InstrumentationConnection.instrumentation = instrumentation;
            activityFinisher = finisher;
            HandlerThread ht = new HandlerThread("InstrumentationConnectionThread");
            ht.start();
            this.incomingHandler = new IncomingHandler(ht.getLooper());
            Intent intent = new Intent(BROADCAST_FILTER);
            Bundle bundle = new Bundle();
            bundle.putParcelable(BUNDLE_BR_NEW_BINDER, (Parcelable)new ParcelableIBinder(this.incomingHandler.messengerHandler.getBinder()));
            intent.putExtra(BUNDLE_BR_NEW_BINDER, bundle);
            try {
                this.targetContext.sendBroadcast(intent);
                this.targetContext.registerReceiver(this.messengerReceiver, new IntentFilter(BROADCAST_FILTER));
            }
            catch (SecurityException isolatedProcess) {
                Log.i((String)TAG, (String)"Could not send broadcast or register receiver (isolatedProcess?)");
            }
        }
    }

    public synchronized void terminate() {
        LogUtil.logDebugWithProcess(TAG, "Terminate is called", new Object[0]);
        if (this.incomingHandler != null) {
            this.incomingHandler.runSyncTask(new Callable<Void>(){

                @Override
                public Void call() {
                    InstrumentationConnection.this.incomingHandler.doDie();
                    return null;
                }
            });
            this.targetContext.unregisterReceiver(this.messengerReceiver);
            this.incomingHandler = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void requestRemoteInstancesActivityCleanup() {
        Checks.checkState(this.incomingHandler != null, "Instrumentation Connection in not yet initialized");
        UUID uuid = UUID.randomUUID();
        CountDownLatch latch = new CountDownLatch(1);
        this.incomingHandler.associateLatch(uuid, latch);
        Message msg = this.incomingHandler.obtainMessage(10);
        msg.replyTo = this.incomingHandler.messengerHandler;
        Bundle bundle = msg.getData();
        bundle.putSerializable(BUNDLE_KEY_UUID, (Serializable)uuid);
        msg.setData(bundle);
        this.incomingHandler.sendMessage(msg);
        try {
            if (!latch.await(2L, TimeUnit.SECONDS)) {
                String string = String.valueOf(uuid);
                Log.w((String)TAG, (String)new StringBuilder(60 + String.valueOf(string).length()).append("Timed out while attempting to perform activity clean up for ").append(string).toString());
            }
        }
        catch (InterruptedException e) {
            String string = String.valueOf(uuid);
            Log.e((String)TAG, (String)new StringBuilder(61 + String.valueOf(string).length()).append("Interrupted while waiting for response from message with id: ").append(string).toString(), (Throwable)e);
        }
        finally {
            this.incomingHandler.disassociateLatch(uuid);
        }
    }

    public synchronized void registerClient(String type, Messenger messenger) {
        Checks.checkState(this.incomingHandler != null, "Instrumentation Connection in not yet initialized");
        String string = String.valueOf(type);
        Log.i((String)TAG, (String)(string.length() != 0 ? "Register client of type: ".concat(string) : new String("Register client of type: ")));
        Bundle bundle = new Bundle();
        bundle.putString(BUNDLE_KEY_CLIENT_TYPE, type);
        bundle.putParcelable(BUNDLE_KEY_CLIENT_MESSENGER, (Parcelable)messenger);
        Message msg = this.incomingHandler.obtainMessage(8);
        msg.setData(bundle);
        this.incomingHandler.sendMessage(msg);
    }

    public synchronized Set<Messenger> getClientsForType(String type) {
        return this.incomingHandler.getClientsForType(type);
    }

    public synchronized void unregisterClient(String type, Messenger messenger) {
        Checks.checkState(this.incomingHandler != null, "Instrumentation Connection in not yet initialized");
        String string = String.valueOf(type);
        Log.i((String)TAG, (String)(string.length() != 0 ? "Unregister client of type: ".concat(string) : new String("Unregister client of type: ")));
        Bundle bundle = new Bundle();
        bundle.putString(BUNDLE_KEY_CLIENT_TYPE, type);
        bundle.putParcelable(BUNDLE_KEY_CLIENT_MESSENGER, (Parcelable)messenger);
        Message msg = this.incomingHandler.obtainMessage(9);
        msg.setData(bundle);
        this.incomingHandler.sendMessage(msg);
    }

    @VisibleForTesting
    static class IncomingHandler
    extends Handler {
        @VisibleForTesting
        Messenger messengerHandler = new Messenger((Handler)this);
        @VisibleForTesting
        Set<Messenger> otherInstrumentations = new HashSet<Messenger>();
        @VisibleForTesting
        Map<String, Set<Messenger>> typedClients = new HashMap<String, Set<Messenger>>();
        private final Map<UUID, CountDownLatch> latches = new HashMap<UUID, CountDownLatch>();

        public IncomingHandler(Looper looper) {
            super(looper);
            if (Looper.getMainLooper() == looper || Looper.myLooper() == looper) {
                throw new IllegalStateException("This handler should not be using the main thread looper nor the instrumentation thread looper.");
            }
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, "handleMessage(MSG_TERMINATE)", new Object[0]);
                    this.doDie();
                    break;
                }
                case 3: {
                    LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, "handleMessage(MSG_HANDLE_INSTRUMENTATION_FROM_BROADCAST)", new Object[0]);
                    if (this.otherInstrumentations.add(msg.replyTo)) {
                        this.sendMessageWithReply(msg.replyTo, 4, null);
                        break;
                    }
                    Log.w((String)InstrumentationConnection.TAG, (String)"Broadcast with existing binder was received, ignoring it..");
                    break;
                }
                case 4: {
                    LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, "handleMessage(MSG_ADD_INSTRUMENTATION)", new Object[0]);
                    if (this.otherInstrumentations.add(msg.replyTo)) {
                        if (!this.typedClients.isEmpty()) {
                            this.sendMessageWithReply(msg.replyTo, 6, null);
                        }
                        this.clientsRegistrationFromBundle(msg.getData(), true);
                        break;
                    }
                    Log.w((String)InstrumentationConnection.TAG, (String)"Message with existing binder was received, ignoring it..");
                    break;
                }
                case 5: {
                    LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, "handleMessage(MSG_REMOVE_INSTRUMENTATION)", new Object[0]);
                    if (this.otherInstrumentations.remove(msg.replyTo)) break;
                    Log.w((String)InstrumentationConnection.TAG, (String)"Attempting to remove a non-existent binder!");
                    break;
                }
                case 6: {
                    LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, "handleMessage(MSG_ADD_CLIENTS_IN_BUNDLE)", new Object[0]);
                    this.clientsRegistrationFromBundle(msg.getData(), true);
                    break;
                }
                case 7: {
                    LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, "handleMessage(MSG_REMOVE_CLIENTS_IN_BUNDLE)", new Object[0]);
                    this.clientsRegistrationFromBundle(msg.getData(), false);
                    break;
                }
                case 8: {
                    LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, "handleMessage(MSG_REG_CLIENT)", new Object[0]);
                    this.registerClient(msg.getData().getString(InstrumentationConnection.BUNDLE_KEY_CLIENT_TYPE), (Messenger)msg.getData().getParcelable(InstrumentationConnection.BUNDLE_KEY_CLIENT_MESSENGER));
                    this.sendMessageToOtherInstr(0, msg.getData());
                    break;
                }
                case 0: {
                    LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, "handleMessage(MSG_REMOTE_ADD_CLIENT)", new Object[0]);
                    this.registerClient(msg.getData().getString(InstrumentationConnection.BUNDLE_KEY_CLIENT_TYPE), (Messenger)msg.getData().getParcelable(InstrumentationConnection.BUNDLE_KEY_CLIENT_MESSENGER));
                    break;
                }
                case 9: {
                    LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, "handleMessage(MSG_UN_REG_CLIENT)", new Object[0]);
                    this.unregisterClient(msg.getData().getString(InstrumentationConnection.BUNDLE_KEY_CLIENT_TYPE), (Messenger)msg.getData().getParcelable(InstrumentationConnection.BUNDLE_KEY_CLIENT_MESSENGER));
                    this.sendMessageToOtherInstr(1, msg.getData());
                    break;
                }
                case 1: {
                    LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, "handleMessage(MSG_REMOTE_REMOVE_CLIENT)", new Object[0]);
                    this.unregisterClient(msg.getData().getString(InstrumentationConnection.BUNDLE_KEY_CLIENT_TYPE), msg.replyTo);
                    break;
                }
                case 10: {
                    LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, "handleMessage(MSG_REMOTE_CLEANUP_REQUEST)", new Object[0]);
                    if (this.otherInstrumentations.isEmpty()) {
                        Message m = this.obtainMessage(12);
                        m.setData(msg.getData());
                        this.sendMessage(m);
                        break;
                    }
                    this.sendMessageToOtherInstr(11, msg.getData());
                    break;
                }
                case 11: {
                    LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, "handleMessage(MSG_PERFORM_CLEANUP)", new Object[0]);
                    instrumentation.runOnMainSync((Runnable)activityFinisher);
                    this.sendMessageWithReply(msg.replyTo, 12, msg.getData());
                    break;
                }
                case 12: {
                    LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, "handleMessage(MSG_PERFORM_CLEANUP_FINISHED)", new Object[0]);
                    this.notifyLatch((UUID)msg.getData().getSerializable(InstrumentationConnection.BUNDLE_KEY_UUID));
                    break;
                }
                default: {
                    int n = msg.what;
                    Log.w((String)InstrumentationConnection.TAG, (String)new StringBuilder(42).append("Unknown message code received: ").append(n).toString());
                    super.handleMessage(msg);
                }
            }
        }

        private void notifyLatch(UUID uuid) {
            if (uuid != null && this.latches.containsKey(uuid)) {
                this.latches.get(uuid).countDown();
            } else {
                String string = String.valueOf(uuid);
                Log.w((String)InstrumentationConnection.TAG, (String)new StringBuilder(16 + String.valueOf(string).length()).append("Latch not found ").append(string).toString());
            }
        }

        private void associateLatch(final UUID latchId, final CountDownLatch latch) {
            this.runSyncTask(new Callable<Void>(){

                @Override
                public Void call() {
                    IncomingHandler.this.latches.put(latchId, latch);
                    return null;
                }
            });
        }

        private void disassociateLatch(final UUID latchId) {
            this.runSyncTask(new Callable<Void>(){

                @Override
                public Void call() {
                    IncomingHandler.this.latches.remove(latchId);
                    return null;
                }
            });
        }

        private <T> T runSyncTask(Callable<T> task) {
            FutureTask<T> futureTask = new FutureTask<T>(task);
            this.post(futureTask);
            try {
                return futureTask.get();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e.getCause());
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e.getCause());
            }
        }

        private void doDie() {
            Log.i((String)InstrumentationConnection.TAG, (String)"terminating process");
            this.sendMessageToOtherInstr(5, null);
            this.otherInstrumentations.clear();
            this.typedClients.clear();
            LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, "quitting looper...", new Object[0]);
            this.getLooper().quit();
            LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, "finishing instrumentation...", new Object[0]);
            instrumentation.finish(0, null);
            instrumentation = null;
            activityFinisher = null;
        }

        private Set<Messenger> getClientsForType(final String type) {
            FutureTask<Set<Messenger>> associationTask = new FutureTask<Set<Messenger>>(new Callable<Set<Messenger>>(){

                @Override
                public Set<Messenger> call() {
                    return IncomingHandler.this.typedClients.get(type);
                }
            });
            this.post(associationTask);
            try {
                return associationTask.get();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e.getCause());
            }
        }

        private void sendMessageWithReply(Messenger toMessenger, int what, Bundle data) {
            LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, new StringBuilder(45).append("sendMessageWithReply type: ").append(what).append(" called").toString(), new Object[0]);
            Message msg = this.obtainMessage(what);
            msg.replyTo = this.messengerHandler;
            if (data != null) {
                msg.setData(data);
            }
            if (!this.typedClients.isEmpty()) {
                Bundle clientsBundle = msg.getData();
                ArrayList<String> keyList = new ArrayList<String>(this.typedClients.keySet());
                clientsBundle.putStringArrayList(InstrumentationConnection.BUNDLE_KEY_CLIENTS, keyList);
                for (Map.Entry<String, Set<Messenger>> entry : this.typedClients.entrySet()) {
                    String clientType = String.valueOf(entry.getKey());
                    Messenger[] clientArray = entry.getValue().toArray(new Messenger[entry.getValue().size()]);
                    clientsBundle.putParcelableArray(clientType, (Parcelable[])clientArray);
                }
                msg.setData(clientsBundle);
            }
            try {
                toMessenger.send(msg);
            }
            catch (RemoteException e) {
                Log.w((String)InstrumentationConnection.TAG, (String)"The remote process is terminated unexpectedly", (Throwable)e);
                this.instrBinderDied(toMessenger);
            }
        }

        private void sendMessageToOtherInstr(int what, Bundle data) {
            LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, "sendMessageToOtherInstr() called with: what = [%s], data = [%s]", what, data);
            for (Messenger otherInstr : this.otherInstrumentations) {
                this.sendMessageWithReply(otherInstr, what, data);
            }
        }

        private void clientsRegistrationFromBundle(Bundle clientsBundle, boolean shouldRegister) {
            LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, "clientsRegistrationFromBundle called", new Object[0]);
            if (null == clientsBundle) {
                Log.w((String)InstrumentationConnection.TAG, (String)"The client bundle is null, ignoring...");
                return;
            }
            ArrayList clientTypes = clientsBundle.getStringArrayList(InstrumentationConnection.BUNDLE_KEY_CLIENTS);
            if (null == clientTypes) {
                Log.w((String)InstrumentationConnection.TAG, (String)"No clients found in the given bundle");
                return;
            }
            for (String type : clientTypes) {
                Parcelable[] clientArray = clientsBundle.getParcelableArray(String.valueOf(type));
                if (clientArray == null) continue;
                for (Parcelable client : clientArray) {
                    if (shouldRegister) {
                        this.registerClient(type, (Messenger)client);
                        continue;
                    }
                    this.unregisterClient(type, (Messenger)client);
                }
            }
        }

        private void registerClient(String type, Messenger client) {
            LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, "registerClient called with type = [%s] client = [%s]", type, client);
            Checks.checkNotNull(type, "type cannot be null!");
            Checks.checkNotNull(client, "client cannot be null!");
            Set<Messenger> clientSet = this.typedClients.get(type);
            if (null == clientSet) {
                clientSet = new HashSet<Messenger>();
                clientSet.add(client);
                this.typedClients.put(type, clientSet);
                return;
            }
            clientSet.add(client);
        }

        private void unregisterClient(String type, Messenger client) {
            LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, "unregisterClient called with type = [%s] client = [%s]", type, client);
            Checks.checkNotNull(type, "type cannot be null!");
            Checks.checkNotNull(client, "client cannot be null!");
            if (!this.typedClients.containsKey(type)) {
                String string = String.valueOf(type);
                Log.w((String)InstrumentationConnection.TAG, (String)(string.length() != 0 ? "There are no registered clients for type: ".concat(string) : new String("There are no registered clients for type: ")));
                return;
            }
            Set<Messenger> clientSet = this.typedClients.get(type);
            if (!clientSet.contains(client)) {
                Log.w((String)InstrumentationConnection.TAG, (String)new StringBuilder(78 + String.valueOf(type).length()).append("Could not unregister client for type ").append(type).append(" because it doesn't seem to be registered").toString());
                return;
            }
            clientSet.remove(client);
            if (clientSet.isEmpty()) {
                this.typedClients.remove(type);
            }
        }

        private void instrBinderDied(Messenger instrMessenger) {
            Message msg = this.obtainMessage(5);
            msg.replyTo = instrMessenger;
            this.sendMessage(msg);
        }
    }

    @VisibleForTesting
    class MessengerReceiver
    extends BroadcastReceiver {
        MessengerReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            LogUtil.logDebugWithProcess(InstrumentationConnection.TAG, "Broadcast received", new Object[0]);
            Bundle extras = intent.getBundleExtra(InstrumentationConnection.BUNDLE_BR_NEW_BINDER);
            if (null == extras) {
                Log.w((String)InstrumentationConnection.TAG, (String)"Broadcast intent doesn't contain any extras, ignoring it..");
                return;
            }
            ParcelableIBinder iBinder = (ParcelableIBinder)extras.getParcelable(InstrumentationConnection.BUNDLE_BR_NEW_BINDER);
            if (iBinder != null) {
                Messenger msgr = new Messenger(iBinder.getIBinder());
                Message msg = InstrumentationConnection.this.incomingHandler.obtainMessage(3);
                msg.replyTo = msgr;
                InstrumentationConnection.this.incomingHandler.sendMessage(msg);
            }
        }
    }
}

