/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.packaging;

import com.android.utils.PathUtils;
import com.google.common.collect.ImmutableSortedMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarMerger
implements Closeable {
    public static final Predicate<String> CLASSES_ONLY = archivePath -> archivePath.endsWith(".class");
    public static final Predicate<String> EXCLUDE_CLASSES = archivePath -> !archivePath.endsWith(".class");
    public static final String MODULE_PATH = "module-path";
    public static final FileTime ZERO_TIME = FileTime.fromMillis(0L);
    private final byte[] buffer = new byte[8192];
    private final JarOutputStream jarOutputStream;
    private final Predicate<String> filter;

    public JarMerger(Path jarFile) throws IOException {
        this(jarFile, null);
    }

    public JarMerger(Path jarFile, Predicate<String> filter) throws IOException {
        this.filter = filter;
        Files.createDirectories(jarFile.getParent(), new FileAttribute[0]);
        this.jarOutputStream = new JarOutputStream(new BufferedOutputStream(Files.newOutputStream(jarFile, new OpenOption[0])));
    }

    public void addDirectory(Path directory) throws IOException {
        this.addDirectory(directory, this.filter, null, null);
    }

    public void addDirectory(final Path directory, final Predicate<String> filterOverride, Transformer transformer, final Relocator relocator) throws IOException {
        final ImmutableSortedMap.Builder candidateFiles = ImmutableSortedMap.naturalOrder();
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                String entryPath = PathUtils.toSystemIndependentPath((Path)directory.relativize(file));
                if (filterOverride != null && !filterOverride.test(entryPath)) {
                    return FileVisitResult.CONTINUE;
                }
                if (relocator != null) {
                    entryPath = relocator.relocate(entryPath);
                }
                candidateFiles.put((Object)entryPath, (Object)file);
                return FileVisitResult.CONTINUE;
            }
        });
        ImmutableSortedMap sortedFiles = candidateFiles.build();
        for (Map.Entry entry : sortedFiles.entrySet()) {
            String entryPath = (String)entry.getKey();
            BufferedInputStream is = new BufferedInputStream(Files.newInputStream((Path)entry.getValue(), new OpenOption[0]));
            Throwable throwable = null;
            try {
                if (transformer != null) {
                    InputStream is2 = transformer.filter(entryPath, is);
                    if (is2 == null) continue;
                    this.write(new JarEntry(entryPath), is2);
                    continue;
                }
                this.write(new JarEntry(entryPath), is);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)is).close();
            }
        }
    }

    public void addJar(Path file) throws IOException {
        this.addJar(file, this.filter, null);
    }

    public void addJar(Path file, Predicate<String> filterOverride, Relocator relocator) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));){
            this.addJar(inputStream, filterOverride, relocator);
        }
    }

    public void addJar(InputStream inputStream) throws IOException {
        this.addJar(inputStream, this.filter, null);
    }

    public void addJar(InputStream inputStream, Predicate<String> filterOverride, Relocator relocator) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(inputStream);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                if (filterOverride != null && !filterOverride.test(name)) continue;
                if (relocator != null) {
                    name = relocator.relocate(name);
                }
                if (name.contains("../")) {
                    throw new InvalidPathException(name, "Entry name contains invalid characters");
                }
                JarEntry newEntry = new JarEntry(name);
                newEntry.setMethod(entry.getMethod());
                if (newEntry.getMethod() == 0) {
                    newEntry.setSize(entry.getSize());
                    newEntry.setCompressedSize(entry.getCompressedSize());
                    newEntry.setCrc(entry.getCrc());
                }
                newEntry.setLastModifiedTime(ZERO_TIME);
                this.write(newEntry, zis);
            }
        }
    }

    public void addFile(String entryPath, Path file) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));){
            this.write(new JarEntry(entryPath), is);
        }
    }

    public void addEntry(String entryPath, InputStream input) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(input);){
            this.write(new JarEntry(entryPath), is);
        }
    }

    public void setCompressionLevel(int level) {
        this.jarOutputStream.setLevel(level);
    }

    @Override
    public void close() throws IOException {
        this.jarOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setManifestProperties(Map<String, String> properties) throws IOException {
        Manifest manifest = new Manifest();
        Attributes global = manifest.getMainAttributes();
        global.put(Attributes.Name.MANIFEST_VERSION, "1.0.0");
        properties.forEach((attributeName, attributeValue) -> global.put(new Attributes.Name((String)attributeName), attributeValue));
        JarEntry manifestEntry = new JarEntry("META-INF/MANIFEST.MF");
        this.setEntryAttributes(manifestEntry);
        this.jarOutputStream.putNextEntry(manifestEntry);
        try {
            manifest.write(this.jarOutputStream);
        }
        finally {
            this.jarOutputStream.closeEntry();
        }
    }

    private void write(JarEntry entry, InputStream from) throws IOException {
        int count;
        this.setEntryAttributes(entry);
        this.jarOutputStream.putNextEntry(entry);
        while ((count = from.read(this.buffer)) != -1) {
            this.jarOutputStream.write(this.buffer, 0, count);
        }
        this.jarOutputStream.closeEntry();
    }

    private void setEntryAttributes(JarEntry entry) {
        entry.setLastModifiedTime(ZERO_TIME);
        entry.setLastAccessTime(ZERO_TIME);
        entry.setCreationTime(ZERO_TIME);
    }

    public static interface Relocator {
        public String relocate(String var1);
    }

    public static interface Transformer {
        public InputStream filter(String var1, InputStream var2);
    }
}

