/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FunctionLoweringPass;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesLowering;", "Lorg/jetbrains/kotlin/backend/common/FunctionLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "lower", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "SharedVariablesTransformer", "ir.backend.common"})
public final class SharedVariablesLowering
implements FunctionLoweringPass {
    @NotNull
    private final BackendContext context;

    @Override
    public void lower(@NotNull IrFunction irFunction) {
        Intrinsics.checkParameterIsNotNull((Object)irFunction, (String)"irFunction");
        new SharedVariablesTransformer(irFunction).lowerSharedVariables();
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    public SharedVariablesLowering(@NotNull BackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        FunctionLoweringPass.DefaultImpls.lower(this, irFile);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0006\u0010\f\u001a\u00020\u000bJ\b\u0010\r\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesLowering$SharedVariablesTransformer;", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesLowering;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)V", "getIrFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "sharedVariables", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "collectSharedVariables", "", "lowerSharedVariables", "rewriteSharedVariables", "ir.backend.common"})
    private final class SharedVariablesTransformer {
        private final HashSet<IrVariable> sharedVariables;
        @NotNull
        private final IrFunction irFunction;

        public final void lowerSharedVariables() {
            this.collectSharedVariables();
            if (this.sharedVariables.isEmpty()) {
                return;
            }
            this.rewriteSharedVariables();
        }

        private final void collectSharedVariables() {
            IrElementVisitorVoidKt.acceptVoid(this.irFunction, new IrElementVisitorVoid(this){
                @NotNull
                private final ArrayDeque<IrDeclaration> declarationsStack;
                @NotNull
                private final HashSet<IrVariable> relevantVars;
                final /* synthetic */ SharedVariablesTransformer this$0;

                @NotNull
                public final ArrayDeque<IrDeclaration> getDeclarationsStack() {
                    return this.declarationsStack;
                }

                @NotNull
                public final IrDeclaration getCurrentDeclaration() {
                    IrDeclaration irDeclaration = this.declarationsStack.peek();
                    Intrinsics.checkExpressionValueIsNotNull((Object)irDeclaration, (String)"declarationsStack.peek()");
                    return irDeclaration;
                }

                @NotNull
                public final HashSet<IrVariable> getRelevantVars() {
                    return this.relevantVars;
                }

                public void visitElement(@NotNull IrElement element) {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
                }

                public void visitFunction(@NotNull IrFunction declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    this.declarationsStack.push(declaration);
                    IrElementVisitorVoidKt.acceptChildrenVoid(declaration, this);
                    this.declarationsStack.pop();
                }

                public void visitVariable(@NotNull IrVariable declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoidKt.acceptChildrenVoid(declaration, this);
                    if (declaration.isVar()) {
                        this.relevantVars.add(declaration);
                    }
                }

                public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoidKt.acceptChildrenVoid(expression2, this);
                    IrValueDeclaration value = expression2.getSymbol().getOwner();
                    if (CollectionsKt.contains((Iterable)this.relevantVars, (Object)value)) {
                        IrValueDeclaration irValueDeclaration = value;
                        if (irValueDeclaration == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrVariable");
                        }
                        if (Intrinsics.areEqual((Object)((IrVariable)irValueDeclaration).getParent(), (Object)this.getCurrentDeclaration()) ^ true) {
                            SharedVariablesTransformer.access$getSharedVariables$p(this.this$0).add(value);
                        }
                    }
                }
                {
                    this.this$0 = $outer;
                    this.declarationsStack = new ArrayDeque<E>();
                    this.relevantVars = new HashSet<E>();
                }

                public void visitElement(@NotNull IrElement element, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
                }

                public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data);
                }

                public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data);
                }

                public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
                }

                public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
                }

                public void visitBlock(@NotNull IrBlock expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
                }

                public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
                }

                public void visitBlockBody(@NotNull IrBlockBody body) {
                    Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body);
                }

                public void visitBlockBody(@NotNull IrBlockBody body, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body, data);
                }

                public void visitBody(@NotNull IrBody body) {
                    Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body);
                }

                public void visitBody(@NotNull IrBody body, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body, data);
                }

                public void visitBranch(@NotNull IrBranch branch) {
                    Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
                }

                public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
                }

                public void visitBreak(@NotNull IrBreak jump) {
                    Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
                }

                public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
                }

                public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                    Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
                }

                public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
                }

                public void visitCall(@NotNull IrCall expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
                }

                public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
                }

                public void visitCallableReference(@NotNull IrCallableReference expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
                }

                public void visitCallableReference(@NotNull IrCallableReference expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
                }

                public void visitCatch(@NotNull IrCatch aCatch) {
                    Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
                }

                public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
                }

                public void visitClass(@NotNull IrClass declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
                }

                public void visitClass(@NotNull IrClass declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data);
                }

                public void visitClassReference(@NotNull IrClassReference expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
                }

                public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
                }

                public void visitComposite(@NotNull IrComposite expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
                }

                public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
                }

                public <T> void visitConst(@NotNull IrConst<T> expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
                }

                public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
                }

                public void visitConstructor(@NotNull IrConstructor declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
                }

                public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data);
                }

                public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
                }

                public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
                }

                public void visitContinue(@NotNull IrContinue jump) {
                    Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
                }

                public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
                }

                public void visitDeclaration(@NotNull IrDeclaration declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
                }

                public void visitDeclaration(@NotNull IrDeclaration declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data);
                }

                public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
                }

                public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
                }

                public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
                }

                public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
                }

                public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                    Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
                }

                public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
                }

                public void visitElseBranch(@NotNull IrElseBranch branch) {
                    Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
                }

                public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
                }

                public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
                }

                public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
                }

                public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
                }

                public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data);
                }

                public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
                }

                public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
                }

                public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
                }

                public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data);
                }

                public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
                }

                public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
                }

                public void visitExpression(@NotNull IrExpression expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
                }

                public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
                }

                public void visitExpressionBody(@NotNull IrExpressionBody body) {
                    Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body);
                }

                public void visitExpressionBody(@NotNull IrExpressionBody body, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body, data);
                }

                public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
                }

                public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
                }

                public void visitField(@NotNull IrField declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
                }

                public void visitField(@NotNull IrField declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data);
                }

                public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
                }

                public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
                }

                public void visitFile(@NotNull IrFile declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
                }

                public void visitFile(@NotNull IrFile declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data);
                }

                public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
                }

                public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
                }

                public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
                }

                public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
                }

                public void visitGetClass(@NotNull IrGetClass expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
                }

                public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
                }

                public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
                }

                public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
                }

                public void visitGetField(@NotNull IrGetField expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
                }

                public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
                }

                public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
                }

                public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
                }

                public void visitGetValue(@NotNull IrGetValue expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
                }

                public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
                }

                public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
                }

                public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
                }

                public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
                }

                public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
                }

                public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
                }

                public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
                }

                public void visitLoop(@NotNull IrLoop loop2) {
                    Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
                }

                public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
                }

                public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
                }

                public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
                }

                public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
                }

                public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data);
                }

                public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
                }

                public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data);
                }

                public void visitProperty(@NotNull IrProperty declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
                }

                public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data);
                }

                public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
                }

                public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
                }

                public void visitReturn(@NotNull IrReturn expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
                }

                public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
                }

                public void visitSetField(@NotNull IrSetField expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
                }

                public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
                }

                public void visitSetVariable(@NotNull IrSetVariable expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2);
                }

                public void visitSetVariable(@NotNull IrSetVariable expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2, data);
                }

                public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
                }

                public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data);
                }

                public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
                }

                public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
                }

                public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                    Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
                }

                public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
                }

                public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
                }

                public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
                }

                public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
                }

                public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
                }

                public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
                }

                public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
                }

                public void visitSyntheticBody(@NotNull IrSyntheticBody body) {
                    Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body);
                }

                public void visitSyntheticBody(@NotNull IrSyntheticBody body, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body, data);
                }

                public void visitThrow(@NotNull IrThrow expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
                }

                public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
                }

                public void visitTry(@NotNull IrTry aTry) {
                    Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
                }

                public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
                }

                public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
                }

                public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data);
                }

                public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
                }

                public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
                }

                public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
                }

                public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data);
                }

                public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
                }

                public void visitValueParameter(@NotNull IrValueParameter declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
                }

                public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data);
                }

                public void visitVararg(@NotNull IrVararg expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
                }

                public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
                }

                public void visitWhen(@NotNull IrWhen expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
                }

                public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
                }

                public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                    Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
                }

                public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
                    Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
                }
            });
        }

        private final void rewriteSharedVariables() {
            HashMap transformedDescriptors = new HashMap();
            IrElementTransformerVoidKt.transformChildrenVoid(this.irFunction, new IrElementTransformerVoid(this, transformedDescriptors){
                final /* synthetic */ SharedVariablesTransformer this$0;
                final /* synthetic */ HashMap $transformedDescriptors;

                @NotNull
                public IrStatement visitVariable(@NotNull IrVariable declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
                    if (!SharedVariablesTransformer.access$getSharedVariables$p(this.this$0).contains(declaration)) {
                        return declaration;
                    }
                    IrVariable newDeclaration = this.this$0.SharedVariablesLowering.this.getContext().getSharedVariablesManager().declareSharedVariable(declaration);
                    Map map2 = this.$transformedDescriptors;
                    S s = declaration.getSymbol();
                    S s2 = newDeclaration.getSymbol();
                    map2.put(s, s2);
                    return this.this$0.SharedVariablesLowering.this.getContext().getSharedVariablesManager().defineSharedValue(declaration, newDeclaration);
                }
                {
                    this.this$0 = $outer;
                    this.$transformedDescriptors = $captured_local_variable$1;
                }
            });
            IrElementTransformerVoidKt.transformChildrenVoid(this.irFunction, new IrElementTransformerVoid(this, transformedDescriptors){
                final /* synthetic */ SharedVariablesTransformer this$0;
                final /* synthetic */ HashMap $transformedDescriptors;

                @NotNull
                public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                    IrVariableSymbol irVariableSymbol = this.getTransformedSymbol(expression2.getSymbol());
                    if (irVariableSymbol == null) {
                        return expression2;
                    }
                    IrVariableSymbol newDeclaration = irVariableSymbol;
                    return this.this$0.SharedVariablesLowering.this.getContext().getSharedVariablesManager().getSharedValue(newDeclaration, expression2);
                }

                @NotNull
                public IrExpression visitSetVariable(@NotNull IrSetVariable expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                    IrVariableSymbol irVariableSymbol = this.getTransformedSymbol(expression2.getSymbol());
                    if (irVariableSymbol == null) {
                        return expression2;
                    }
                    IrVariableSymbol newDeclaration = irVariableSymbol;
                    return this.this$0.SharedVariablesLowering.this.getContext().getSharedVariablesManager().setSharedValue(newDeclaration, expression2);
                }

                private final IrVariableSymbol getTransformedSymbol(IrValueSymbol oldSymbol) {
                    Map map2 = this.$transformedDescriptors;
                    V v2 = map2.get(oldSymbol);
                    if (v2 == null) {
                        boolean bl;
                        boolean bl2 = bl = !CollectionsKt.contains((Iterable)SharedVariablesTransformer.access$getSharedVariables$p(this.this$0), (Object)oldSymbol.getOwner());
                        if (_Assertions.ENABLED && !bl) {
                            String string = "Shared variable is not transformed: " + DumpIrTreeKt.dump(oldSymbol.getOwner());
                            throw (Throwable)((Object)new AssertionError((Object)string));
                        }
                        v2 = null;
                    }
                    return (IrVariableSymbol)v2;
                }
                {
                    this.this$0 = $outer;
                    this.$transformedDescriptors = $captured_local_variable$1;
                }
            });
        }

        @NotNull
        public final IrFunction getIrFunction() {
            return this.irFunction;
        }

        public SharedVariablesTransformer(@NotNull IrFunction irFunction) {
            Intrinsics.checkParameterIsNotNull((Object)irFunction, (String)"irFunction");
            this.irFunction = irFunction;
            this.sharedVariables = new HashSet();
        }

        public static final /* synthetic */ HashSet access$getSharedVariables$p(SharedVariablesTransformer $this) {
            return $this.sharedVariables;
        }
    }
}

