/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.assertion;

import android.graphics.Rect;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.assertion.ViewAssertions;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Predicate;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.matcher.LayoutMatchers;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.TreeIterables;
import java.util.Iterator;
import java.util.LinkedList;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class LayoutAssertions {
    private LayoutAssertions() {
    }

    public static ViewAssertion noEllipsizedText() {
        return ViewAssertions.selectedDescendantsMatch(ViewMatchers.isAssignableFrom(TextView.class), (Matcher<View>)Matchers.not(LayoutMatchers.hasEllipsizedText()));
    }

    public static ViewAssertion noMultilineButtons() {
        return ViewAssertions.selectedDescendantsMatch(ViewMatchers.isAssignableFrom(Button.class), (Matcher<View>)Matchers.not(LayoutMatchers.hasMultilineText()));
    }

    public static ViewAssertion noOverlaps(Matcher<View> matcher) {
        return new NoOverlapsViewAssertion(Preconditions.checkNotNull(matcher));
    }

    public static ViewAssertion noOverlaps() {
        return LayoutAssertions.noOverlaps((Matcher<View>)Matchers.allOf(ViewMatchers.withEffectiveVisibility(ViewMatchers.Visibility.VISIBLE), (Matcher)Matchers.anyOf(ViewMatchers.isAssignableFrom(TextView.class), ViewMatchers.isAssignableFrom(ImageView.class))));
    }

    private static Rect getRect(View view) {
        int[] nArray = new int[]{0, 0};
        view.getLocationOnScreen(nArray);
        return new Rect(nArray[0], nArray[1], nArray[0] + view.getWidth() - 1, nArray[1] + view.getHeight() - 1);
    }

    static class NoOverlapsViewAssertion
    implements ViewAssertion {
        @RemoteMsgField(order=0)
        private final Matcher<View> selector;

        @RemoteMsgConstructor
        private NoOverlapsViewAssertion(Matcher<View> matcher) {
            this.selector = matcher;
        }

        @Override
        public void check(View view, NoMatchingViewException noMatchingViewException) {
            Predicate<View> predicate = new Predicate<View>(){

                @Override
                public boolean apply(View view) {
                    return NoOverlapsViewAssertion.this.selector.matches((Object)view);
                }
            };
            if (noMatchingViewException != null) {
                throw noMatchingViewException;
            }
            Iterator<View> iterator = Iterables.filter(TreeIterables.breadthFirstViewTraversal(view), predicate).iterator();
            LinkedList<View> linkedList = new LinkedList<View>();
            StringBuilder stringBuilder = new StringBuilder();
            while (iterator.hasNext()) {
                View view2 = iterator.next();
                Rect rect = LayoutAssertions.getRect(view2);
                if (rect.isEmpty() || view2 instanceof TextView && ((TextView)view2).getText().length() == 0) continue;
                for (View view3 : linkedList) {
                    Rect rect2;
                    if (view2 instanceof ImageView && view3 instanceof ImageView || !Rect.intersects((Rect)rect, (Rect)(rect2 = LayoutAssertions.getRect(view3)))) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",\n\n");
                    }
                    stringBuilder.append(String.format("%s overlaps\n%s", HumanReadables.describe(view2), HumanReadables.describe(view3)));
                    break;
                }
                linkedList.add(view2);
            }
            if (stringBuilder.length() > 0) {
                throw new AssertionFailedError(stringBuilder.toString());
            }
        }

        public String toString() {
            return String.format("NoOverlapsViewAssertion{selector=%s}", this.selector);
        }
    }
}

