/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Binder;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.util.Log;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Throwables;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class Interrogator {
    private static final String TAG = "Interrogator";
    private static final Method messageQueueNextMethod;
    private static final Field messageQueueHeadField;
    private static final Method recycleUncheckedMethod;
    private static final int LOOKAHEAD_MILLIS = 15;
    private static final ThreadLocal<Boolean> interrogating;

    Interrogator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <R> R loopAndInterrogate(InterrogationHandler<R> interrogationHandler) {
        Interrogator.checkSanity();
        interrogating.set(Boolean.TRUE);
        boolean bl = true;
        Looper.myLooper();
        MessageQueue messageQueue = Looper.myQueue();
        long l = Binder.clearCallingIdentity();
        try {
            long l2 = Binder.clearCallingIdentity();
            while (bl) {
                bl = Interrogator.interrogateQueueState(messageQueue, interrogationHandler);
                if (!bl) continue;
                Message message = Interrogator.getNextMessage();
                if (null == message) {
                    interrogationHandler.quitting();
                    Object r = interrogationHandler.get();
                    return r;
                }
                bl = interrogationHandler.beforeTaskDispatch();
                message.getTarget().dispatchMessage(message);
                long l3 = Binder.clearCallingIdentity();
                if (l3 != l2) {
                    String string = Long.toHexString(l2);
                    String string2 = Long.toHexString(l3);
                    String string3 = message.getTarget().getClass().getName();
                    String string4 = String.valueOf(message.getCallback());
                    int n = message.what;
                    Log.wtf((String)TAG, (String)new StringBuilder(77 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Thread identity changed from 0x").append(string).append(" to 0x").append(string2).append(" while dispatching to ").append(string3).append(" ").append(string4).append(" what=").append(n).toString());
                }
                Interrogator.recycle(message);
            }
        }
        finally {
            Binder.restoreCallingIdentity((long)l);
            interrogating.set(Boolean.FALSE);
        }
        return interrogationHandler.get();
    }

    private static void recycle(Message message) {
        if (recycleUncheckedMethod != null) {
            try {
                recycleUncheckedMethod.invoke((Object)message, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException exception) {
                Throwables.throwIfUnchecked(exception);
                throw new RuntimeException(exception);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() != null) {
                    Throwables.throwIfUnchecked(invocationTargetException.getCause());
                    throw new RuntimeException(invocationTargetException.getCause());
                }
                throw new RuntimeException(invocationTargetException);
            }
        } else {
            message.recycle();
        }
    }

    private static Message getNextMessage() {
        try {
            return (Message)messageQueueNextMethod.invoke((Object)Looper.myQueue(), new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
            Throwables.throwIfUnchecked(exception);
            throw new RuntimeException(exception);
        }
    }

    static <R> R peekAtQueueState(MessageQueue messageQueue, QueueInterrogationHandler<R> queueInterrogationHandler) {
        Preconditions.checkNotNull(messageQueue);
        Preconditions.checkNotNull(queueInterrogationHandler);
        Preconditions.checkState(!Interrogator.interrogateQueueState(messageQueue, queueInterrogationHandler), "It is expected that %s would stop interrogation after a single peak at the queue.", queueInterrogationHandler);
        return queueInterrogationHandler.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean interrogateQueueState(MessageQueue messageQueue, QueueInterrogationHandler<?> queueInterrogationHandler) {
        MessageQueue messageQueue2 = messageQueue;
        synchronized (messageQueue2) {
            Message message;
            try {
                message = (Message)messageQueueHeadField.get(messageQueue);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            if (null == message) {
                return queueInterrogationHandler.queueEmpty();
            }
            if (null == message.getTarget()) {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)"barrier is up");
                }
                return queueInterrogationHandler.barrierUp();
            }
            long l = message.getWhen();
            long l2 = SystemClock.uptimeMillis() + 15L;
            if (Log.isLoggable((String)TAG, (int)3)) {
                boolean bl = l2 < l;
                Log.d((String)TAG, (String)new StringBuilder(75).append("headWhen: ").append(l).append(" nowFuz: ").append(l2).append(" due long: ").append(bl).toString());
            }
            if (l2 > l) {
                return queueInterrogationHandler.taskDueSoon();
            }
            return queueInterrogationHandler.taskDueLong();
        }
    }

    private static void checkSanity() {
        Preconditions.checkState(Looper.myLooper() != null, "Calling non-looper thread!");
        Preconditions.checkState(Boolean.FALSE.equals(interrogating.get()), "Already interrogating!");
    }

    static {
        interrogating = new ThreadLocal<Boolean>(){

            @Override
            public Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
        try {
            messageQueueNextMethod = MessageQueue.class.getDeclaredMethod("next", new Class[0]);
            messageQueueNextMethod.setAccessible(true);
            messageQueueHeadField = MessageQueue.class.getDeclaredField("mMessages");
            messageQueueHeadField.setAccessible(true);
        }
        catch (IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException exception) {
            Log.e((String)TAG, (String)"Could not initialize interrogator!", (Throwable)exception);
            throw new RuntimeException("Could not initialize interrogator!", exception);
        }
        Method method = null;
        try {
            method = Message.class.getDeclaredMethod("recycleUnchecked", new Class[0]);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        recycleUncheckedMethod = method;
    }

    static interface InterrogationHandler<R>
    extends QueueInterrogationHandler<R> {
        public boolean beforeTaskDispatch();

        public void quitting();
    }

    static interface QueueInterrogationHandler<R> {
        public boolean queueEmpty();

        public boolean taskDueSoon();

        public boolean taskDueLong();

        public boolean barrierUp();

        public R get();
    }
}

