/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Looper;
import android.view.View;
import android.widget.AdapterView;
import androidx.test.espresso.AmbiguousViewMatcherException;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewFinder;
import androidx.test.espresso.core.internal.deps.guava.base.Joiner;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Predicate;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterators;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.EspressoOptional;
import androidx.test.espresso.util.TreeIterables;
import java.util.ArrayList;
import java.util.Iterator;
import javax.inject.Provider;
import org.hamcrest.Matcher;

public final class ViewFinderImpl
implements ViewFinder {
    private final Matcher<View> viewMatcher;
    private final Provider<View> rootViewProvider;

    ViewFinderImpl(Matcher<View> matcher, Provider<View> provider) {
        this.viewMatcher = matcher;
        this.rootViewProvider = provider;
    }

    @Override
    public View getView() throws AmbiguousViewMatcherException, NoMatchingViewException {
        this.checkMainThread();
        MatcherPredicateAdapter matcherPredicateAdapter = new MatcherPredicateAdapter(Preconditions.checkNotNull(this.viewMatcher));
        View view = (View)this.rootViewProvider.get();
        Iterator<View> iterator = Iterables.filter(TreeIterables.breadthFirstViewTraversal(view), matcherPredicateAdapter).iterator();
        View view2 = null;
        while (iterator.hasNext()) {
            if (view2 != null) {
                throw new AmbiguousViewMatcherException.Builder().withViewMatcher(this.viewMatcher).withRootView(view).withView1(view2).withView2(iterator.next()).withOtherAmbiguousViews(Iterators.toArray(iterator, View.class)).build();
            }
            view2 = iterator.next();
        }
        if (null == view2) {
            MatcherPredicateAdapter matcherPredicateAdapter2 = new MatcherPredicateAdapter(ViewMatchers.isAssignableFrom(AdapterView.class));
            ArrayList<View> arrayList = Lists.newArrayList(Iterables.filter(TreeIterables.breadthFirstViewTraversal(view), matcherPredicateAdapter2).iterator());
            if (arrayList.isEmpty()) {
                throw new NoMatchingViewException.Builder().withViewMatcher(this.viewMatcher).withRootView(view).build();
            }
            String string = String.format("\nIf the target view is not part of the view hierarchy, you may need to use Espresso.onData to load it from one of the following AdapterViews:%s", Joiner.on("\n- ").join(arrayList));
            throw new NoMatchingViewException.Builder().withViewMatcher(this.viewMatcher).withRootView(view).withAdapterViews(arrayList).withAdapterViewWarning(EspressoOptional.of(string)).build();
        }
        return view2;
    }

    private void checkMainThread() {
        Preconditions.checkState(Thread.currentThread().equals(Looper.getMainLooper().getThread()), "Executing a query on the view hierarchy outside of the main thread (on: %s)", Thread.currentThread().getName());
    }

    private static class MatcherPredicateAdapter<T>
    implements Predicate<T> {
        private final Matcher<? super T> matcher;

        private MatcherPredicateAdapter(Matcher<? super T> matcher) {
            this.matcher = Preconditions.checkNotNull(matcher);
        }

        @Override
        public boolean apply(T t) {
            return this.matcher.matches(t);
        }
    }
}

