/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.util;

import androidx.test.espresso.core.internal.deps.guava.base.Function;
import androidx.test.espresso.core.internal.deps.guava.base.Optional;
import androidx.test.espresso.core.internal.deps.guava.base.Supplier;
import java.util.Set;

public final class EspressoOptional<T> {
    private final Optional<T> delegate;
    private static final long serialVersionUID = 0L;

    public static <T> EspressoOptional<T> of(T t) {
        return new EspressoOptional<T>(Optional.of(t));
    }

    public static <T> EspressoOptional<T> absent() {
        return new EspressoOptional(Optional.absent());
    }

    public static <T> EspressoOptional<T> fromNullable(T t) {
        return new EspressoOptional<T>(Optional.fromNullable(t));
    }

    private EspressoOptional(Optional<T> optional) {
        this.delegate = optional;
    }

    public boolean isPresent() {
        return this.delegate.isPresent();
    }

    public T get() {
        return this.delegate.get();
    }

    public Optional<T> or(Optional<? extends T> optional) {
        return this.delegate.or(optional);
    }

    public T or(Supplier<? extends T> supplier) {
        return this.delegate.or(supplier);
    }

    public T or(T t) {
        return this.delegate.or(t);
    }

    public T orNull() {
        return this.delegate.orNull();
    }

    public Set<T> asSet() {
        return this.delegate.asSet();
    }

    public boolean equals(Object object) {
        if (object instanceof EspressoOptional) {
            EspressoOptional espressoOptional = (EspressoOptional)object;
            return espressoOptional.delegate.equals(this.delegate);
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public <V> Optional<V> transform(Function<? super T, V> function) {
        return this.delegate.transform(function);
    }

    public static <T> Iterable<T> presentInstances(Iterable<? extends Optional<? extends T>> iterable) {
        return Optional.presentInstances(iterable);
    }
}

