/*
 * Decompiled with CFR 0.152.
 */
package worker.org.gradle.process.internal.worker;

import java.io.DataInputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import worker.org.gradle.internal.classloader.FilteringClassLoader;
import worker.org.gradle.process.internal.streams.EncodedStream;

public class GradleWorkerMain {
    public void run() throws Exception {
        DataInputStream instr = new DataInputStream(new EncodedStream.EncodedInput(System.in));
        int sharedPackagesCount = instr.readInt();
        ArrayList<String> sharedPackages = new ArrayList<String>(sharedPackagesCount);
        for (int i = 0; i < sharedPackagesCount; ++i) {
            sharedPackages.add(instr.readUTF());
        }
        int classPathLength = instr.readInt();
        URL[] implementationClassPath = new URL[classPathLength];
        for (int i = 0; i < classPathLength; ++i) {
            String url = instr.readUTF();
            implementationClassPath[i] = new URL(url);
        }
        FilteringClassLoader.Spec filteringClassLoaderSpec = new FilteringClassLoader.Spec();
        for (String sharedPackage : sharedPackages) {
            filteringClassLoaderSpec.allowPackage(sharedPackage);
        }
        FilteringClassLoader filteringClassLoader = new FilteringClassLoader(this.getClass().getClassLoader(), filteringClassLoaderSpec);
        URLClassLoader classLoader = new URLClassLoader(implementationClassPath, (ClassLoader)filteringClassLoader);
        Class<Callable> workerClass = classLoader.loadClass("org.gradle.process.internal.worker.child.SystemApplicationClassLoaderWorker").asSubclass(Callable.class);
        Callable main = workerClass.getConstructor(DataInputStream.class).newInstance(instr);
        main.call();
    }

    public static void main(String[] args) {
        try {
            new GradleWorkerMain().run();
            System.exit(0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

