/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.SdkLocator;
import com.android.build.gradle.internal.cxx.configure.GradleLocalPropertiesKt;
import com.android.build.gradle.internal.cxx.configure.Location;
import com.android.build.gradle.internal.cxx.configure.LocationType;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorKt;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorRecord;
import com.android.build.gradle.internal.cxx.configure.SdkSourceProperties;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.repository.Revision;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001ab\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\u000b2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u000bH\u0002\u001a`\u0010\u000f\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u00052\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\u000b2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u000bH\u0007\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0005H\u0007\u001a\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\u0013\u001a\u00020\u0005H\u0007\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a8\u0006\u0019"}, d2={"findNdkPath", "Lcom/android/build/gradle/internal/cxx/configure/NdkLocatorRecord;", "ndkVersionFromDsl", "", "projectDir", "Ljava/io/File;", "findNdkPathImpl", "ndkDirProperty", "androidNdkHomeEnvironmentVariable", "sdkFolder", "getNdkVersionedFolderNames", "Lkotlin/Function1;", "", "getNdkSourceProperties", "Lcom/android/build/gradle/internal/cxx/configure/SdkSourceProperties;", "findNdkPathWithRecord", "getNdkVersionInfo", "ndkRoot", "getNdkVersionedFolders", "ndkVersionRoot", "isAcceptableNdkVersion", "", "sourcePropertiesRevision", "Lcom/android/repository/Revision;", "revisionFromDsl", "gradle"})
public final class NdkLocatorKt {
    /*
     * WARNING - void declaration
     */
    private static final File findNdkPathImpl(String ndkDirProperty, String androidNdkHomeEnvironmentVariable, File sdkFolder2, String ndkVersionFromDsl, Function1<? super File, ? extends List<String>> getNdkVersionedFolderNames, Function1<? super File, SdkSourceProperties> getNdkSourceProperties) {
        Object foundNdkRoot;
        void location;
        Pair $dstr$location$_u24__u24;
        Object $this$mapNotNullTo$iv$iv;
        Iterator item$iv$iv2;
        boolean bl;
        Location location2;
        StringBuilder stringBuilder = new StringBuilder().append("android.ndkVersion from module build.gradle is ");
        String string = ndkVersionFromDsl;
        if (string == null) {
            string = "not set";
        }
        LoggingEnvironmentKt.infoln(stringBuilder.append(string).toString(), new Object[0]);
        StringBuilder stringBuilder2 = new StringBuilder().append("ndk.dir in local.properties is ");
        String string2 = ndkDirProperty;
        if (string2 == null) {
            string2 = "not set";
        }
        LoggingEnvironmentKt.infoln(stringBuilder2.append(string2).toString(), new Object[0]);
        StringBuilder stringBuilder3 = new StringBuilder().append("ANDROID_NDK_HOME environment variable is ");
        String string3 = androidNdkHomeEnvironmentVariable;
        if (string3 == null) {
            string3 = "not set";
        }
        LoggingEnvironmentKt.infoln(stringBuilder3.append((Object)string3).toString(), new Object[0]);
        StringBuilder stringBuilder4 = new StringBuilder().append("sdkFolder is ");
        Object object = sdkFolder2;
        if (object == null) {
            object = "not set";
        }
        LoggingEnvironmentKt.infoln(stringBuilder4.append(object).toString(), new Object[0]);
        if (androidNdkHomeEnvironmentVariable != null) {
            LoggingEnvironmentKt.warnln("Support for ANDROID_NDK_HOME is deprecated and will be removed in the future. Use android.ndkVersion in build.gradle instead.", new Object[0]);
        }
        findNdkPathImpl.1 $fun$considerAndReject$1 = findNdkPathImpl.1.INSTANCE;
        boolean bl2 = false;
        List foundLocations = new ArrayList();
        if (ndkDirProperty != null) {
            Collection collection = foundLocations;
            location2 = new Location(LocationType.NDK_DIR_LOCATION, new File(ndkDirProperty));
            bl = false;
            collection.add(location2);
        }
        if (androidNdkHomeEnvironmentVariable != null) {
            Collection collection = foundLocations;
            location2 = new Location(LocationType.ANDROID_NDK_HOME_LOCATION, new File(androidNdkHomeEnvironmentVariable));
            bl = false;
            collection.add(location2);
        }
        if (sdkFolder2 != null) {
            Collection collection = foundLocations;
            location2 = new Location(LocationType.NDK_BUNDLE_FOLDER_LOCATION, new File(sdkFolder2, "ndk-bundle"));
            bl = false;
            collection.add(location2);
        }
        Revision ndkVersionFromDslRevision = null;
        if (ndkVersionFromDsl != null) {
            try {
                ndkVersionFromDslRevision = Revision.parseRevision((String)ndkVersionFromDsl);
            }
            catch (NumberFormatException e) {
                LoggingEnvironmentKt.errorln("Requested NDK version '" + ndkVersionFromDsl + "' could not be parsed", new Object[0]);
            }
        }
        if (sdkFolder2 != null) {
            void $this$mapTo$iv$iv;
            File versionRoot = new File(sdkFolder2, "ndk");
            Collection collection = foundLocations;
            Object $this$map$iv = (Iterable)getNdkVersionedFolderNames.invoke((Object)versionRoot);
            boolean $i$f$map = false;
            Object object2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Iterator item$iv$iv2 : $this$mapTo$iv$iv) {
                void version;
                String string4 = (String)((Object)item$iv$iv2);
                Collection collection2 = destination$iv$iv;
                boolean bl3 = false;
                Location location3 = new Location(LocationType.NDK_VERSIONED_FOLDER_LOCATION, new File(versionRoot, (String)version));
                collection2.add(location3);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)$this$map$iv);
        }
        Iterable $this$forEach$iv = foundLocations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Location location4 = (Location)element$iv;
            boolean bl4 = false;
            LoggingEnvironmentKt.infoln("Considering " + location4.getNdkRoot() + ' ' + location4.getType().getTag(), new Object[0]);
        }
        Iterable $this$mapNotNull$iv = foundLocations;
        boolean $i$f$mapNotNull = false;
        Iterable element$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        item$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
        while (item$iv$iv2.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = item$iv$iv2.next();
            boolean bl5 = false;
            Location location5 = (Location)element$iv$iv;
            boolean bl6 = false;
            SdkSourceProperties versionInfo = (SdkSourceProperties)getNdkSourceProperties.invoke((Object)location5.getNdkRoot());
            if (versionInfo == null) {
                if (FilesKt.resolve((File)location5.getNdkRoot(), (String)"RELEASE.TXT").exists()) {
                    findNdkPathImpl.1.INSTANCE.invoke(location5, "it contains an unsupported (pre-r11) NDK");
                } else {
                    findNdkPathImpl.1.INSTANCE.invoke(location5, "that location has no source.properties");
                }
                pair = null;
            } else if (versionInfo.getValue(SdkSourceProperties.Companion.SdkSourceProperty.SDK_PKG_REVISION) == null) {
                findNdkPathImpl.1.INSTANCE.invoke(location5, "that location had source.properties " + "with no " + SdkSourceProperties.Companion.SdkSourceProperty.SDK_PKG_REVISION.getKey());
                pair = null;
            } else {
                Pair pair2;
                String revision;
                if (versionInfo.getValue(SdkSourceProperties.Companion.SdkSourceProperty.SDK_PKG_REVISION) == null) {
                    Intrinsics.throwNpe();
                }
                try {
                    Revision.parseRevision((String)revision);
                    pair2 = new Pair((Object)location5, (Object)versionInfo);
                }
                catch (NumberFormatException e) {
                    findNdkPathImpl.1.INSTANCE.invoke(location5, "that location had " + "source.properties with invalid " + SdkSourceProperties.Companion.SdkSourceProperty.SDK_PKG_REVISION.getKey() + '=' + revision);
                    pair2 = null;
                }
                pair = pair2;
            }
            if (pair == null) continue;
            Pair pair3 = pair;
            boolean bl7 = false;
            boolean bl8 = false;
            Pair it$iv$iv = pair3;
            boolean bl9 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List versionedLocations2 = CollectionsKt.asReversed((List)CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv2), (Comparator)ComparisonsKt.compareBy((Function1[])new Function1[]{findNdkPathImpl.versionedLocations.2.INSTANCE, findNdkPathImpl.versionedLocations.3.INSTANCE})));
        Pair highest = (Pair)CollectionsKt.firstOrNull((List)versionedLocations2);
        if (highest == null) {
            if (ndkVersionFromDslRevision == null) {
                LoggingEnvironmentKt.warnln("Compatible side by side NDK version was not found.", new Object[0]);
            } else {
                LoggingEnvironmentKt.warnln("Compatible side by side NDK version was not found for android.ndkVersion " + '\'' + ndkVersionFromDslRevision + '\'', new Object[0]);
            }
            return null;
        }
        if (ndkVersionFromDslRevision != null) {
            Pair $dstr$location$version;
            Iterable $this$filterTo$iv$iv;
            if (ndkDirProperty != null) {
                Iterator iterator;
                Iterable $i$f$mapNotNullTo2;
                block46: {
                    $this$mapNotNullTo$iv$iv = versionedLocations2;
                    boolean destination$iv$iv2 = false;
                    $i$f$mapNotNullTo2 = $this$mapNotNullTo$iv$iv;
                    boolean $this$forEach$iv$iv$iv2 = false;
                    for (Iterator item$iv$iv2 : $i$f$mapNotNullTo2) {
                        $dstr$location$_u24__u24 = (Pair)item$iv$iv2;
                        boolean bl10 = false;
                        Location location6 = (Location)$dstr$location$_u24__u24.component1();
                        if (!(location6.getType() == LocationType.NDK_DIR_LOCATION)) continue;
                        iterator = item$iv$iv2;
                        break block46;
                    }
                    iterator = null;
                }
                Pair ndkDirLocation = (Pair)iterator;
                if (ndkDirLocation == null) {
                    LoggingEnvironmentKt.errorln("Location specified by ndk.dir (" + ndkDirProperty + ") did not contain a " + "valid NDK and so couldn't satisfy the requested NDK version " + ndkVersionFromDsl, new Object[0]);
                } else {
                    $i$f$mapNotNullTo2 = ndkDirLocation;
                    $this$mapNotNullTo$iv$iv = (Location)$i$f$mapNotNullTo2.component1();
                    SdkSourceProperties version = (SdkSourceProperties)$i$f$mapNotNullTo2.component2();
                    if (NdkLocatorKt.isAcceptableNdkVersion(version.getRevision(), ndkVersionFromDslRevision)) {
                        LoggingEnvironmentKt.infoln("Choosing " + location.getNdkRoot() + " from ndk.dir which had the requested " + "version " + ndkVersionFromDsl, new Object[0]);
                    } else {
                        LoggingEnvironmentKt.errorln("Requested NDK version " + ndkVersionFromDsl + " did not match the version " + version.getRevision() + " requested by ndk.dir at " + location.getNdkRoot(), new Object[0]);
                    }
                    return location.getNdkRoot();
                }
            }
            Iterable $this$filter$iv = versionedLocations2;
            boolean $i$f$filter = false;
            Iterable $i$f$mapNotNullTo2 = $this$filter$iv;
            Collection destination$iv$iv322 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Pair $dstr$_u24__u24$sourceProperties = (Pair)element$iv$iv;
                boolean bl11 = false;
                SdkSourceProperties sourceProperties = (SdkSourceProperties)$dstr$_u24__u24$sourceProperties.component2();
                if (!NdkLocatorKt.isAcceptableNdkVersion(sourceProperties.getRevision(), ndkVersionFromDslRevision)) continue;
                destination$iv$iv322.add(element$iv$iv);
            }
            List matchingLocations = CollectionsKt.toList((Iterable)((List)destination$iv$iv322));
            if (matchingLocations.isEmpty()) {
                Iterable $this$onEach$iv = versionedLocations2;
                boolean $i$f$onEach = false;
                $this$filterTo$iv$iv = $this$onEach$iv;
                boolean destination$iv$iv322 = false;
                boolean bl12 = false;
                Object $this$apply$iv = $this$filterTo$iv$iv;
                boolean bl13 = false;
                Iterator $dstr$_u24__u24$sourceProperties = $this$apply$iv.iterator();
                while ($dstr$_u24__u24$sourceProperties.hasNext()) {
                    Object element$iv2 = $dstr$_u24__u24$sourceProperties.next();
                    $dstr$location$version = (Pair)element$iv2;
                    boolean bl14 = false;
                    Location location7 = (Location)$dstr$location$version.component1();
                    SdkSourceProperties version = (SdkSourceProperties)$dstr$location$version.component2();
                    findNdkPathImpl.1.INSTANCE.invoke(location7, "that NDK had version " + version.getRevision() + " which didn't " + "match the requested version " + ndkVersionFromDsl);
                }
                $this$onEach$iv = versionedLocations2;
                $i$f$onEach = false;
                if (!$this$onEach$iv.isEmpty()) {
                    Iterable $this$sortedBy$iv = versionedLocations2;
                    boolean $i$f$sortedBy = false;
                    Iterable destination$iv$iv322 = $this$sortedBy$iv;
                    bl12 = false;
                    $this$apply$iv = new Comparator<T>(){

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            Pair $dstr$_u24__u24$version = (Pair)a;
                            boolean bl2 = false;
                            SdkSourceProperties version = (SdkSourceProperties)$dstr$_u24__u24$version.component2();
                            $dstr$_u24__u24$version = (Pair)b;
                            Comparable comparable = (Comparable)version.getRevision();
                            bl2 = false;
                            version = (SdkSourceProperties)$dstr$_u24__u24$version.component2();
                            Revision revision = version.getRevision();
                            return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)revision));
                        }
                    };
                    String available2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)destination$iv$iv322, (Comparator)$this$apply$iv), (CharSequence)", ", null, null, (int)0, null, (Function1)findNdkPathImpl.available.2.INSTANCE, (int)30, null);
                    LoggingEnvironmentKt.errorln("No version of NDK matched the requested version " + ndkVersionFromDsl + ". Versions available locally: " + available2, new Object[0]);
                } else {
                    LoggingEnvironmentKt.errorln("No version of NDK matched the requested version " + ndkVersionFromDsl, new Object[0]);
                }
                return ((Location)highest.getFirst()).getNdkRoot();
            }
            foundNdkRoot = ((Location)((Pair)CollectionsKt.first((List)matchingLocations)).getFirst()).getNdkRoot();
            if (matchingLocations.size() > 1) {
                LoggingEnvironmentKt.infoln("Found " + matchingLocations.size() + " NDK folders that matched requested " + "version " + ndkVersionFromDslRevision + ':', new Object[0]);
                Iterable $this$forEachIndexed$iv = matchingLocations;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void $dstr$location$_u24__u242;
                    int bl13 = index$iv++;
                    boolean $dstr$_u24__u24$sourceProperties = false;
                    if (bl13 < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int element$iv2 = bl13;
                    $dstr$location$version = (Pair)item$iv;
                    int index = element$iv2;
                    boolean bl15 = false;
                    Location location8 = (Location)$dstr$location$_u24__u242.component1();
                    LoggingEnvironmentKt.infoln(" (" + (index + 1) + ") " + location8.getNdkRoot() + ' ' + location8.getType().getTag(), new Object[0]);
                }
                LoggingEnvironmentKt.infoln("  choosing " + foundNdkRoot, new Object[0]);
            } else {
                LoggingEnvironmentKt.infoln("Found requested NDK version " + ndkVersionFromDslRevision + " at " + foundNdkRoot, new Object[0]);
            }
            return foundNdkRoot;
        }
        if (ndkDirProperty != null) {
            Object v10;
            Iterable iterable;
            block47: {
                foundNdkRoot = versionedLocations2;
                boolean $this$forEachIndexed$iv = false;
                iterable = foundNdkRoot;
                boolean bl16 = false;
                for (Object t : iterable) {
                    $dstr$location$_u24__u24 = (Pair)t;
                    boolean bl17 = false;
                    Location location9 = (Location)$dstr$location$_u24__u24.component1();
                    if (!(location9.getType() == LocationType.NDK_DIR_LOCATION)) continue;
                    v10 = t;
                    break block47;
                }
                v10 = null;
            }
            Pair ndkDirLocation = v10;
            if (ndkDirLocation == null) {
                LoggingEnvironmentKt.errorln("Location specified by ndk.dir (" + ndkDirProperty + ") did not contain a " + "valid NDK and and couldn't be used", new Object[0]);
                LoggingEnvironmentKt.infoln("Using " + ((Location)highest.getFirst()).getNdkRoot() + " which is " + "version " + ((SdkSourceProperties)highest.getSecond()).getRevision() + " as fallback but build will fail", new Object[0]);
                return ((Location)highest.getFirst()).getNdkRoot();
            }
            iterable = ndkDirLocation;
            foundNdkRoot = (Location)iterable.component1();
            SdkSourceProperties version = (SdkSourceProperties)iterable.component2();
            LoggingEnvironmentKt.infoln("Found requested ndk.dir (" + location.getNdkRoot() + ") which has version " + version.getRevision(), new Object[0]);
            return location.getNdkRoot();
        }
        LoggingEnvironmentKt.infoln("No user requested version, choosing " + ((Location)highest.getFirst()).getNdkRoot() + " which is " + "version " + ((SdkSourceProperties)highest.getSecond()).getRevision(), new Object[0]);
        return ((Location)highest.getFirst()).getNdkRoot();
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    @NotNull
    public static final NdkLocatorRecord findNdkPathWithRecord(@Nullable String ndkVersionFromDsl, @Nullable String ndkDirProperty, @Nullable String androidNdkHomeEnvironmentVariable, @Nullable File sdkFolder, @NotNull Function1<? super File, ? extends List<String>> getNdkVersionedFolderNames, @NotNull Function1<? super File, SdkSourceProperties> getNdkSourceProperties) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final boolean isAcceptableNdkVersion(Revision sourcePropertiesRevision, Revision revisionFromDsl) {
        boolean bl;
        int[] parts = revisionFromDsl.toIntArray(true);
        switch (parts.length) {
            case 3: 
            case 4: {
                bl = Intrinsics.areEqual((Object)sourcePropertiesRevision, (Object)revisionFromDsl);
                break;
            }
            case 2: {
                if (revisionFromDsl.getMajor() == sourcePropertiesRevision.getMajor() && revisionFromDsl.getMinor() == sourcePropertiesRevision.getMinor()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                if (revisionFromDsl.getMajor() == sourcePropertiesRevision.getMajor()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("Unexpected");
            }
        }
        return bl;
    }

    @VisibleForTesting
    @Nullable
    public static final SdkSourceProperties getNdkVersionInfo(@NotNull File ndkRoot) {
        SdkSourceProperties sdkSourceProperties;
        Intrinsics.checkParameterIsNotNull((Object)ndkRoot, (String)"ndkRoot");
        try {
            sdkSourceProperties = SdkSourceProperties.Companion.fromInstallFolder(ndkRoot);
        }
        catch (FileNotFoundException e) {
            sdkSourceProperties = null;
        }
        return sdkSourceProperties;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public static final List<String> getNdkVersionedFolders(@NotNull File ndkVersionRoot) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)ndkVersionRoot, (String)"ndkVersionRoot");
        if (!ndkVersionRoot.isDirectory()) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        String[] stringArray = ndkVersionRoot.list();
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"ndkVersionRoot.list()");
        String[] $this$filter$iv = stringArray;
        boolean $i$f$filter = false;
        String[] stringArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var6_7 = $this$filterTo$iv$iv;
        int n = ((void)var6_7).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = var6_7[j];
            boolean bl = false;
            if (!new File(ndkVersionRoot, (String)it).isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final NdkLocatorRecord findNdkPath(@Nullable String ndkVersionFromDsl, @NotNull File projectDir) {
        Intrinsics.checkParameterIsNotNull((Object)projectDir, (String)"projectDir");
        Properties properties = GradleLocalPropertiesKt.gradleLocalProperties(projectDir);
        File sdkPath = SdkLocator.getSdkLocation(projectDir).getDirectory();
        return NdkLocatorKt.findNdkPathWithRecord(ndkVersionFromDsl, properties.getProperty("ndk.dir"), System.getenv("ANDROID_NDK_HOME"), sdkPath, (Function1<? super File, ? extends List<String>>)((Function1)findNdkPath.1.INSTANCE), (Function1<? super File, SdkSourceProperties>)((Function1)findNdkPath.2.INSTANCE));
    }
}

