/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.View;
import androidx.annotation.NonNull;

class CutoutDrawable
extends GradientDrawable {
    private final Paint cutoutPaint = new Paint(1);
    private final RectF cutoutBounds;
    private int savedLayer;

    CutoutDrawable() {
        this.setPaintStyles();
        this.cutoutBounds = new RectF();
    }

    private void setPaintStyles() {
        this.cutoutPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.cutoutPaint.setColor(-1);
        this.cutoutPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
    }

    boolean hasCutout() {
        return !this.cutoutBounds.isEmpty();
    }

    void setCutout(float left, float top, float right, float bottom) {
        if (left != this.cutoutBounds.left || top != this.cutoutBounds.top || right != this.cutoutBounds.right || bottom != this.cutoutBounds.bottom) {
            this.cutoutBounds.set(left, top, right, bottom);
            this.invalidateSelf();
        }
    }

    void setCutout(RectF bounds) {
        this.setCutout(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    void removeCutout() {
        this.setCutout(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public void draw(@NonNull Canvas canvas) {
        this.preDraw(canvas);
        super.draw(canvas);
        canvas.drawRect(this.cutoutBounds, this.cutoutPaint);
        this.postDraw(canvas);
    }

    private void preDraw(@NonNull Canvas canvas) {
        Drawable.Callback callback = this.getCallback();
        if (this.useHardwareLayer(callback)) {
            View viewCallback = (View)callback;
            viewCallback.setLayerType(2, null);
        } else {
            this.saveCanvasLayer(canvas);
        }
    }

    private void saveCanvasLayer(@NonNull Canvas canvas) {
        this.savedLayer = Build.VERSION.SDK_INT >= 21 ? canvas.saveLayer(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight(), null) : canvas.saveLayer(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight(), null, 31);
    }

    private void postDraw(@NonNull Canvas canvas) {
        if (!this.useHardwareLayer(this.getCallback())) {
            canvas.restoreToCount(this.savedLayer);
        }
    }

    private boolean useHardwareLayer(Drawable.Callback callback) {
        return callback instanceof View;
    }
}

