/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.ClassifierNamePolicy;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u0012\u001a\u00020\u000f*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/AdaptiveClassifierNamePolicy;", "Lorg/jetbrains/kotlin/renderer/ClassifierNamePolicy;", "ambiguousNames", "", "Lorg/jetbrains/kotlin/name/Name;", "(Ljava/util/List;)V", "renderedParameters", "", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "hasUniqueName", "", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "renderClassifier", "", "renderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "renderAmbiguousTypeParameter", "typeParameter", "index", "", "firstOccurence", "frontend"})
final class AdaptiveClassifierNamePolicy
implements ClassifierNamePolicy {
    private final Map<Name, LinkedHashSet<TypeParameterDescriptor>> renderedParameters;
    private final List<Name> ambiguousNames;

    @Override
    @NotNull
    public String renderClassifier(@NotNull ClassifierDescriptor classifier2, @NotNull DescriptorRenderer renderer) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)classifier2, (String)"classifier");
        Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
        if (this.hasUniqueName(classifier2)) {
            string = ClassifierNamePolicy.SHORT.INSTANCE.renderClassifier(classifier2, renderer);
        } else if (classifier2 instanceof ClassDescriptor || classifier2 instanceof TypeAliasDescriptor) {
            string = ClassifierNamePolicy.FULLY_QUALIFIED.INSTANCE.renderClassifier(classifier2, renderer);
        } else if (classifier2 instanceof TypeParameterDescriptor) {
            LinkedHashSet<TypeParameterDescriptor> linkedHashSet;
            Name name2 = ((TypeParameterDescriptor)classifier2).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"classifier.name");
            Name name3 = name2;
            Map<Name, LinkedHashSet<TypeParameterDescriptor>> $this$getOrPut$iv = this.renderedParameters;
            boolean $i$f$getOrPut = false;
            LinkedHashSet<TypeParameterDescriptor> value$iv = $this$getOrPut$iv.get(name3);
            if (value$iv == null) {
                boolean bl = false;
                LinkedHashSet answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(name3, answer$iv);
                linkedHashSet = answer$iv;
            } else {
                linkedHashSet = value$iv;
            }
            LinkedHashSet<TypeParameterDescriptor> typeParametersWithSameName = linkedHashSet;
            boolean isFirstOccurence = typeParametersWithSameName.add((TypeParameterDescriptor)classifier2);
            int index2 = CollectionsKt.indexOf((Iterable)typeParametersWithSameName, (Object)classifier2);
            string = this.renderAmbiguousTypeParameter(renderer, (TypeParameterDescriptor)classifier2, index2 + 1, isFirstOccurence);
        } else {
            String string2 = "Unexpected classifier: " + classifier2.getClass();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    private final boolean hasUniqueName(ClassifierDescriptor classifier2) {
        return !this.ambiguousNames.contains(classifier2.getName());
    }

    private final String renderAmbiguousTypeParameter(@NotNull DescriptorRenderer $this$renderAmbiguousTypeParameter, TypeParameterDescriptor typeParameter, int index2, boolean firstOccurence) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append(typeParameter.getName());
        $this$buildString.append("" + '#' + index2);
        if (firstOccurence) {
            StringBuilder stringBuilder2 = new StringBuilder().append(" (type parameter of ");
            DeclarationDescriptor declarationDescriptor = typeParameter.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"typeParameter.containingDeclaration");
            $this$buildString.append($this$renderAmbiguousTypeParameter.renderMessage(stringBuilder2.append($this$renderAmbiguousTypeParameter.renderFqName(DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor))).append(')').toString()));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public AdaptiveClassifierNamePolicy(@NotNull List<Name> ambiguousNames) {
        Map map2;
        Intrinsics.checkParameterIsNotNull(ambiguousNames, (String)"ambiguousNames");
        this.ambiguousNames = ambiguousNames;
        AdaptiveClassifierNamePolicy adaptiveClassifierNamePolicy = this;
        boolean bl = false;
        adaptiveClassifierNamePolicy.renderedParameters = map2 = (Map)new LinkedHashMap();
    }
}

