/*
 * Decompiled with CFR 0.152.
 */
package androidx.preference;

import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.preference.EditTextPreference;
import androidx.preference.PreferenceDialogFragmentCompat;

public class EditTextPreferenceDialogFragmentCompat
extends PreferenceDialogFragmentCompat {
    private static final String SAVE_STATE_TEXT = "EditTextPreferenceDialogFragment.text";
    private EditText mEditText;
    private CharSequence mText;

    public static EditTextPreferenceDialogFragmentCompat newInstance(String key) {
        EditTextPreferenceDialogFragmentCompat fragment = new EditTextPreferenceDialogFragmentCompat();
        Bundle b = new Bundle(1);
        b.putString("key", key);
        fragment.setArguments(b);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mText = savedInstanceState == null ? this.getEditTextPreference().getText() : savedInstanceState.getCharSequence(SAVE_STATE_TEXT);
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putCharSequence(SAVE_STATE_TEXT, this.mText);
    }

    @Override
    protected void onBindDialogView(View view) {
        super.onBindDialogView(view);
        this.mEditText = (EditText)view.findViewById(16908291);
        if (this.mEditText == null) {
            throw new IllegalStateException("Dialog view must contain an EditText with id @android:id/edit");
        }
        this.mEditText.requestFocus();
        this.mEditText.setText(this.mText);
        this.mEditText.setSelection(this.mEditText.getText().length());
        if (this.getEditTextPreference().getOnBindEditTextListener() != null) {
            this.getEditTextPreference().getOnBindEditTextListener().onBindEditText(this.mEditText);
        }
    }

    private EditTextPreference getEditTextPreference() {
        return (EditTextPreference)this.getPreference();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected boolean needInputMethod() {
        return true;
    }

    @Override
    public void onDialogClosed(boolean positiveResult) {
        if (positiveResult) {
            String value = this.mEditText.getText().toString();
            EditTextPreference preference = this.getEditTextPreference();
            if (preference.callChangeListener(value)) {
                preference.setText(value);
            }
        }
    }
}

