/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.media.AudioPresentation;
import android.media.Image;
import android.media.MediaCodecInfo;
import android.media.MediaCrypto;
import android.media.MediaDescrambler;
import android.media.MediaFormat;
import android.os.Bundle;
import android.os.Handler;
import android.os.PersistableBundle;
import android.view.Surface;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MediaCodec {
    public static final int BUFFER_FLAG_CODEC_CONFIG = 2;
    public static final int BUFFER_FLAG_END_OF_STREAM = 4;
    public static final int BUFFER_FLAG_KEY_FRAME = 1;
    public static final int BUFFER_FLAG_PARTIAL_FRAME = 8;
    @Deprecated
    public static final int BUFFER_FLAG_SYNC_FRAME = 1;
    public static final int CONFIGURE_FLAG_ENCODE = 1;
    public static final int CRYPTO_MODE_AES_CBC = 2;
    public static final int CRYPTO_MODE_AES_CTR = 1;
    public static final int CRYPTO_MODE_UNENCRYPTED = 0;
    @Deprecated
    public static final int INFO_OUTPUT_BUFFERS_CHANGED = -3;
    public static final int INFO_OUTPUT_FORMAT_CHANGED = -2;
    public static final int INFO_TRY_AGAIN_LATER = -1;
    public static final String PARAMETER_KEY_HDR10_PLUS_INFO = "hdr10-plus-info";
    public static final String PARAMETER_KEY_OFFSET_TIME = "time-offset-us";
    public static final String PARAMETER_KEY_REQUEST_SYNC_FRAME = "request-sync";
    public static final String PARAMETER_KEY_SUSPEND = "drop-input-frames";
    public static final String PARAMETER_KEY_SUSPEND_TIME = "drop-start-time-us";
    public static final String PARAMETER_KEY_VIDEO_BITRATE = "video-bitrate";
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT = 1;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING = 2;

    MediaCodec(@NonNull String name, boolean nameIsType, boolean encoder) {
    }

    @NonNull
    public static MediaCodec createDecoderByType(@NonNull String type) throws IOException {
        throw new RuntimeException("Method createDecoderByType in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @NonNull
    public static MediaCodec createEncoderByType(@NonNull String type) throws IOException {
        throw new RuntimeException("Method createEncoderByType in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @NonNull
    public static MediaCodec createByCodecName(@NonNull String name) throws IOException {
        throw new RuntimeException("Method createByCodecName in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    protected void finalize() {
        throw new RuntimeException("Method finalize in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void reset() {
        throw new RuntimeException("Method reset in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void release() {
        throw new RuntimeException("Method release in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void configure(@Nullable MediaFormat format, @Nullable Surface surface, @Nullable MediaCrypto crypto, int flags) {
        throw new RuntimeException("Method configure in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void configure(@Nullable MediaFormat format, @Nullable Surface surface, int flags, @Nullable MediaDescrambler descrambler) {
        throw new RuntimeException("Method configure in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void setOutputSurface(@NonNull Surface surface) {
        throw new RuntimeException("Method setOutputSurface in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @NonNull
    public static Surface createPersistentInputSurface() {
        throw new RuntimeException("Method createPersistentInputSurface in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void setInputSurface(@NonNull Surface surface) {
        throw new RuntimeException("Method setInputSurface in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @NonNull
    public Surface createInputSurface() {
        throw new RuntimeException("Method createInputSurface in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void start() {
        throw new RuntimeException("Method start in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void stop() {
        throw new RuntimeException("Method stop in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void flush() {
        throw new RuntimeException("Method flush in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) throws CryptoException {
        throw new RuntimeException("Method queueInputBuffer in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void queueSecureInputBuffer(int index, int offset, @NonNull CryptoInfo info, long presentationTimeUs, int flags) throws CryptoException {
        throw new RuntimeException("Method queueSecureInputBuffer in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int dequeueInputBuffer(long timeoutUs) {
        throw new RuntimeException("Method dequeueInputBuffer in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int dequeueOutputBuffer(@NonNull BufferInfo info, long timeoutUs) {
        throw new RuntimeException("Method dequeueOutputBuffer in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void releaseOutputBuffer(int index, boolean render) {
        throw new RuntimeException("Method releaseOutputBuffer in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void releaseOutputBuffer(int index, long renderTimestampNs) {
        throw new RuntimeException("Method releaseOutputBuffer in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void signalEndOfInputStream() {
        throw new RuntimeException("Method signalEndOfInputStream in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @NonNull
    public MediaFormat getOutputFormat() {
        throw new RuntimeException("Method getOutputFormat in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @NonNull
    public MediaFormat getInputFormat() {
        throw new RuntimeException("Method getInputFormat in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @NonNull
    public MediaFormat getOutputFormat(int index) {
        throw new RuntimeException("Method getOutputFormat in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @Deprecated
    @NonNull
    public ByteBuffer[] getInputBuffers() {
        throw new RuntimeException("Method getInputBuffers in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @Deprecated
    @NonNull
    public ByteBuffer[] getOutputBuffers() {
        throw new RuntimeException("Method getOutputBuffers in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @Nullable
    public ByteBuffer getInputBuffer(int index) {
        throw new RuntimeException("Method getInputBuffer in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @Nullable
    public Image getInputImage(int index) {
        throw new RuntimeException("Method getInputImage in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @Nullable
    public ByteBuffer getOutputBuffer(int index) {
        throw new RuntimeException("Method getOutputBuffer in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @Nullable
    public Image getOutputImage(int index) {
        throw new RuntimeException("Method getOutputImage in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void setVideoScalingMode(int n) {
        throw new RuntimeException("Method setVideoScalingMode in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void setAudioPresentation(@NonNull AudioPresentation presentation) {
        throw new RuntimeException("Method setAudioPresentation in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @NonNull
    public String getName() {
        throw new RuntimeException("Method getName in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @NonNull
    public String getCanonicalName() {
        throw new RuntimeException("Method getCanonicalName in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public PersistableBundle getMetrics() {
        throw new RuntimeException("Method getMetrics in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void setParameters(@Nullable Bundle params) {
        throw new RuntimeException("Method setParameters in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void setCallback(@Nullable Callback cb, @Nullable Handler handler) {
        throw new RuntimeException("Method setCallback in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void setCallback(@Nullable Callback cb) {
        throw new RuntimeException("Method setCallback in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void setOnFrameRenderedListener(@Nullable OnFrameRenderedListener listener, @Nullable Handler handler) {
        throw new RuntimeException("Method setOnFrameRenderedListener in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @NonNull
    public MediaCodecInfo getCodecInfo() {
        throw new RuntimeException("Method getCodecInfo in android.media.MediaCodec not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public static interface OnFrameRenderedListener {
        public void onFrameRendered(@NonNull MediaCodec var1, long var2, long var4);
    }

    public static class MetricsConstants {
        public static final String CODEC = "android.media.mediacodec.codec";
        public static final String ENCODER = "android.media.mediacodec.encoder";
        public static final String HEIGHT = "android.media.mediacodec.height";
        public static final String MIME_TYPE = "android.media.mediacodec.mime";
        public static final String MODE = "android.media.mediacodec.mode";
        public static final String MODE_AUDIO = "audio";
        public static final String MODE_VIDEO = "video";
        public static final String ROTATION = "android.media.mediacodec.rotation";
        public static final String SECURE = "android.media.mediacodec.secure";
        public static final String WIDTH = "android.media.mediacodec.width";

        MetricsConstants() {
        }
    }

    public static class CryptoInfo {
        public byte[] iv;
        public byte[] key;
        public int mode;
        public int[] numBytesOfClearData;
        public int[] numBytesOfEncryptedData;
        public int numSubSamples;

        public void set(int newNumSubSamples, @NonNull int[] newNumBytesOfClearData, @NonNull int[] newNumBytesOfEncryptedData, @NonNull byte[] newKey, @NonNull byte[] newIV, int newMode) {
            throw new RuntimeException("Method set in android.media.MediaCodec$CryptoInfo not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void setPattern(Pattern newPattern) {
            throw new RuntimeException("Method setPattern in android.media.MediaCodec$CryptoInfo not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public String toString() {
            throw new RuntimeException("Method toString in android.media.MediaCodec$CryptoInfo not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public static class Pattern {
            public Pattern(int blocksToEncrypt, int blocksToSkip) {
            }

            public void set(int blocksToEncrypt, int blocksToSkip) {
                throw new RuntimeException("Method set in android.media.MediaCodec$CryptoInfo$Pattern not mocked. See http://g.co/androidstudio/not-mocked for details.");
            }

            public int getSkipBlocks() {
                throw new RuntimeException("Method getSkipBlocks in android.media.MediaCodec$CryptoInfo$Pattern not mocked. See http://g.co/androidstudio/not-mocked for details.");
            }

            public int getEncryptBlocks() {
                throw new RuntimeException("Method getEncryptBlocks in android.media.MediaCodec$CryptoInfo$Pattern not mocked. See http://g.co/androidstudio/not-mocked for details.");
            }
        }
    }

    public static class CryptoException
    extends RuntimeException {
        public static final int ERROR_FRAME_TOO_LARGE = 8;
        public static final int ERROR_INSUFFICIENT_OUTPUT_PROTECTION = 4;
        public static final int ERROR_INSUFFICIENT_SECURITY = 7;
        public static final int ERROR_KEY_EXPIRED = 2;
        public static final int ERROR_LOST_STATE = 9;
        public static final int ERROR_NO_KEY = 1;
        public static final int ERROR_RESOURCE_BUSY = 3;
        public static final int ERROR_SESSION_NOT_OPENED = 5;
        public static final int ERROR_UNSUPPORTED_OPERATION = 6;

        public CryptoException(int errorCode, @Nullable String detailMessage) {
        }

        public int getErrorCode() {
            throw new RuntimeException("Method getErrorCode in android.media.MediaCodec$CryptoException not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }
    }

    public static class CodecException
    extends IllegalStateException {
        public static final int ERROR_INSUFFICIENT_RESOURCE = 1100;
        public static final int ERROR_RECLAIMED = 1101;

        CodecException(int errorCode, int actionCode, @Nullable String detailMessage) {
        }

        public boolean isTransient() {
            throw new RuntimeException("Method isTransient in android.media.MediaCodec$CodecException not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public boolean isRecoverable() {
            throw new RuntimeException("Method isRecoverable in android.media.MediaCodec$CodecException not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public int getErrorCode() {
            throw new RuntimeException("Method getErrorCode in android.media.MediaCodec$CodecException not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        @NonNull
        public String getDiagnosticInfo() {
            throw new RuntimeException("Method getDiagnosticInfo in android.media.MediaCodec$CodecException not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }
    }

    public static abstract class Callback {
        public abstract void onInputBufferAvailable(@NonNull MediaCodec var1, int var2);

        public abstract void onOutputBufferAvailable(@NonNull MediaCodec var1, int var2, @NonNull BufferInfo var3);

        public abstract void onError(@NonNull MediaCodec var1, @NonNull CodecException var2);

        public abstract void onOutputFormatChanged(@NonNull MediaCodec var1, @NonNull MediaFormat var2);
    }

    public static class BufferInfo {
        public int flags;
        public int offset;
        public long presentationTimeUs;
        public int size;

        public void set(int newOffset, int newSize, long newTimeUs, int newFlags) {
            throw new RuntimeException("Method set in android.media.MediaCodec$BufferInfo not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }
    }
}

