/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.solver.widgets;

import androidx.constraintlayout.solver.LinearSystem;
import androidx.constraintlayout.solver.widgets.ConstraintAnchor;
import androidx.constraintlayout.solver.widgets.ConstraintWidget;
import androidx.constraintlayout.solver.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.solver.widgets.Guideline;
import java.util.ArrayList;

public class ConstraintTableLayout
extends ConstraintWidgetContainer {
    private boolean mVerticalGrowth = true;
    private int mNumCols = 0;
    private int mNumRows = 0;
    private int mPadding = 8;
    private ArrayList<VerticalSlice> mVerticalSlices = new ArrayList();
    private ArrayList<HorizontalSlice> mHorizontalSlices = new ArrayList();
    private ArrayList<Guideline> mVerticalGuidelines = new ArrayList();
    private ArrayList<Guideline> mHorizontalGuidelines = new ArrayList();
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    private static final int ALIGN_FULL = 3;
    private LinearSystem system = null;

    public ConstraintTableLayout() {
    }

    public ConstraintTableLayout(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public ConstraintTableLayout(int width, int height) {
        super(width, height);
    }

    @Override
    public String getType() {
        return "ConstraintTableLayout";
    }

    public int getNumRows() {
        return this.mNumRows;
    }

    public int getNumCols() {
        return this.mNumCols;
    }

    public int getPadding() {
        return this.mPadding;
    }

    public String getColumnsAlignmentRepresentation() {
        int numSlices = this.mVerticalSlices.size();
        String result = "";
        for (int i = 0; i < numSlices; ++i) {
            VerticalSlice slice = this.mVerticalSlices.get(i);
            if (slice.alignment == 1) {
                result = result + "L";
                continue;
            }
            if (slice.alignment == 0) {
                result = result + "C";
                continue;
            }
            if (slice.alignment == 3) {
                result = result + "F";
                continue;
            }
            if (slice.alignment != 2) continue;
            result = result + "R";
        }
        return result;
    }

    public String getColumnAlignmentRepresentation(int column) {
        VerticalSlice slice = this.mVerticalSlices.get(column);
        if (slice.alignment == 1) {
            return "L";
        }
        if (slice.alignment == 0) {
            return "C";
        }
        if (slice.alignment == 3) {
            return "F";
        }
        if (slice.alignment == 2) {
            return "R";
        }
        return "!";
    }

    public void setNumCols(int num) {
        if (this.mVerticalGrowth && this.mNumCols != num) {
            this.mNumCols = num;
            this.setVerticalSlices();
            this.setTableDimensions();
        }
    }

    public void setNumRows(int num) {
        if (!this.mVerticalGrowth && this.mNumCols != num) {
            this.mNumRows = num;
            this.setHorizontalSlices();
            this.setTableDimensions();
        }
    }

    public boolean isVerticalGrowth() {
        return this.mVerticalGrowth;
    }

    public void setVerticalGrowth(boolean value) {
        this.mVerticalGrowth = value;
    }

    public void setPadding(int padding) {
        if (padding > 1) {
            this.mPadding = padding;
        }
    }

    public void setColumnAlignment(int column, int alignment) {
        if (column < this.mVerticalSlices.size()) {
            VerticalSlice slice = this.mVerticalSlices.get(column);
            slice.alignment = alignment;
            this.setChildrenConnections();
        }
    }

    public void cycleColumnAlignment(int column) {
        VerticalSlice slice = this.mVerticalSlices.get(column);
        switch (slice.alignment) {
            case 1: {
                slice.alignment = 0;
                break;
            }
            case 2: {
                slice.alignment = 1;
                break;
            }
            case 0: {
                slice.alignment = 2;
            }
        }
        this.setChildrenConnections();
    }

    public void setColumnAlignment(String alignment) {
        int n = alignment.length();
        for (int i = 0; i < n; ++i) {
            char c = alignment.charAt(i);
            if (c == 'L') {
                this.setColumnAlignment(i, 1);
                continue;
            }
            if (c == 'C') {
                this.setColumnAlignment(i, 0);
                continue;
            }
            if (c == 'F') {
                this.setColumnAlignment(i, 3);
                continue;
            }
            if (c == 'R') {
                this.setColumnAlignment(i, 2);
                continue;
            }
            this.setColumnAlignment(i, 0);
        }
    }

    @Override
    public ArrayList<Guideline> getVerticalGuidelines() {
        return this.mVerticalGuidelines;
    }

    @Override
    public ArrayList<Guideline> getHorizontalGuidelines() {
        return this.mHorizontalGuidelines;
    }

    @Override
    public void addToSolver(LinearSystem system) {
        super.addToSolver(system);
        int count = this.mChildren.size();
        if (count == 0) {
            return;
        }
        this.setTableDimensions();
        if (system == this.mSystem) {
            Guideline guideline;
            int i;
            int num = this.mVerticalGuidelines.size();
            for (i = 0; i < num; ++i) {
                guideline = this.mVerticalGuidelines.get(i);
                guideline.setPositionRelaxed(this.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                guideline.addToSolver(system);
            }
            num = this.mHorizontalGuidelines.size();
            for (i = 0; i < num; ++i) {
                guideline = this.mHorizontalGuidelines.get(i);
                guideline.setPositionRelaxed(this.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                guideline.addToSolver(system);
            }
            for (i = 0; i < count; ++i) {
                ConstraintWidget child = (ConstraintWidget)this.mChildren.get(i);
                child.addToSolver(system);
            }
        }
    }

    public void setTableDimensions() {
        int extra = 0;
        int count = this.mChildren.size();
        for (int i = 0; i < count; ++i) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            extra += widget.getContainerItemSkip();
        }
        count += extra;
        if (this.mVerticalGrowth) {
            int rows;
            if (this.mNumCols == 0) {
                this.setNumCols(1);
            }
            if ((rows = count / this.mNumCols) * this.mNumCols < count) {
                ++rows;
            }
            if (this.mNumRows == rows && this.mVerticalGuidelines.size() == this.mNumCols - 1) {
                return;
            }
            this.mNumRows = rows;
            this.setHorizontalSlices();
        } else {
            int cols;
            if (this.mNumRows == 0) {
                this.setNumRows(1);
            }
            if ((cols = count / this.mNumRows) * this.mNumRows < count) {
                ++cols;
            }
            if (this.mNumCols == cols && this.mHorizontalGuidelines.size() == this.mNumRows - 1) {
                return;
            }
            this.mNumCols = cols;
            this.setVerticalSlices();
        }
        this.setChildrenConnections();
    }

    @Override
    public void setDebugSolverName(LinearSystem s, String name) {
        this.system = s;
        super.setDebugSolverName(s, name);
        this.updateDebugSolverNames();
    }

    private void updateDebugSolverNames() {
        int i;
        if (this.system == null) {
            return;
        }
        int num = this.mVerticalGuidelines.size();
        for (i = 0; i < num; ++i) {
            this.mVerticalGuidelines.get(i).setDebugSolverName(this.system, this.getDebugName() + ".VG" + i);
        }
        num = this.mHorizontalGuidelines.size();
        for (i = 0; i < num; ++i) {
            this.mHorizontalGuidelines.get(i).setDebugSolverName(this.system, this.getDebugName() + ".HG" + i);
        }
    }

    private void setVerticalSlices() {
        float increment;
        this.mVerticalSlices.clear();
        ConstraintWidget previous = this;
        float percent = increment = 100.0f / (float)this.mNumCols;
        for (int i = 0; i < this.mNumCols; ++i) {
            VerticalSlice slice = new VerticalSlice();
            slice.left = previous;
            if (i < this.mNumCols - 1) {
                Guideline guideline = new Guideline();
                guideline.setOrientation(1);
                guideline.setParent(this);
                guideline.setGuidePercent((int)percent);
                percent += increment;
                slice.right = guideline;
                this.mVerticalGuidelines.add(guideline);
            } else {
                slice.right = this;
            }
            previous = slice.right;
            this.mVerticalSlices.add(slice);
        }
        this.updateDebugSolverNames();
    }

    private void setHorizontalSlices() {
        float increment;
        this.mHorizontalSlices.clear();
        float percent = increment = 100.0f / (float)this.mNumRows;
        ConstraintWidget previous = this;
        for (int i = 0; i < this.mNumRows; ++i) {
            HorizontalSlice slice = new HorizontalSlice();
            slice.top = previous;
            if (i < this.mNumRows - 1) {
                Guideline guideline = new Guideline();
                guideline.setOrientation(0);
                guideline.setParent(this);
                guideline.setGuidePercent((int)percent);
                percent += increment;
                slice.bottom = guideline;
                this.mHorizontalGuidelines.add(guideline);
            } else {
                slice.bottom = this;
            }
            previous = slice.bottom;
            this.mHorizontalSlices.add(slice);
        }
        this.updateDebugSolverNames();
    }

    private void setChildrenConnections() {
        int count = this.mChildren.size();
        int index = 0;
        for (int i = 0; i < count; ++i) {
            ConstraintWidget target = (ConstraintWidget)this.mChildren.get(i);
            int col = (index += target.getContainerItemSkip()) % this.mNumCols;
            int row = index / this.mNumCols;
            HorizontalSlice horizontalSlice = this.mHorizontalSlices.get(row);
            VerticalSlice verticalSlice = this.mVerticalSlices.get(col);
            ConstraintWidget targetLeft = verticalSlice.left;
            ConstraintWidget targetRight = verticalSlice.right;
            ConstraintWidget targetTop = horizontalSlice.top;
            ConstraintWidget targetBottom = horizontalSlice.bottom;
            target.getAnchor(ConstraintAnchor.Type.LEFT).connect(targetLeft.getAnchor(ConstraintAnchor.Type.LEFT), this.mPadding);
            if (targetRight instanceof Guideline) {
                target.getAnchor(ConstraintAnchor.Type.RIGHT).connect(targetRight.getAnchor(ConstraintAnchor.Type.LEFT), this.mPadding);
            } else {
                target.getAnchor(ConstraintAnchor.Type.RIGHT).connect(targetRight.getAnchor(ConstraintAnchor.Type.RIGHT), this.mPadding);
            }
            switch (verticalSlice.alignment) {
                case 3: {
                    target.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
                    break;
                }
                case 1: {
                    target.getAnchor(ConstraintAnchor.Type.LEFT).setStrength(ConstraintAnchor.Strength.STRONG);
                    target.getAnchor(ConstraintAnchor.Type.RIGHT).setStrength(ConstraintAnchor.Strength.WEAK);
                    break;
                }
                case 2: {
                    target.getAnchor(ConstraintAnchor.Type.LEFT).setStrength(ConstraintAnchor.Strength.WEAK);
                    target.getAnchor(ConstraintAnchor.Type.RIGHT).setStrength(ConstraintAnchor.Strength.STRONG);
                }
            }
            target.getAnchor(ConstraintAnchor.Type.TOP).connect(targetTop.getAnchor(ConstraintAnchor.Type.TOP), this.mPadding);
            if (targetBottom instanceof Guideline) {
                target.getAnchor(ConstraintAnchor.Type.BOTTOM).connect(targetBottom.getAnchor(ConstraintAnchor.Type.TOP), this.mPadding);
            } else {
                target.getAnchor(ConstraintAnchor.Type.BOTTOM).connect(targetBottom.getAnchor(ConstraintAnchor.Type.BOTTOM), this.mPadding);
            }
            ++index;
        }
    }

    @Override
    public void updateFromSolver(LinearSystem system) {
        super.updateFromSolver(system);
        if (system == this.mSystem) {
            Guideline guideline;
            int i;
            int num = this.mVerticalGuidelines.size();
            for (i = 0; i < num; ++i) {
                guideline = this.mVerticalGuidelines.get(i);
                guideline.updateFromSolver(system);
            }
            num = this.mHorizontalGuidelines.size();
            for (i = 0; i < num; ++i) {
                guideline = this.mHorizontalGuidelines.get(i);
                guideline.updateFromSolver(system);
            }
        }
    }

    @Override
    public boolean handlesInternalConstraints() {
        return true;
    }

    public void computeGuidelinesPercentPositions() {
        int i;
        int num = this.mVerticalGuidelines.size();
        for (i = 0; i < num; ++i) {
            this.mVerticalGuidelines.get(i).inferRelativePercentPosition();
        }
        num = this.mHorizontalGuidelines.size();
        for (i = 0; i < num; ++i) {
            this.mHorizontalGuidelines.get(i).inferRelativePercentPosition();
        }
    }

    class VerticalSlice {
        ConstraintWidget left;
        ConstraintWidget right;
        int alignment = 1;
        int padding;

        VerticalSlice() {
        }
    }

    class HorizontalSlice {
        ConstraintWidget top;
        ConstraintWidget bottom;
        int padding;

        HorizontalSlice() {
        }
    }
}

