package de.dim.diamant;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.floatingactionbutton.FloatingActionButton;

import de.dim.diamant.adapter.ProductListAdapter;
import de.dim.diamant.dialogs.ProductDialogBuilder;
import de.dim.diamant.divider.SimpleDividerItemDecoration;
import de.dim.diamant.model.Product;
import de.dim.diamant.settings.SettingsActivity;

public class ProductActivity extends AppCompatActivity implements DialogInterface.OnClickListener {

    private ProductListAdapter productListAdapter;
    private ProductDialogBuilder dialogBuilder;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setTitle(R.string.product_title);
        setContentView(R.layout.activity_product);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
        dialogBuilder = new ProductDialogBuilder(this);

        FloatingActionButton newFab = (FloatingActionButton) findViewById(R.id.newProduct);
        newFab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                AlertDialog dialog = dialogBuilder.create();
                dialog.show();
            }
        });
        FloatingActionButton scanFab = (FloatingActionButton) findViewById(R.id.scanProduct);
        scanFab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(ProductActivity.this, ScanProduct.class));
            }
        });
        RecyclerView productList = findViewById(R.id.product_list);
        registerForContextMenu(productList);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this);
        productList.setLayoutManager(layoutManager);
        productList.addItemDecoration(new SimpleDividerItemDecoration(this));
        productListAdapter = new ProductListAdapter(this);
        productList.setAdapter(productListAdapter);
        productListAdapter.notifyDataSetChanged();

    }

    @Override
    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        super.onCreateContextMenu(menu, v, menuInfo);
        // Add context menu to the product list view
        if (v.getId() == R.id.product_list) {
            getMenuInflater().inflate(R.menu.product_context, menu);
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_product, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            startActivity(new Intent(this, SettingsActivity.class));
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public boolean onContextItemSelected(@NonNull MenuItem item) {
        Product product = productListAdapter.getSelected();
        switch (item.getItemId()) {
            case R.id.newOutbound:
                if (product != null) {
                    Intent intent = new Intent(this, OutboundActivity.class);
                    intent.putExtra(Product.EXTRA_PRODUCT, product);
                    startActivity(intent);
                    return true;
                }
            case R.id.scanOutbound:
            if (product != null) {
                Intent intent = new Intent(this, ScanOutbound.class);
                intent.putExtra(Product.EXTRA_PRODUCT, product);
                startActivity(intent);
                return true;
            }
            case R.id.transactions:
            if (product != null) {
                Intent intent = new Intent(this, TransactionActivity.class);
                intent.putExtra(Product.EXTRA_PRODUCT, product);
                startActivity(intent);
                return true;
            }
        }
        return super.onContextItemSelected(item);
    }

    @Override
    public void onClick(DialogInterface dialogInterface, int i) {
        Product product = dialogBuilder.updateProduct();
        if (product == null) {
            return;
        }
        switch (i) {
            case DialogInterface.BUTTON_POSITIVE:
                productListAdapter.addProduct(product);
                break;
            default:
                break;
        }
    }

}
