package de.dim.diamant;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.util.Log;

import com.google.zxing.Result;

import de.dim.diamant.dialogs.ProductDialogBuilder;
import de.dim.diamant.model.ModelCache;
import de.dim.diamant.model.Product;

public class ScanProduct extends ScanActivity {

    @Override
    public void handleResult(Result result) {
        final String scanResult = result.getText();
        Log.e("SCAN", "" + scanResult);
        final Product product = ModelCache.createProduct(scanResult);
        ProductDialogBuilder dialogBuilder = new ProductDialogBuilder(this, product);
        dialogBuilder.setTitle("Scan Ergebnis");
        dialogBuilder.setMessage(scanResult);
        dialogBuilder.setNeutralButton("Noch einmal", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                scannerView.resumeCameraPreview(ScanProduct.this);
            }
        });
        dialogBuilder.setPositiveButton("Speichern", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                Product updated = dialogBuilder.updateProduct();
                ModelCache.getInstance(ScanProduct.this).addProduct(updated);
                Intent intent = new Intent(ScanProduct.this, ProductActivity.class);
                startActivity(intent);
            }
        });

        AlertDialog alert = dialogBuilder.create();
        alert.show();

    }

}
