package de.dim.diamant.adapter;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import de.dim.diamant.R;
import de.dim.diamant.model.ModelCache;
import de.dim.diamant.model.OutboundLogistic;
import de.dim.diamant.model.Product;

public class OutboundListAdapter extends RecyclerView.Adapter<OutboundListAdapter.OutboundListHolder> {

    private final LayoutInflater layoutInflater;
    private final Product product;
    private final ModelCache cache;

    class OutboundListHolder extends RecyclerView.ViewHolder {
        // each data item is just a string in this case
        TextView productView;
        TextView trackingView;
        TextView providerView;
        TextView addressView;


        OutboundListHolder(View v) {
            super(v);
            productView = v.findViewById(R.id.product);
            trackingView = v.findViewById(R.id.tracking);
            providerView = v.findViewById(R.id.provider);
            addressView = v.findViewById(R.id.address);
        }

        void update(OutboundLogistic outbound) {
            productView.setText(outbound.getProduct().getDescription());
            providerView.setText(outbound.getProvider());
            trackingView.setText(outbound.getTrackingId());
            addressView.setText(outbound.getTargetAddress());
        }

    }

    public OutboundListAdapter(Context context, Product product) {
        this.layoutInflater = LayoutInflater.from(context);
        this.product = product;
        cache = ModelCache.getInstance(context);
    }

    @NonNull
    @Override
    public OutboundListHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = layoutInflater.inflate(R.layout.outbound_item, parent, false);
        return new OutboundListHolder(view);

    }

    @Override
    public void onBindViewHolder(@NonNull OutboundListHolder holder, int position) {
        OutboundLogistic outbound = cache.getOutbound(product, position);
        holder.update(outbound);
    }

    @Override
    public int getItemCount() {
        return cache.getOutbounds(product).size();
    }

    public void addOutbound(OutboundLogistic outbound) {
        if (outbound == null) {
            Log.e("outboundListAdapter", "addOutbound: Error adding a null instance");
            return;
        }
        cache.addOutbound(outbound);
        notifyDataSetChanged();
    }
}
