package de.dim.diamant.adapter;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.text.DateFormat;

import de.dim.diamant.R;
import de.dim.diamant.model.ModelCache;
import de.dim.diamant.model.OutboundLogistic;
import de.dim.diamant.model.Product;
import de.dim.diamant.model.TransactionEntry;

public class TransactionEntryListAdapter extends RecyclerView.Adapter<TransactionEntryListAdapter.TransactionListHolder> {

    private final LayoutInflater layoutInflater;
    private final Product product;
    private final ModelCache cache;

    class TransactionListHolder extends RecyclerView.ViewHolder {
        // each data item is just a string in this case
        TextView productView;
        TextView descriptionView;
        TextView typeView;
        TextView timestampView;


        TransactionListHolder(View v) {
            super(v);
            productView = v.findViewById(R.id.entryProduct);
            descriptionView = v.findViewById(R.id.entryDescription);
            typeView = v.findViewById(R.id.entryType);
            timestampView = v.findViewById(R.id.entryTimestamp);
        }

        void update(TransactionEntry entry) {
            productView.setText(entry.getProduct().getDescription());
            String type = entry.getType() == null ? "assetTransaction " + entry.getChangeType() : entry.getType();
            typeView.setText(type);
            descriptionView.setText(entry.getDescription());
            timestampView.setText(DateFormat.getDateTimeInstance().format(entry.getTimestamp()));
        }

    }

    public TransactionEntryListAdapter(Context context, Product product) {
        this.layoutInflater = LayoutInflater.from(context);
        this.product = product;
        cache = ModelCache.getInstance(context);
    }

    @NonNull
    @Override
    public TransactionListHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = layoutInflater.inflate(R.layout.transaction_item, parent, false);
        return new TransactionListHolder(view);

    }

    @Override
    public void onBindViewHolder(@NonNull TransactionListHolder holder, int position) {
        TransactionEntry entry = cache.getTransaction(product, position);
        holder.update(entry);
    }

    @Override
    public int getItemCount() {
        return cache.getTransactions(product).size();
    }

}
