package de.dim.diamant.dialogs;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

import de.dim.diamant.R;
import de.dim.diamant.model.OutboundLogistic;
import de.dim.diamant.model.Product;

public class OutboundDialogBuilder extends AlertDialog.Builder {

    private OutboundLogistic outboundLogistic = null;
    TextView productNameView;
    TextView address;
    TextView tracking;
    TextView timestamp;
    TextView provider;

    public OutboundDialogBuilder(Context context, Product product) {
        super(context);
        outboundLogistic = new OutboundLogistic(product);
        setTitle(R.string.outbound_title);
        setMessage(R.string.oubound_message);
        if (context instanceof DialogInterface.OnClickListener) {
            setPositiveButton(R.string.ok, (DialogInterface.OnClickListener) context);
            setNegativeButton(R.string.cancel, (DialogInterface.OnClickListener) context);
        }
    }
    public OutboundDialogBuilder(Context context, OutboundLogistic outbound) {
        super(context);
        outboundLogistic = outbound;
        setTitle(R.string.outbound_title);
        setMessage(R.string.oubound_message);
        if (context instanceof DialogInterface.OnClickListener) {
            setPositiveButton(R.string.ok, (DialogInterface.OnClickListener) context);
            setNegativeButton(R.string.cancel, (DialogInterface.OnClickListener) context);
        }
    }

    @Override
    public AlertDialog create() {
        AlertDialog dialog = super.create();
        LayoutInflater inflater = dialog.getLayoutInflater();
        View view = inflater.inflate(R.layout.outbound_dialog, null);
        dialog.setView(view);
        productNameView = view.findViewById(R.id.outboundProductLabel);
        productNameView.setText(outboundLogistic.getProduct().getDescription());
        address = view.findViewById(R.id.outboundAddressEdit);
        tracking = view.findViewById(R.id.outboundTrackingEdit);
        if (outboundLogistic.getTrackingId() != null) {
            tracking.setText(outboundLogistic.getTrackingId());
        }
        timestamp = view.findViewById(R.id.outboundTimeEdit);
        timestamp.setText(DateFormat.getDateTimeInstance().format(new Date()));
        provider = view.findViewById(R.id.outboundProviderEdit);
        if (outboundLogistic.getProvider() != null) {
            provider.setText(outboundLogistic.getProvider());
        }
        return dialog;
    }

    public OutboundLogistic updateOutbound() {
        if (outboundLogistic == null) {
            return null;
        }
        outboundLogistic.setProvider(provider.getText().toString());
        outboundLogistic.setTargetAddress(address.getText().toString());
        outboundLogistic.setTrackingId(tracking.getText().toString());
        try {
            outboundLogistic.setTimestamp(DateFormat.getDateTimeInstance().parse(timestamp.getText().toString()));
        } catch (ParseException e) {
            Log.e("Outbound", "Error parsing date string", e);
        }
        return outboundLogistic;
    }

}
