package de.dim.diamant.dialogs;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;

import de.dim.diamant.R;
import de.dim.diamant.model.Product;

public class ProductDialogBuilder extends AlertDialog.Builder {

    private Product product = null;
    TextView productNameView;
    TextView productEANView;
    TextView productSerialView;

    public ProductDialogBuilder(Context context) {
        this(context, null);
    }

    public ProductDialogBuilder(Context context, Product product) {
        super(context);
        this.product = product;
        setTitle(R.string.product_label);
        setMessage(R.string.product_message);
        if (context instanceof DialogInterface.OnClickListener) {
            setPositiveButton(R.string.ok, (DialogInterface.OnClickListener) context);
            setNegativeButton(R.string.cancel, (DialogInterface.OnClickListener) context);
        }
    }

    @Override
    public AlertDialog create() {
        AlertDialog dialog = super.create();
        LayoutInflater inflater = dialog.getLayoutInflater();
        View view = inflater.inflate(R.layout.product_dialog, null);
        dialog.setView(view);
        productNameView = view.findViewById(R.id.productDescriptionEdit);
        productEANView = view.findViewById(R.id.productEanEdit);
        productSerialView = view.findViewById(R.id.productSerialEdit);
        if (product != null) {
            if (product.getDescription() != null) {
                productNameView.setText(product.getDescription());
            }
            if (product.getEan() != null) {
                productEANView.setText(product.getEan());
            }
            if (product.getSerial() != null) {
                productSerialView.setText(product.getSerial());
            }
        } else {
            product = new Product();
        }
    return dialog;
    }

    public Product updateProduct() {
        if (product == null) {
            return null;
        }
        product.setDescription(productNameView.getText().toString());
        product.setEan(productEANView.getText().toString());
        product.setSerial(productSerialView.getText().toString());
        return product;
    }

}
