package de.dim.diamant.model;

import com.google.gson.annotations.SerializedName;

import java.io.Serializable;
import java.util.Date;

public class OutboundLogistic implements Serializable {

    public static final String EXTRA_OUTBOUND = "extra.outbound";
    @SerializedName("_type")
    private String type = "http://datainmotion.de/diamant/1.0#//OutboundLogistic";
    private final Product product;
    private String id;
    private String provider = "";
    private String trackingId;
    private String targetAddress;
    private String assetId;
    private Date timestamp;

    public OutboundLogistic(Product product) {
        this.product = product;
        this.assetId = product.getId();
    }

    public OutboundLogistic(TransactionEntry entry) {
        this.product = entry.getProduct();
        this.assetId = entry.getProduct().getId();
        this.id = entry.getId();
        this.timestamp = entry.getTimestamp();
        if (entry.getProvider() != null) {
            this.provider = entry.getProvider();
        }
        this.targetAddress = entry.getAddress();
        this.trackingId = entry.getTrackingId();
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public Date getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getProvider() {
        return provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getTrackingId() {
        return trackingId;
    }

    public void setTrackingId(String trackingId) {
        this.trackingId = trackingId;
    }

    public String getTargetAddress() {
        return targetAddress;
    }

    public void setTargetAddress(String targetAddress) {
        this.targetAddress = targetAddress;
    }

    public Product getProduct() {
        return product;
    }

    public String getAssetId() {
        return assetId;
    }
}