package de.dim.diamant.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;

import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;

import de.dim.diamant.connection.BackendService;

public class OutboundSerializer implements JsonSerializer<OutboundLogistic> {

    private static final String DATA_TYPE = "http://datainmotion.de/diamant/1.0#//OutboundLogistic";
    private static final String TRANSACTION_ID = "outboundLogisticsX";

    @Override
    public JsonElement serialize(OutboundLogistic outbound, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();

        object.add("_type", context.serialize(DATA_TYPE));
        object.add("assetId", context.serialize(outbound.getAssetId()));
        object.add("transactionId", context.serialize(TRANSACTION_ID));
        object.add("participantId", context.serialize(BackendService.PARTICIPANT));
        object.add("comment", context.serialize("Outbound logistic for product " + outbound.getAssetId()));
        Date timestamp = outbound.getTimestamp() == null ? new Date() : outbound.getTimestamp();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        object.add("timestamp", context.serialize(sdf.format(timestamp)));
        object.add("transportationProvider", context.serialize(outbound.getProvider()));
        object.add("transportationTrackingId", context.serialize(outbound.getTrackingId()));
        object.add("targetAddress", context.serialize(outbound.getTargetAddress()));
        object.add("assetId", context.serialize(outbound.getAssetId()));
        //object.add("timestamp", context.serialize(outbound.getTimestamp()));
        // ...
        return object;
    }

}