package de.dim.diamant.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;

import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import de.dim.diamant.connection.BackendService;

public class ProductSerializer implements JsonSerializer<Product> {

    private static final String DATA_TYPE = "http://datainmotion.de/diamant/1.0#//Product";

    @Override
    public JsonElement serialize(Product product, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();

        object.add("_type", context.serialize(DATA_TYPE));
        object.add("description", context.serialize(product.getDescription()));
        object.add("rawUDI", context.serialize(product.getEan()+product.getSerial()));
        object.add("serialNumber", context.serialize(product.getSerial()));
        object.add("lot", context.serialize("1"));
        Calendar c = Calendar.getInstance();
        c.add(Calendar.DAY_OF_YEAR, 400);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        object.add("expirationDate", context.serialize(sdf.format(c.getTime())));
        object.add("articleNumberRef", context.serialize(product.getEan()));
        object.add("creatorId", context.serialize(BackendService.PARTICIPANT));
        object.add("ownerId", context.serialize(BackendService.PARTICIPANT));
        object.add("vendor", context.serialize("Königsee Implantate GmbH"));
        return object;
    }

}