package de.dim.diamant;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;

import com.google.zxing.Result;

import de.dim.diamant.dialogs.OutboundDialogBuilder;
import de.dim.diamant.model.ModelCache;
import de.dim.diamant.model.OutboundLogistic;
import de.dim.diamant.model.Product;

public class ScanOutbound extends ScanActivity {

    private Product product = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        product = (Product) getIntent().getSerializableExtra(Product.EXTRA_PRODUCT);
    }

    @Override
    public void handleResult(Result result) {
        final String scanResult = result.getText();
        Log.e("SCAN", "" + scanResult);
        final OutboundLogistic outbound = ModelCache.createOutboundLogistic(scanResult, product);
        final OutboundDialogBuilder dialogBuilder = new OutboundDialogBuilder(this, outbound);
        dialogBuilder.setTitle("Scan Ergebnis");
        dialogBuilder.setMessage(scanResult);
        dialogBuilder.setNeutralButton("Noch einmal", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                scannerView.resumeCameraPreview(ScanOutbound.this);
            }
        });
        dialogBuilder.setPositiveButton("Speichern", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                OutboundLogistic updated = dialogBuilder.updateOutbound();
                ModelCache.getInstance(ScanOutbound.this).addOutbound(updated);
                Intent intent = new Intent(ScanOutbound.this, OutboundActivity.class);
                intent.putExtra(Product.EXTRA_PRODUCT, product);
                startActivity(intent);
            }
        });

        AlertDialog alert = dialogBuilder.create();
        alert.show();

    }

}
