package de.dim.diamant;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.floatingactionbutton.FloatingActionButton;

import de.dim.diamant.adapter.OutboundListAdapter;
import de.dim.diamant.adapter.TransactionEntryListAdapter;
import de.dim.diamant.dialogs.OutboundDialogBuilder;
import de.dim.diamant.divider.SimpleDividerItemDecoration;
import de.dim.diamant.model.OutboundLogistic;
import de.dim.diamant.model.Product;

public class TransactionActivity extends AppCompatActivity {

    private TransactionEntryListAdapter transactionListAdapter;
    private Product product;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_transaction);
        Toolbar toolbar = findViewById(R.id.transaction_toolbar);
        setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        RecyclerView transactionList = findViewById(R.id.transaction_list);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this);
        transactionList.setLayoutManager(layoutManager);
        transactionList.addItemDecoration(new SimpleDividerItemDecoration(this));
        product = (Product) getIntent().getSerializableExtra(Product.EXTRA_PRODUCT);
        transactionListAdapter = new TransactionEntryListAdapter(this, product);
        transactionList.setAdapter(transactionListAdapter);
        transactionListAdapter.notifyDataSetChanged();
    }

}
