package de.dim.diamant.adapter;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import de.dim.diamant.R;
import de.dim.diamant.model.ModelCache;
import de.dim.diamant.model.Product;

public class ProductListAdapter extends RecyclerView.Adapter<ProductListAdapter.ProductListHolder> {

    private final Context context;
    private final LayoutInflater layoutInflater;
    private ModelCache cache;
    private Product selected = null;

    class ProductListHolder extends RecyclerView.ViewHolder {
        // each data item is just a string in this case
        TextView productNameView;
        TextView productEANView;
        TextView productSerialView;


        ProductListHolder(View view) {
            super(view);
            productNameView = view.findViewById(R.id.productDescription);
            productEANView = view.findViewById(R.id.productEan);
            productSerialView = view.findViewById(R.id.productSerial);
            view.setOnCreateContextMenuListener((View.OnCreateContextMenuListener) context);
        }

        void update(Product product) {
            productNameView.setText(product.getDescription());
            productSerialView.setText(product.getSerial());
            productEANView.setText(product.getEan());
        }

    }

    public ProductListAdapter(Context context) {
        this.context = context;
        this.layoutInflater = LayoutInflater.from(context);
        this.cache = ModelCache.getInstance(context);
        cache.getProducts();
    }

    @NonNull
    @Override
    public ProductListAdapter.ProductListHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = layoutInflater.inflate(R.layout.product_item, parent, false);
        return new ProductListHolder(view);

    }

    @Override
    public void onBindViewHolder(@NonNull ProductListAdapter.ProductListHolder holder, int position) {
        Product product = cache.getProduct(position);
        holder.update(product);
        holder.itemView.setOnLongClickListener(new View.OnLongClickListener(){
            @Override
            public boolean onLongClick(View view) {
                int pos = holder.getAdapterPosition();
                if (pos >= 0 && pos < cache.getProducts().size()) {
                    selected = cache.getProduct(pos);
                }
                return false;
            }
        });
    }

    @Override
    public void onViewRecycled(@NonNull ProductListHolder holder) {
        holder.itemView.setOnLongClickListener(null);
        super.onViewRecycled(holder);
    }

    @Override
    public int getItemCount() {
        return cache.getProductsSize();
    }

    public Product getSelected() {
        return selected;
    }

    public void addProduct(Product product) {
        if (product == null) {
            Log.e("ProductListAdapter", "addProduct: Error adding a null product");
            return;
        }
        cache.addProduct(product);
        notifyDataSetChanged();
    }
}
