package de.dim.diamant.connection;

import android.os.AsyncTask;
import android.util.Log;

import com.google.gson.Gson;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import de.dim.diamant.model.OutboundLogistic;
import de.dim.diamant.model.Product;
import de.dim.diamant.model.ProductResult;
import de.dim.diamant.model.TransactionEntry;
import de.dim.diamant.model.TransactionResult;

public class BackendService extends ConnectionFacade {

    private static final String CONTENT_TYPE = "application/json";// Content-Type, Accept
    public static final String PARTICIPANT = "5d6f6f48e793b80f97cdb4c1";
    private static final String AUTHORIZATION = "Bearer " + PARTICIPANT;//Authorization
    private static final String URL = "http://192.168.1.113:8080/rest";
    private static final Map<String, String> header = new HashMap<>();

    static {
        header.put("Content-Type", CONTENT_TYPE);
        header.put("Accept", CONTENT_TYPE);
        header.put("Authorization", AUTHORIZATION);
    }

    /**
     * Constructor with default data and GUID parameter
     *
     */
    public BackendService(String url) {
        super(url);
        //super(URL);
    }

    public void setUrl(String url) {
        setConnectionURL(url);
    }

    public List<Product> getProducts() {
        try {
            AsyncTask<String, Integer, List<Product>> task = new AsyncTask<String, Integer, List<Product>>() {
                @Override
                protected List<Product> doInBackground(String... strings) {
                    ProductResult result = sendGetRequest(ProductResult.class, strings[0]);
                    return result == null ? null : result.products;
                }
            };
            return task.execute("/product").get(10, TimeUnit.SECONDS);
        } catch (Exception e) {
            Log.e("BackendService  ", "getProducts: Error getting products", e);
        }
        return null;
    }

    public List<TransactionEntry> getEntries(Product product) {
        try {
            AsyncTask<String, Integer, List<TransactionEntry>> task = new AsyncTask<String, Integer, List<TransactionEntry>>() {
                @Override
                protected List<TransactionEntry> doInBackground(String... strings) {
                    TransactionResult result = sendGetRequest(TransactionResult.class, strings[0]);
                    if (result != null && result.entries != null) {
                        result.entries.forEach(e->e.setProduct(product));
                    }
                    return result == null ? null : result.entries;
                }
            };
            return task.execute("/entry/" + product.getId()).get(10, TimeUnit.SECONDS);
        } catch (Exception e) {
            Log.e("BackendService  ", "getProducts: Error getting products", e);
        }
        return null;
    }

    public void createOutbound(final OutboundLogistic outbound) {
        try {
            AsyncTask<String, Integer, Void> task = new AsyncTask<String, Integer, Void>() {
                @Override
                protected Void doInBackground(String... strings) {
                    sendPostRequest(outbound, strings[0]);
                    return null;
                }
            };
            task.execute("/entry/" + outbound.getAssetId()).get(10, TimeUnit.SECONDS);
        } catch (Exception e) {
            Log.e("BackendService  ", "createOutbound: Error creating outbounds", e);
        }
    }

    public void createProduct(final Product product) {
        try {
            AsyncTask<String, Integer, Void> task = new AsyncTask<String, Integer, Void>() {
                @Override
                protected Void doInBackground(String... strings) {
                    sendPostRequest(product, strings[0]);
                    return null;
                }
            };
            String path = "/product";
            if (product.getId() != null) {
                path += "/" + product.getId();
            }
            task.execute(path).get(10, TimeUnit.SECONDS);
        } catch (Exception e) {
            Log.e("BackendService  ", "createProduct: Error creating product", e);
        }
    }

    @Override
    protected Map<String, String> getHeaderMap() {
        return header;
    }
}
