package de.dim.diamant;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;

import com.google.android.material.floatingactionbutton.FloatingActionButton;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.view.View;

import de.dim.diamant.adapter.OutboundListAdapter;
import de.dim.diamant.dialogs.OutboundDialogBuilder;
import de.dim.diamant.divider.SimpleDividerItemDecoration;
import de.dim.diamant.model.OutboundLogistic;
import de.dim.diamant.model.Product;

public class OutboundActivity extends AppCompatActivity implements DialogInterface.OnClickListener {

    private OutboundListAdapter outboundListAdapter;
    private OutboundDialogBuilder dialogBuilder;
    private Product product;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_outbound);
        Toolbar toolbar = findViewById(R.id.outbound_toolbar);
        setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        RecyclerView outboundList = findViewById(R.id.outbound_list);
        registerForContextMenu(outboundList);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this);
        outboundList.setLayoutManager(layoutManager);
        outboundList.addItemDecoration(new SimpleDividerItemDecoration(this));
        product = (Product) getIntent().getSerializableExtra(Product.EXTRA_PRODUCT);
        dialogBuilder = new OutboundDialogBuilder(this, product);
        outboundListAdapter = new OutboundListAdapter(this, product);
        outboundList.setAdapter(outboundListAdapter);
        outboundListAdapter.notifyDataSetChanged();
        FloatingActionButton fabNewOutbound = findViewById(R.id.newOutbound);
        fabNewOutbound.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                AlertDialog dialog = dialogBuilder.create();
                dialog.show();
            }
        });
        FloatingActionButton fabScanOutbound = findViewById(R.id.scanOutbound);
        fabScanOutbound.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intent = new Intent(OutboundActivity.this, ScanOutbound.class);
                intent.putExtra(Product.EXTRA_PRODUCT, product);
                startActivity(intent);
            }
        });
    }

    @Override
    public void onClick(DialogInterface dialogInterface, int i) {
        OutboundLogistic outbound = dialogBuilder.updateOutbound();
        if (outbound == null) {
            return;
        }
        switch (i) {
            case DialogInterface.BUTTON_POSITIVE:
                outboundListAdapter.addOutbound(outbound);
                break;
            default:
                break;
        }
    }

}
