package de.dim.diamant.model;

import com.google.gson.annotations.SerializedName;

import java.io.Serializable;
import java.util.Date;

public class TransactionEntry implements Serializable {

    public static final String EXTRA_OUTBOUND = "extra.outbound";
    transient private Product product;
    private String id;
    @SerializedName("transactionId")
    private String type;
    @SerializedName("comment")
    private String description;
    private String changeType;
    private Date timestamp;
    @SerializedName("transportationProvider")
    private String provider;
    @SerializedName("transportationTrackingId")
    private String trackingId;
    @SerializedName("targetAddress")
    private String address;

    public TransactionEntry(Product product) {
        this.product = product;
    }

    public TransactionEntry() {}

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public Date getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Product getProduct() {
        return product;
    }

    public String getAddress() {
        return address;
    }

    public String getProvider() {
        return provider;
    }

    public String getTrackingId() {
        return trackingId;
    }
}