/*
 * Decompiled with CFR 0.152.
 */
package worker.org.gradle.internal.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import worker.org.gradle.internal.classloader.ClassLoaderHierarchy;
import worker.org.gradle.internal.classloader.ClassLoaderSpec;
import worker.org.gradle.internal.classloader.ClassLoaderUtils;
import worker.org.gradle.internal.classloader.ClassLoaderVisitor;
import worker.org.gradle.internal.util.Trie;

public class FilteringClassLoader
extends ClassLoader
implements ClassLoaderHierarchy {
    private static final ClassLoader EXT_CLASS_LOADER;
    private static final Set<String> SYSTEM_PACKAGES;
    public static final String DEFAULT_PACKAGE = "DEFAULT";
    private final Set<String> packageNames;
    private final TrieSet packagePrefixes;
    private final TrieSet resourcePrefixes;
    private final Set<String> resourceNames;
    private final Set<String> classNames;
    private final Set<String> disallowedClassNames;
    private final TrieSet disallowedPackagePrefixes;

    public FilteringClassLoader(ClassLoader parent, Spec spec) {
        super(parent);
        this.packageNames = new HashSet<String>(spec.packageNames);
        this.packagePrefixes = new TrieSet(spec.packagePrefixes);
        this.resourceNames = new HashSet<String>(spec.resourceNames);
        this.resourcePrefixes = new TrieSet(spec.resourcePrefixes);
        this.classNames = new HashSet<String>(spec.classNames);
        this.disallowedClassNames = new HashSet<String>(spec.disallowedClassNames);
        this.disallowedPackagePrefixes = new TrieSet(spec.disallowedPackagePrefixes);
    }

    @Override
    public void visit(ClassLoaderVisitor visitor) {
        visitor.visitSpec(new Spec(this.classNames, this.packageNames, this.packagePrefixes, this.resourcePrefixes, this.resourceNames, this.disallowedClassNames, this.disallowedPackagePrefixes));
        visitor.visitParent(this.getParent());
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return EXT_CLASS_LOADER.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (!this.classAllowed(name)) {
                throw new ClassNotFoundException(name + " not found.");
            }
            Class<?> cl = super.loadClass(name, false);
            if (resolve) {
                this.resolveClass(cl);
            }
            return cl;
        }
    }

    @Override
    protected Package getPackage(String name) {
        Package p = super.getPackage(name);
        if (p == null || !this.allowed(p)) {
            return null;
        }
        return p;
    }

    @Override
    protected Package[] getPackages() {
        ArrayList<Package> packages = new ArrayList<Package>();
        for (Package p : super.getPackages()) {
            if (!this.allowed(p)) continue;
            packages.add(p);
        }
        return packages.toArray(new Package[0]);
    }

    @Override
    public URL getResource(String name) {
        if (this.allowed(name)) {
            return super.getResource(name);
        }
        return EXT_CLASS_LOADER.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.allowed(name)) {
            return super.getResources(name);
        }
        return EXT_CLASS_LOADER.getResources(name);
    }

    public String toString() {
        return FilteringClassLoader.class.getSimpleName() + "(" + this.getParent() + ")";
    }

    private boolean allowed(String resourceName) {
        return this.resourceNames.contains(resourceName) || this.resourcePrefixes.find(resourceName);
    }

    private boolean allowed(Package pkg) {
        String packageName = pkg.getName();
        if (this.disallowedPackagePrefixes.find(packageName)) {
            return false;
        }
        return SYSTEM_PACKAGES.contains(packageName) || this.packageNames.contains(packageName) || this.packagePrefixes.find(packageName);
    }

    private boolean classAllowed(String className) {
        if (this.disallowedClassNames.contains(className) || this.disallowedPackagePrefixes.find(className)) {
            return false;
        }
        return this.classNames.contains(className) || this.packagePrefixes.find(className) || this.packagePrefixes.contains("DEFAULT.") && this.isInDefaultPackage(className);
    }

    private boolean isInDefaultPackage(String className) {
        return !className.contains(".");
    }

    static {
        SYSTEM_PACKAGES = new HashSet<String>();
        EXT_CLASS_LOADER = ClassLoaderUtils.getPlatformClassLoader();
        for (Package p : new RetrieveSystemPackagesClassLoader(EXT_CLASS_LOADER).getPackages()) {
            SYSTEM_PACKAGES.add(p.getName());
        }
        try {
            ClassLoader.registerAsParallelCapable();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private static class TrieSet
    implements Iterable<String> {
        private final Trie trie;
        private final Set<String> set;

        public TrieSet(Collection<String> words) {
            this.trie = Trie.from(words);
            this.set = new HashSet<String>(words);
        }

        public boolean find(CharSequence seq) {
            return this.trie.find(seq);
        }

        public boolean contains(String seq) {
            return this.set.contains(seq);
        }

        @Override
        @Nonnull
        public Iterator<String> iterator() {
            return this.set.iterator();
        }
    }

    public static class Spec
    extends ClassLoaderSpec {
        final Set<String> packageNames = new HashSet<String>();
        final Set<String> packagePrefixes = new HashSet<String>();
        final Set<String> resourcePrefixes = new HashSet<String>();
        final Set<String> resourceNames = new HashSet<String>();
        final Set<String> classNames = new HashSet<String>();
        final Set<String> disallowedClassNames = new HashSet<String>();
        final Set<String> disallowedPackagePrefixes = new HashSet<String>();

        public Spec() {
        }

        public Spec(Spec spec) {
            this(spec.classNames, spec.packageNames, spec.packagePrefixes, spec.resourcePrefixes, spec.resourceNames, spec.disallowedClassNames, spec.disallowedPackagePrefixes);
        }

        public Spec(Iterable<String> classNames, Iterable<String> packageNames, Iterable<String> packagePrefixes, Iterable<String> resourcePrefixes, Iterable<String> resourceNames, Iterable<String> disallowedClassNames, Iterable<String> disallowedPackagePrefixes) {
            Spec.addAll(this.classNames, classNames);
            Spec.addAll(this.packageNames, packageNames);
            Spec.addAll(this.packagePrefixes, packagePrefixes);
            Spec.addAll(this.resourcePrefixes, resourcePrefixes);
            Spec.addAll(this.resourceNames, resourceNames);
            Spec.addAll(this.disallowedClassNames, disallowedClassNames);
            Spec.addAll(this.disallowedPackagePrefixes, disallowedPackagePrefixes);
        }

        private static void addAll(Collection<String> collection, Iterable<String> elements) {
            for (String element : elements) {
                collection.add(element);
            }
        }

        public void allowPackage(String packageName) {
            this.packageNames.add(packageName);
            this.packagePrefixes.add(packageName + ".");
            this.resourcePrefixes.add(packageName.replace('.', '/') + '/');
        }

        public void allowClass(Class<?> clazz) {
            this.classNames.add(clazz.getName());
        }

        public void disallowClass(String className) {
            this.disallowedClassNames.add(className);
        }

        public void disallowPackage(String packagePrefix) {
            this.disallowedPackagePrefixes.add(packagePrefix + ".");
        }

        public void allowResources(String resourcePrefix) {
            this.resourcePrefixes.add(resourcePrefix + "/");
        }

        public void allowResource(String resourceName) {
            this.resourceNames.add(resourceName);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Spec other = (Spec)obj;
            return other.packageNames.equals(this.packageNames) && other.packagePrefixes.equals(this.packagePrefixes) && other.resourceNames.equals(this.resourceNames) && other.resourcePrefixes.equals(this.resourcePrefixes) && other.classNames.equals(this.classNames) && other.disallowedClassNames.equals(this.disallowedClassNames) && other.disallowedPackagePrefixes.equals(this.disallowedPackagePrefixes);
        }

        public int hashCode() {
            return this.packageNames.hashCode() ^ this.packagePrefixes.hashCode() ^ this.resourceNames.hashCode() ^ this.resourcePrefixes.hashCode() ^ this.classNames.hashCode() ^ this.disallowedClassNames.hashCode() ^ this.disallowedPackagePrefixes.hashCode();
        }

        Set<String> getPackageNames() {
            return this.packageNames;
        }

        Set<String> getPackagePrefixes() {
            return this.packagePrefixes;
        }

        Set<String> getResourcePrefixes() {
            return this.resourcePrefixes;
        }

        Set<String> getResourceNames() {
            return this.resourceNames;
        }

        Set<String> getClassNames() {
            return this.classNames;
        }

        Set<String> getDisallowedClassNames() {
            return this.disallowedClassNames;
        }

        Set<String> getDisallowedPackagePrefixes() {
            return this.disallowedPackagePrefixes;
        }
    }

    private static class RetrieveSystemPackagesClassLoader
    extends ClassLoader {
        RetrieveSystemPackagesClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        protected Package[] getPackages() {
            return super.getPackages();
        }
    }
}

