/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;
import org.jetbrains.jps.model.java.compiler.JpsValidationConfiguration;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.java.impl.compiler.JpsCompilerExcludesImpl;
import org.jetbrains.jps.model.java.impl.compiler.JpsValidationConfigurationImpl;
import org.jetbrains.jps.model.java.impl.compiler.ProcessorConfigProfileImpl;
import org.jetbrains.jps.model.java.impl.compiler.ResourcePatterns;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsJavaCompilerConfigurationImpl
extends JpsCompositeElementBase<JpsJavaCompilerConfigurationImpl>
implements JpsJavaCompilerConfiguration {
    public static final JpsElementChildRole<JpsJavaCompilerConfiguration> ROLE = JpsElementChildRoleBase.create("compiler configuration");
    private boolean myAddNotNullAssertions = true;
    private List<String> myNotNullAnnotations = Collections.singletonList(NotNull.class.getName());
    private boolean myClearOutputDirectoryOnRebuild = true;
    private final JpsCompilerExcludes myCompilerExcludes = new JpsCompilerExcludesImpl();
    private final JpsCompilerExcludes myValidationExcludes = new JpsCompilerExcludesImpl();
    private final List<String> myResourcePatterns = new ArrayList<String>();
    private final List<ProcessorConfigProfile> myAnnotationProcessingProfiles = new ArrayList<ProcessorConfigProfile>();
    private final ProcessorConfigProfileImpl myDefaultAnnotationProcessingProfile = new ProcessorConfigProfileImpl("Default");
    private boolean myUseReleaseOption = true;
    private String myProjectByteCodeTargetLevel;
    private final Map<String, String> myModulesByteCodeTargetLevels = new HashMap<String, String>();
    private final Map<String, JpsJavaCompilerOptions> myCompilerOptions = new HashMap<String, JpsJavaCompilerOptions>();
    private String myJavaCompilerId = "Javac";
    private Map<JpsModule, ProcessorConfigProfile> myAnnotationProcessingProfileMap;
    private ResourcePatterns myCompiledPatterns;
    private JpsValidationConfiguration myValidationConfiguration = new JpsValidationConfigurationImpl(false, Collections.emptySet());

    public JpsJavaCompilerConfigurationImpl() {
    }

    private JpsJavaCompilerConfigurationImpl(JpsJavaCompilerConfigurationImpl original) {
        super(original);
    }

    @Override
    @NotNull
    public JpsJavaCompilerConfigurationImpl createCopy() {
        JpsJavaCompilerConfigurationImpl jpsJavaCompilerConfigurationImpl = new JpsJavaCompilerConfigurationImpl(this);
        if (jpsJavaCompilerConfigurationImpl == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(0);
        }
        return jpsJavaCompilerConfigurationImpl;
    }

    @Override
    public boolean isAddNotNullAssertions() {
        return this.myAddNotNullAssertions;
    }

    @Override
    public List<String> getNotNullAnnotations() {
        return this.myNotNullAnnotations;
    }

    @Override
    public boolean isClearOutputDirectoryOnRebuild() {
        return this.myClearOutputDirectoryOnRebuild;
    }

    @Override
    public void setAddNotNullAssertions(boolean addNotNullAssertions) {
        this.myAddNotNullAssertions = addNotNullAssertions;
    }

    @Override
    public void setNotNullAnnotations(List<String> notNullAnnotations) {
        this.myNotNullAnnotations = Collections.unmodifiableList(notNullAnnotations);
    }

    @Override
    public void setClearOutputDirectoryOnRebuild(boolean clearOutputDirectoryOnRebuild) {
        this.myClearOutputDirectoryOnRebuild = clearOutputDirectoryOnRebuild;
    }

    @Override
    @NotNull
    public JpsCompilerExcludes getCompilerExcludes() {
        JpsCompilerExcludes jpsCompilerExcludes = this.myCompilerExcludes;
        if (jpsCompilerExcludes == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(1);
        }
        return jpsCompilerExcludes;
    }

    @Override
    @NotNull
    public JpsCompilerExcludes getValidationExcludes() {
        JpsCompilerExcludes jpsCompilerExcludes = this.myValidationExcludes;
        if (jpsCompilerExcludes == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(2);
        }
        return jpsCompilerExcludes;
    }

    @Override
    @NotNull
    public JpsValidationConfiguration getValidationConfiguration() {
        JpsValidationConfiguration jpsValidationConfiguration = this.myValidationConfiguration;
        if (jpsValidationConfiguration == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(3);
        }
        return jpsValidationConfiguration;
    }

    @Override
    public void setValidationConfiguration(boolean validateOnBuild, @NotNull Set<String> disabledValidators) {
        if (disabledValidators == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(4);
        }
        this.myValidationConfiguration = new JpsValidationConfigurationImpl(validateOnBuild, disabledValidators);
    }

    @Override
    @NotNull
    public ProcessorConfigProfile getDefaultAnnotationProcessingProfile() {
        ProcessorConfigProfileImpl processorConfigProfileImpl = this.myDefaultAnnotationProcessingProfile;
        if (processorConfigProfileImpl == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(5);
        }
        return processorConfigProfileImpl;
    }

    @Override
    @NotNull
    public Collection<ProcessorConfigProfile> getAnnotationProcessingProfiles() {
        List<ProcessorConfigProfile> list2 = this.myAnnotationProcessingProfiles;
        if (list2 == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    public void addResourcePattern(String pattern) {
        this.myResourcePatterns.add(pattern);
    }

    @Override
    public List<String> getResourcePatterns() {
        return this.myResourcePatterns;
    }

    @Override
    public boolean isResourceFile(@NotNull File file2, @NotNull File srcRoot) {
        ResourcePatterns patterns2;
        if (file2 == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(7);
        }
        if (srcRoot == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(8);
        }
        if ((patterns2 = this.myCompiledPatterns) == null) {
            this.myCompiledPatterns = patterns2 = new ResourcePatterns(this);
        }
        return patterns2.isResourceFile(file2, srcRoot);
    }

    @Override
    @Nullable
    public String getByteCodeTargetLevel(String moduleName) {
        String level = this.myModulesByteCodeTargetLevels.get(moduleName);
        if (level != null) {
            return level.isEmpty() ? null : level;
        }
        return this.myProjectByteCodeTargetLevel;
    }

    @Override
    public void setModuleByteCodeTargetLevel(String moduleName, String level) {
        this.myModulesByteCodeTargetLevels.put(moduleName, level);
    }

    @Override
    @NotNull
    public String getJavaCompilerId() {
        String string = this.myJavaCompilerId;
        if (string == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public void setJavaCompilerId(@NotNull String compiler) {
        if (compiler == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(10);
        }
        this.myJavaCompilerId = compiler;
    }

    @Override
    @NotNull
    public JpsJavaCompilerOptions getCompilerOptions(@NotNull String compilerId) {
        JpsJavaCompilerOptions options;
        if (compilerId == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(11);
        }
        if ((options = this.myCompilerOptions.get(compilerId)) == null) {
            options = new JpsJavaCompilerOptions();
            this.myCompilerOptions.put(compilerId, options);
        }
        JpsJavaCompilerOptions jpsJavaCompilerOptions = options;
        if (jpsJavaCompilerOptions == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(12);
        }
        return jpsJavaCompilerOptions;
    }

    @Override
    public void setCompilerOptions(@NotNull String compilerId, @NotNull JpsJavaCompilerOptions options) {
        if (compilerId == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(13);
        }
        if (options == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(14);
        }
        this.myCompilerOptions.put(compilerId, options);
    }

    @Override
    @NotNull
    public JpsJavaCompilerOptions getCurrentCompilerOptions() {
        JpsJavaCompilerOptions jpsJavaCompilerOptions = this.getCompilerOptions(this.getJavaCompilerId());
        if (jpsJavaCompilerOptions == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(15);
        }
        return jpsJavaCompilerOptions;
    }

    @Override
    public void setProjectByteCodeTargetLevel(String level) {
        this.myProjectByteCodeTargetLevel = level;
    }

    @Override
    public boolean useReleaseOption() {
        return this.myUseReleaseOption;
    }

    @Override
    public void setUseReleaseOption(boolean useReleaseOption) {
        this.myUseReleaseOption = useReleaseOption;
    }

    @Override
    public ProcessorConfigProfile addAnnotationProcessingProfile() {
        ProcessorConfigProfileImpl profile = new ProcessorConfigProfileImpl("");
        this.myAnnotationProcessingProfiles.add(profile);
        return profile;
    }

    @Override
    @NotNull
    public ProcessorConfigProfile getAnnotationProcessingProfile(JpsModule module2) {
        ProcessorConfigProfile profile;
        Map<JpsModule, ProcessorConfigProfile> map2 = this.myAnnotationProcessingProfileMap;
        if (map2 == null) {
            map2 = new HashMap<JpsModule, ProcessorConfigProfile>();
            HashMap<String, JpsModule> namesMap = new HashMap<String, JpsModule>();
            for (JpsModule m : module2.getProject().getModules()) {
                namesMap.put(m.getName(), m);
            }
            if (!namesMap.isEmpty()) {
                for (ProcessorConfigProfile profile2 : this.getAnnotationProcessingProfiles()) {
                    for (String name2 : profile2.getModuleNames()) {
                        JpsModule mod = (JpsModule)namesMap.get(name2);
                        if (mod == null) continue;
                        map2.put(mod, profile2);
                    }
                }
            }
            this.myAnnotationProcessingProfileMap = map2;
        }
        ProcessorConfigProfile processorConfigProfile = (profile = map2.get(module2)) != null ? profile : this.getDefaultAnnotationProcessingProfile();
        if (processorConfigProfile == null) {
            JpsJavaCompilerConfigurationImpl.$$$reportNull$$$0(16);
        }
        return processorConfigProfile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/java/impl/compiler/JpsJavaCompilerConfigurationImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledValidators";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcRoot";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerId";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerExcludes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidationExcludes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidationConfiguration";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/java/impl/compiler/JpsJavaCompilerConfigurationImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultAnnotationProcessingProfile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationProcessingProfiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaCompilerId";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerOptions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCompilerOptions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationProcessingProfile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setValidationConfiguration";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isResourceFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setJavaCompilerId";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerOptions";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setCompilerOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

