/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import proguard.AssumeNoSideEffectsChecker;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;
import proguard.KeepClassMemberChecker;
import proguard.classfile.util.WarningPrinter;

public class ConfigurationChecker {
    private final Configuration configuration;

    public ConfigurationChecker(Configuration configuration) {
        this.configuration = configuration;
    }

    public void check() throws IOException {
        ClassPath programJars = this.configuration.programJars;
        ClassPath libraryJars = this.configuration.libraryJars;
        if (programJars == null) {
            throw new IOException("The input is empty. You have to specify one or more '-injars' options.");
        }
        ClassPathEntry firstEntry = programJars.get(0);
        if (firstEntry.isOutput()) {
            throw new IOException("The output jar [" + firstEntry.getName() + "] must be specified after an input jar, or it will be empty.");
        }
        for (int index = 0; index < programJars.size() - 1; ++index) {
            ClassPathEntry entry = programJars.get(index);
            if (!entry.isOutput() || entry.isFiltered() || !programJars.get(index + 1).isOutput()) continue;
            throw new IOException("The output jar [" + entry.getName() + "] must have a filter, or all subsequent output jars will be empty.");
        }
        this.checkConflicts(programJars, programJars);
        this.checkConflicts(programJars, libraryJars);
        this.checkConflicts(libraryJars, libraryJars);
        if (this.configuration.note == null || !this.configuration.note.isEmpty()) {
            int assumeNoSideEffectsNoteCount;
            String os;
            if (this.configuration.obfuscate && this.configuration.useMixedCaseClassNames && this.configuration.classObfuscationDictionary == null && ((os = System.getProperty("os.name").toLowerCase()).startsWith("windows") || os.startsWith("mac os"))) {
                for (int index = 0; index < programJars.size(); ++index) {
                    ClassPathEntry entry = programJars.get(index);
                    if (!entry.isOutput() || entry.isApk() || entry.isJar() || entry.isAar() || entry.isWar() || entry.isEar() || entry.isJmod() || entry.isZip()) continue;
                    System.out.println("Note: you're writing the processed class files to a directory [" + entry.getName() + "].");
                    System.out.println("      This will likely cause problems with obfuscated mixed-case class names.");
                    System.out.println("      You should consider writing the output to a jar file, or otherwise");
                    System.out.println("      specify '-dontusemixedcaseclassnames'.");
                    break;
                }
            }
            if (this.configuration.adaptResourceFileContents != null && (this.configuration.adaptResourceFileContents.isEmpty() || this.configuration.adaptResourceFileContents.get(0).equals("**"))) {
                System.out.println("Note: you're specifying '-adaptresourcefilecontents' for all resource files.");
                System.out.println("      This will most likely cause problems with binary files.");
            }
            WarningPrinter keepClassMemberNotePrinter = new WarningPrinter(System.out, this.configuration.note);
            new KeepClassMemberChecker(keepClassMemberNotePrinter).checkClassSpecifications(this.configuration.keep);
            WarningPrinter assumeNoSideEffectsNotePrinter = new WarningPrinter(System.out, this.configuration.note);
            new AssumeNoSideEffectsChecker(assumeNoSideEffectsNotePrinter).checkClassSpecifications(this.configuration.assumeNoSideEffects);
            int keepClassMemberNoteCount = keepClassMemberNotePrinter.getWarningCount();
            if (keepClassMemberNoteCount > 0) {
                System.out.println("Note: there were " + keepClassMemberNoteCount + " '-keepclassmembers' options that didn't specify class");
                System.out.println("      members. You should specify at least some class members or consider");
                System.out.println("      if you just need '-keep'.");
                System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#classmembers)");
            }
            if ((assumeNoSideEffectsNoteCount = assumeNoSideEffectsNotePrinter.getWarningCount()) > 0) {
                System.out.println("Note: there were " + assumeNoSideEffectsNoteCount + " '-assumenosideeffects' options that try to match all");
                System.out.println("      methods with wildcards. This will likely cause problems with methods like");
                System.out.println("      'wait()' and 'notify()'. You should specify the methods more precisely.");
                System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#nosideeffects)");
            }
        }
    }

    private void checkConflicts(ClassPath classPath1, ClassPath classPath2) throws IOException {
        if (classPath1 == null || classPath2 == null) {
            return;
        }
        for (int index1 = 0; index1 < classPath1.size(); ++index1) {
            ClassPathEntry entry1 = classPath1.get(index1);
            for (int index2 = 0; index2 < classPath2.size(); ++index2) {
                ClassPathEntry entry2;
                if (classPath1 == classPath2 && index1 == index2 || !(entry2 = classPath2.get(index2)).getName().equals(entry1.getName())) continue;
                if (entry1.isOutput()) {
                    if (entry2.isOutput()) {
                        throw new IOException("The same output jar [" + entry1.getName() + "] is specified twice.");
                    }
                    throw new IOException("Input jars and output jars must be different [" + entry1.getName() + "].");
                }
                if (entry2.isOutput()) {
                    throw new IOException("Input jars and output jars must be different [" + entry1.getName() + "].");
                }
                if (entry1.isFiltered() && entry2.isFiltered()) continue;
                throw new IOException("The same input jar [" + entry1.getName() + "] is specified twice.");
            }
        }
    }
}

