/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.ide.dependencies.MavenCoordinatesUtils;
import com.android.build.gradle.internal.ide.level2.GraphItemImpl;
import com.android.build.gradle.internal.ide.level2.JavaLibraryImpl;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GraphItem;
import com.android.builder.model.level2.Library;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;

public class ConfigurationDependencyGraphs
implements DependencyGraphs {
    private final Configuration configuration;
    private List<GraphItem> graphItems;
    private List<Library> libraries;

    public ConfigurationDependencyGraphs(Configuration configuration) {
        this.configuration = configuration;
    }

    public List<Library> getLibraries() {
        this.init();
        return this.libraries;
    }

    public List<GraphItem> getCompileDependencies() {
        this.init();
        return this.graphItems;
    }

    public List<GraphItem> getPackageDependencies() {
        this.init();
        return this.graphItems;
    }

    public List<String> getProvidedLibraries() {
        return Collections.emptyList();
    }

    public List<String> getSkippedLibraries() {
        return Collections.emptyList();
    }

    private void init() {
        if (this.graphItems != null) {
            return;
        }
        Set files2 = this.configuration.getFiles();
        if (files2.isEmpty()) {
            this.graphItems = Collections.emptyList();
            this.libraries = Collections.emptyList();
            return;
        }
        this.graphItems = Lists.newArrayListWithCapacity((int)files2.size());
        this.libraries = Lists.newArrayListWithCapacity((int)files2.size());
        for (File file : files2) {
            JavaLibraryImpl javaLib = new JavaLibraryImpl(MavenCoordinatesUtils.getMavenCoordForLocalFile(file).toString().intern(), file);
            this.libraries.add(javaLib);
            this.graphItems.add(new GraphItemImpl(javaLib.getArtifactAddress(), (List<GraphItem>)ImmutableList.of()));
        }
    }
}

