/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.analytics.Anonymizer;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.lint.LintBatchAnalytics$WhenMappings;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.Warning;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LintIssueId;
import com.google.wireless.android.sdk.stats.LintPerformance;
import com.google.wireless.android.sdk.stats.LintSession;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J2\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J:\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J<\u0010\u001d\u001a\u00020\u001c2\"\u0010\u001e\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\u001fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e` 2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0002J\f\u0010$\u001a\u00020%*\u00020#H\u0002\u00a8\u0006&"}, d2={"Lcom/android/tools/lint/LintBatchAnalytics;", "", "()V", "computeAnalysisType", "Lcom/google/wireless/android/sdk/stats/LintSession$AnalysisType;", "flags", "Lcom/android/tools/lint/LintCliFlags;", "computeApplicationId", "", "projects", "", "Lcom/android/tools/lint/detector/api/Project;", "computeIssueData", "", "Lcom/google/wireless/android/sdk/stats/LintIssueId$Builder;", "warnings", "", "Lcom/android/tools/lint/Warning;", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "computePerformance", "Lcom/google/wireless/android/sdk/stats/LintPerformance;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "computeProjectId", "projectPath", "Ljava/io/File;", "logSession", "", "recordSeverityOverride", "map", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "id", "lintSeverity", "Lcom/android/tools/lint/detector/api/Severity;", "toAnalyticsSeverity", "Lcom/google/wireless/android/sdk/stats/LintIssueId$LintSeverity;", "lint"})
public final class LintBatchAnalytics {
    public final void logSession(@NotNull IssueRegistry registry, @NotNull LintCliFlags flags, @NotNull LintDriver driver, @NotNull Collection<? extends Project> projects, @NotNull List<? extends Warning> warnings) {
        AndroidStudioEvent.Builder event;
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        Intrinsics.checkParameterIsNotNull((Object)flags, (String)"flags");
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Intrinsics.checkParameterIsNotNull(projects, (String)"projects");
        Intrinsics.checkParameterIsNotNull(warnings, (String)"warnings");
        boolean bl = !projects.isEmpty();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        LintSession.Builder builder = LintSession.newBuilder();
        bl3 = false;
        boolean bl5 = false;
        LintSession.Builder $this$apply = builder;
        boolean bl6 = false;
        $this$apply.setAnalysisType(this.computeAnalysisType(flags));
        $this$apply.setProjectId(this.computeProjectId(projects));
        $this$apply.setLintPerformance(this.computePerformance(driver));
        $this$apply.setBaselineEnabled(driver.getBaseline() != null);
        $this$apply.setIncludingGeneratedSources(driver.getCheckGeneratedSources());
        $this$apply.setIncludingTestSources(driver.getCheckTestSources());
        $this$apply.setIncludingDependencies(driver.getCheckDependencies());
        $this$apply.setAbortOnError(flags.isSetExitCode());
        $this$apply.setIgnoreWarnings(flags.isIgnoreWarnings());
        $this$apply.setWarningsAsErrors(flags.isWarningsAsErrors());
        for (LintIssueId.Builder issueBuilder : this.computeIssueData(warnings, flags, registry).values()) {
            $this$apply.addIssueIds(issueBuilder);
        }
        LintSession session = builder.build();
        AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder();
        bl5 = false;
        boolean bl7 = false;
        AndroidStudioEvent.Builder $this$apply2 = builder2;
        boolean bl8 = false;
        $this$apply2.setKind(AndroidStudioEvent.EventKind.LINT_SESSION);
        $this$apply2.setLintSession(session);
        $this$apply2.setJavaProcessStats(CommonMetricsData.getJavaProcessStats());
        $this$apply2.setJvmDetails(CommonMetricsData.getJvmDetails());
        String string = this.computeApplicationId(projects);
        if (string != null) {
            String string2 = string;
            boolean bl9 = false;
            boolean bl10 = false;
            String it = string2;
            boolean bl11 = false;
            $this$apply2.setRawProjectId(it);
        }
        AndroidStudioEvent.Builder builder3 = event = builder2;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder3, (String)"event");
        UsageTracker.log((AndroidStudioEvent.Builder)builder3);
    }

    private final String computeApplicationId(Collection<? extends Project> projects) {
        for (Project project : projects) {
            if (!project.isAndroidProject() || project.isLibrary()) continue;
            String string = project.getApplicationId();
            if (string == null) {
                continue;
            }
            return string;
        }
        for (Project project : projects) {
            if (!project.isAndroidProject()) continue;
            String string = project.getApplicationId();
            if (string == null) {
                continue;
            }
            return string;
        }
        return null;
    }

    private final LintSession.AnalysisType computeAnalysisType(LintCliFlags flags) {
        return flags.isFatalOnly() ? LintSession.AnalysisType.VITAL : LintSession.AnalysisType.BUILD;
    }

    private final String computeProjectId(Collection<? extends Project> projects) {
        Project project = (Project)CollectionsKt.firstOrNull((Iterable)projects);
        return this.computeProjectId(project != null ? project.getDir() : null);
    }

    private final String computeProjectId(File projectPath) {
        String string;
        if (projectPath == null) {
            return null;
        }
        try {
            string = Anonymizer.anonymizeUtf8((ILogger)((ILogger)new NullLogger()), (String)projectPath.getAbsolutePath());
        }
        catch (IOException e) {
            string = "*ANONYMIZATION_ERROR*";
        }
        return string;
    }

    private final LintPerformance computePerformance(LintDriver driver) {
        LintPerformance.Builder builder = LintPerformance.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        LintPerformance.Builder $this$apply = builder;
        boolean bl3 = false;
        $this$apply.setAnalysisTimeMs(System.currentTimeMillis() - driver.getAnalysisStartTime());
        $this$apply.setFileCount((long)driver.getFileCount());
        $this$apply.setModuleCount((long)driver.getModuleCount());
        $this$apply.setJavaSourceCount((long)driver.getJavaFileCount());
        $this$apply.setKotlinSourceCount((long)driver.getKotlinFileCount());
        $this$apply.setResourceFileCount((long)driver.getResourceFileCount());
        $this$apply.setTestSourceCount((long)driver.getTestSourceCount());
        $this$apply.setInitializeTimeMs(driver.getInitializeTimeMs());
        $this$apply.setRegisterCustomDetectorsTimeMs(driver.getRegisterCustomDetectorsTimeMs());
        $this$apply.setComputeDetectorsTimeMs(driver.getComputeDetectorsTimeMs());
        $this$apply.setCheckProjectTimeMs(driver.getCheckProjectTimeMs());
        $this$apply.setExtraPhasesTimeMs(driver.getExtraPhasesTimeMs());
        $this$apply.setReportBaselineIssuesTimeMs(driver.getReportBaselineIssuesTimeMs());
        $this$apply.setDisposeProjectsTimeMs(driver.getDisposeProjectsTimeMs());
        $this$apply.setReportGenerationTimeMs(driver.getReportGenerationTimeMs());
        LintPerformance lintPerformance = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)lintPerformance, (String)"LintPerformance.newBuild\u2026nTimeMs\n        }.build()");
        return lintPerformance;
    }

    private final void recordSeverityOverride(HashMap<String, LintIssueId.Builder> map, String id, Severity lintSeverity) {
        LintIssueId.Builder builder = map.get(id);
        if (builder != null) {
            return;
        }
        LintIssueId.Builder builder2 = LintIssueId.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        LintIssueId.Builder $this$apply = builder2;
        boolean bl3 = false;
        Map map2 = map;
        LintIssueId.Builder builder3 = $this$apply;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder3, (String)"this");
        map2.put(id, builder3);
        $this$apply.setIssueId(id);
        $this$apply.setCount(0L);
        $this$apply.setSeverity(this.toAnalyticsSeverity(lintSeverity));
    }

    private final LintIssueId.LintSeverity toAnalyticsSeverity(@NotNull Severity $this$toAnalyticsSeverity) {
        LintIssueId.LintSeverity lintSeverity;
        switch (LintBatchAnalytics$WhenMappings.$EnumSwitchMapping$0[$this$toAnalyticsSeverity.ordinal()]) {
            case 1: {
                lintSeverity = LintIssueId.LintSeverity.FATAL_SEVERITY;
                break;
            }
            case 2: {
                lintSeverity = LintIssueId.LintSeverity.ERROR_SEVERITY;
                break;
            }
            case 3: {
                lintSeverity = LintIssueId.LintSeverity.WARNING_SEVERITY;
                break;
            }
            case 4: {
                lintSeverity = LintIssueId.LintSeverity.INFORMATIONAL_SEVERITY;
                break;
            }
            case 5: {
                lintSeverity = LintIssueId.LintSeverity.IGNORE_SEVERITY;
                break;
            }
            default: {
                lintSeverity = LintIssueId.LintSeverity.UNKNOWN_SEVERITY;
            }
        }
        return lintSeverity;
    }

    private final Map<String, LintIssueId.Builder> computeIssueData(List<? extends Warning> warnings, LintCliFlags flags, IssueRegistry registry) {
        LinkedHashMap map = new LinkedHashMap(363);
        for (Warning warning : warnings) {
            LintIssueId.Builder issueBuilder;
            Issue issue = warning.issue;
            String id = issue.getId();
            LintIssueId.Builder builder = (LintIssueId.Builder)map.get(id);
            if (builder == null) {
                LintIssueId.LintSeverity lintSeverity;
                LintBatchAnalytics lintBatchAnalytics = this;
                boolean bl = false;
                boolean bl2 = false;
                LintBatchAnalytics $this$run = lintBatchAnalytics;
                boolean bl3 = false;
                LintIssueId.Builder builder2 = LintIssueId.newBuilder();
                boolean bl4 = false;
                boolean bl5 = false;
                LintIssueId.Builder $this$apply = builder2;
                boolean bl6 = false;
                Map map2 = map;
                LintIssueId.Builder builder3 = $this$apply;
                Intrinsics.checkExpressionValueIsNotNull((Object)builder3, (String)"this");
                map2.put(id, builder3);
                $this$apply.setIssueId(issue.getId());
                if (warning.severity == issue.getDefaultSeverity()) {
                    lintSeverity = LintIssueId.LintSeverity.DEFAULT_SEVERITY;
                } else {
                    Severity severity = warning.severity;
                    Intrinsics.checkExpressionValueIsNotNull((Object)severity, (String)"warning.severity");
                    lintSeverity = $this$run.toAnalyticsSeverity(severity);
                }
                $this$apply.setSeverity(lintSeverity);
                builder = builder2;
            }
            LintIssueId.Builder builder4 = issueBuilder = builder;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder4, (String)"issueBuilder");
            builder4.setCount(issueBuilder.getCount() + 1L);
        }
        Iterator<Object> iterator = flags.getSeverityOverrides().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator.next();
            boolean bl = false;
            String id = (String)entry2.getKey();
            entry2 = entry;
            bl = false;
            Severity severity = (Severity)entry2.getValue();
            HashMap hashMap = map;
            String string = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
            Severity severity2 = severity;
            Intrinsics.checkExpressionValueIsNotNull((Object)severity2, (String)"severity");
            this.recordSeverityOverride(hashMap, string, severity2);
        }
        for (String string : flags.getSuppressedIds()) {
            HashMap hashMap = map;
            String string2 = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"id");
            this.recordSeverityOverride(hashMap, string2, Severity.IGNORE);
        }
        for (String string : flags.getEnabledIds()) {
            HashMap hashMap = map;
            String string3 = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"id");
            Issue issue = registry.getIssue(string);
            if (issue == null || (issue = issue.getDefaultSeverity()) == null) {
                issue = Severity.WARNING;
            }
            this.recordSeverityOverride(hashMap, string3, (Severity)issue);
        }
        return map;
    }
}

