/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCoreApplicationEnvironment;
import com.google.common.collect.Sets;
import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.core.CoreJavaFileManager;
import com.intellij.core.JavaCoreApplicationEnvironment;
import com.intellij.core.JavaCoreProjectEnvironment;
import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiElementFinderImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCliJavaFileManagerImpl;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;

public class LintCoreProjectEnvironment
extends JavaCoreProjectEnvironment {
    private List<File> myPaths = new ArrayList<File>();

    public static LintCoreProjectEnvironment create(Disposable parentDisposable, JavaCoreApplicationEnvironment applicationEnvironment) {
        return new LintCoreProjectEnvironment(parentDisposable, (CoreApplicationEnvironment)applicationEnvironment);
    }

    protected void preregisterServices() {
        super.preregisterServices();
        KotlinCoreEnvironment.registerProjectExtensionPoints((ExtensionsArea)Extensions.getArea((AreaInstance)this.getProject()));
    }

    protected void registerJavaPsiFacade() {
        MockProject project = this.getProject();
        ExtensionsArea area = Extensions.getArea((AreaInstance)project);
        project.registerService(CoreJavaFileManager.class, (Object)((CoreJavaFileManager)ServiceManager.getService((Project)project, JavaFileManager.class)));
        area.getExtensionPoint(PsiElementFinder.EP_NAME).registerExtension((Object)new PsiElementFinderImpl((Project)project, (JavaFileManager)ServiceManager.getService((Project)project, JavaFileManager.class)));
        super.registerJavaPsiFacade();
    }

    public LintCoreProjectEnvironment(Disposable parentDisposable, CoreApplicationEnvironment applicationEnvironment) {
        super(parentDisposable, applicationEnvironment);
        MockProject project = this.getProject();
        ExtensionsArea area = Extensions.getArea((AreaInstance)project);
        LintCoreApplicationEnvironment.registerProjectExtensionPoints(area);
        LintCoreApplicationEnvironment.registerProjectServices(this);
    }

    public List<File> getPaths() {
        return this.myPaths;
    }

    public void registerPaths(List<File> classpath) {
        this.myPaths.addAll(classpath);
        int expectedSize = classpath.size();
        HashSet files = Sets.newHashSetWithExpectedSize((int)expectedSize);
        VirtualFileSystem local = StandardFileSystems.local();
        for (File path : classpath) {
            VirtualFile virtualFile;
            if (files.contains(path)) continue;
            files.add(path);
            if (!path.exists()) continue;
            if (path.isFile()) {
                VirtualFile root;
                String pathString;
                if (!path.isAbsolute()) {
                    path = path.getAbsoluteFile();
                }
                if ((pathString = path.getPath()).endsWith(".srcjar") && (root = StandardFileSystems.jar().findFileByPath(pathString + "!/")) != null) {
                    this.addSourcesToClasspath(root);
                    continue;
                }
                this.addJarToClassPath(path);
                continue;
            }
            if (!path.isDirectory() || (virtualFile = local.findFileByPath(path.getPath())) == null) continue;
            this.addSourcesToClasspath(virtualFile);
        }
    }

    protected JavaFileManager createCoreFileManager() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        return new KotlinCliJavaFileManagerImpl(psiManager);
    }
}

