/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Project;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.BaseExternalAnnotationsManager;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LintExternalAnnotationsManager
extends BaseExternalAnnotationsManager {
    public static final String SDK_ANNOTATIONS_PATH = "annotations.zip";
    private final List<VirtualFile> roots = Lists.newArrayList();

    public LintExternalAnnotationsManager(com.intellij.openapi.project.Project project, PsiManager psiManager) {
        super(psiManager);
    }

    protected boolean hasAnyAnnotationsRoots() {
        return !this.roots.isEmpty();
    }

    protected List<VirtualFile> getExternalAnnotationsRoots(VirtualFile virtualFile) {
        return this.roots;
    }

    public void updateAnnotationRoots(LintClient client) {
        String path;
        Collection projects = client.getKnownProjects();
        if (Project.isAospBuildEnvironment()) {
            for (Project project : projects) {
                if (!Project.isAospFrameworksProject((File)project.getDir())) continue;
                return;
            }
        }
        ArrayList files = client.getExternalAnnotations(projects);
        File sdkAnnotations = client.findResource(SDK_ANNOTATIONS_PATH);
        if (sdkAnnotations == null && (path = System.getenv("SDK_ANNOTATIONS")) != null && !(sdkAnnotations = new File(path)).exists()) {
            sdkAnnotations = null;
        }
        if (sdkAnnotations != null) {
            if (files.isEmpty()) {
                files = Collections.singletonList(sdkAnnotations);
            } else {
                files = Lists.newArrayList((Iterable)files);
                files.add(sdkAnnotations);
            }
        }
        ArrayList<VirtualFile> newRoots = new ArrayList<VirtualFile>(files.size());
        VirtualFileSystem local = StandardFileSystems.local();
        VirtualFileSystem jar = StandardFileSystems.jar();
        for (File file : files) {
            boolean isZip = file.getName().equals(SDK_ANNOTATIONS_PATH);
            VirtualFile virtualFile = isZip ? jar.findFileByPath(file.getPath() + "!/") : local.findFileByPath(file.getPath());
            if (virtualFile == null) {
                virtualFile = isZip ? jar.findFileByPath(file.getAbsolutePath() + "!/") : local.findFileByPath(file.getAbsolutePath());
            }
            if (virtualFile == null) continue;
            newRoots.add(virtualFile);
        }
        if (this.roots.containsAll(newRoots)) {
            return;
        }
        this.roots.addAll(newRoots);
        this.dropCache();
    }
}

