/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.HtmlReporter;
import com.android.tools.lint.detector.api.Lint;
import com.android.utils.HtmlBuilder;
import com.android.utils.SdkUtils;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LintSyntaxHighlighter {
    private static final int STYLE_PLAIN_TEXT = 1;
    private static final int STYLE_TAG = 2;
    private static final int STYLE_ATTRIBUTE = 3;
    private static final int STYLE_PREFIX = 4;
    private static final int STYLE_VALUE = 5;
    private static final int STYLE_COMMENT = 6;
    private static final int STYLE_PROLOGUE = 7;
    private static final int STYLE_CDATA = 8;
    private static final int STYLE_STRING = 9;
    private static final int STYLE_NUMBER = 10;
    private static final int STYLE_KEYWORD = 11;
    private static final int STYLE_JAVADOC_COMMENT = 12;
    private static final int STYLE_ANNOTATION = 13;
    private static final int TAB_WIDTH = 4;
    private final String source;
    private final Map<Integer, Integer> styles;
    private final HashBiMap<Integer, Integer> lineNumbers;
    private int lineCount;
    private List<Integer> sortedOffsets;
    private boolean forceSingleLineRange = true;
    private boolean padCaretLine = false;
    private boolean dedent = false;

    public LintSyntaxHighlighter(String fileName, String source) {
        this.source = source;
        int estimatedLineCount = Math.min(10, source.length() / 50);
        this.lineNumbers = HashBiMap.create((int)estimatedLineCount);
        this.styles = Maps.newHashMapWithExpectedSize((int)(5 * estimatedLineCount));
        this.initializeLineNumberMap();
        this.tokenizeFile(fileName);
    }

    private void tokenizeFile(String fileName) {
        this.styles.put(0, 1);
        this.styles.put(this.source.length(), 1);
        if (SdkUtils.endsWithIgnoreCase((String)fileName, (String)".xml")) {
            this.tokenizeXml();
        } else if (SdkUtils.endsWithIgnoreCase((String)fileName, (String)".java")) {
            this.tokenizeJavaLikeLanguage(Lint::isJavaKeyword);
        } else if (SdkUtils.endsWithIgnoreCase((String)fileName, (String)".gradle")) {
            this.tokenizeJavaLikeLanguage(LintSyntaxHighlighter::isGroovyKeyword);
        } else if (SdkUtils.endsWithIgnoreCase((String)fileName, (String)".kt")) {
            this.tokenizeJavaLikeLanguage(LintSyntaxHighlighter::isKotlinKeyword);
        } else if (SdkUtils.endsWithIgnoreCase((String)fileName, (String)".aidl")) {
            this.tokenizeJavaLikeLanguage(LintSyntaxHighlighter::isAidlKeyword);
        }
        this.updateSortedOffsets();
        this.removeRepeatedStyleSpans();
    }

    public boolean isForceSingleLineRange() {
        return this.forceSingleLineRange;
    }

    public LintSyntaxHighlighter setForceSingleLineRange(boolean forceSingleLineRange) {
        this.forceSingleLineRange = forceSingleLineRange;
        return this;
    }

    public boolean isPadCaretLine() {
        return this.padCaretLine;
    }

    public LintSyntaxHighlighter setPadCaretLine(boolean padCaretLine) {
        this.padCaretLine = padCaretLine;
        return this;
    }

    public boolean isDedent() {
        return this.dedent;
    }

    public void setDedent(boolean dedent) {
        this.dedent = dedent;
    }

    private void tokenizeJavaLikeLanguage(KeywordChecker keywordLookup) {
        int length = this.source.length();
        boolean STATE_INITIAL = true;
        int STATE_SLASH = 2;
        int STATE_LINE_COMMENT = 3;
        int STATE_BLOCK_COMMENT = 4;
        int STATE_STRING_DOUBLE_QUOTE = 5;
        int STATE_STRING_SINGLE_QUOTE = 6;
        int STATE_STRING_TRIPLE_DOUBLE_QUOTE = 7;
        int STATE_STRING_TRIPLE_SINGLE_QUOTE = 8;
        int STATE_NUMBER = 9;
        int STATE_IDENTIFIER = 10;
        int state = 1;
        int offset = 0;
        int identifierStart = -1;
        block12: while (offset < length) {
            char c = this.source.charAt(offset);
            switch (state) {
                case 1: {
                    if (c == '/') {
                        state = 2;
                        ++offset;
                        continue block12;
                    }
                    if (c == '\"') {
                        state = 5;
                        this.styles.put(offset, 9);
                        if (this.source.startsWith("\"\"\"", offset)) {
                            state = 7;
                            offset += 3;
                            continue block12;
                        }
                    } else if (c == '\'') {
                        state = 6;
                        this.styles.put(offset, 9);
                        if (this.source.startsWith("'''", offset)) {
                            state = 8;
                            offset += 3;
                            continue block12;
                        }
                    } else if (Character.isDigit(c)) {
                        state = 9;
                        this.styles.put(offset, 10);
                    } else if (Character.isJavaIdentifierStart(c)) {
                        state = 10;
                        identifierStart = offset;
                    }
                    ++offset;
                    continue block12;
                }
                case 9: {
                    if (Character.isDigit(c) || c == '.' || c == '_' || c == 'l' || c == 'L' || c == 'x' || c == 'X' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                        ++offset;
                        continue block12;
                    }
                    this.styles.put(offset, 1);
                    state = 1;
                    continue block12;
                }
                case 10: {
                    if (Character.isJavaIdentifierPart(c)) {
                        ++offset;
                        continue block12;
                    }
                    assert (identifierStart != -1) : identifierStart;
                    String identifier = this.source.substring(identifierStart, offset);
                    if (keywordLookup.isKeyword(identifier)) {
                        this.styles.put(identifierStart, 11);
                        this.styles.put(offset, 1);
                    } else if (identifierStart > 0 && this.source.charAt(identifierStart - 1) == '@') {
                        this.styles.put(identifierStart - 1, 13);
                        this.styles.put(offset, 1);
                    }
                    state = 1;
                    identifierStart = -1;
                    continue block12;
                }
                case 2: {
                    if (c == '/') {
                        state = 3;
                        this.styles.put(offset - 1, 6);
                    } else if (c == '*') {
                        state = 4;
                        if (offset < this.source.length() - 1 && this.source.charAt(offset + 1) == '*') {
                            this.styles.put(offset - 1, 12);
                            ++offset;
                        } else {
                            this.styles.put(offset - 1, 6);
                        }
                    } else {
                        state = 1;
                        continue block12;
                    }
                    ++offset;
                    continue block12;
                }
                case 3: {
                    if (c == '\n') {
                        state = 1;
                        this.styles.put(offset, 1);
                    }
                    ++offset;
                    continue block12;
                }
                case 4: {
                    if (c == '*' && offset < this.source.length() - 1 && this.source.charAt(offset + 1) == '/') {
                        state = 1;
                        this.styles.put(offset += 2, 1);
                        continue block12;
                    }
                    ++offset;
                    continue block12;
                }
                case 5: {
                    if (c == '\\') {
                        offset += 2;
                        continue block12;
                    }
                    if (c == '\"') {
                        state = 1;
                        this.styles.put(++offset, 1);
                        continue block12;
                    }
                    ++offset;
                    continue block12;
                }
                case 6: {
                    if (c == '\\') {
                        offset += 2;
                        continue block12;
                    }
                    if (c == '\'') {
                        state = 1;
                        this.styles.put(++offset, 1);
                        continue block12;
                    }
                    ++offset;
                    continue block12;
                }
                case 7: {
                    if (c == '\"' && this.source.startsWith("\"\"\"", offset)) {
                        this.styles.put(offset += 3, 1);
                        state = 1;
                        continue block12;
                    }
                    ++offset;
                    continue block12;
                }
                case 8: {
                    if (c == '\'' && this.source.startsWith("'''", offset)) {
                        this.styles.put(offset += 3, 1);
                        state = 1;
                        continue block12;
                    }
                    ++offset;
                    continue block12;
                }
            }
            assert (false) : state;
        }
    }

    private static boolean isGroovyKeyword(String keyword) {
        if (Lint.isJavaKeyword((String)keyword)) {
            return true;
        }
        switch (keyword) {
            case "as": 
            case "def": 
            case "in": 
            case "trait": {
                return true;
            }
        }
        return false;
    }

    private static boolean isAidlKeyword(String keyword) {
        if (Lint.isJavaKeyword((String)keyword)) {
            return true;
        }
        switch (keyword) {
            case "flattenable": 
            case "in": 
            case "inout": 
            case "oneway": 
            case "out": 
            case "parcelable": 
            case "rpc": {
                return true;
            }
        }
        return false;
    }

    private static boolean isKotlinKeyword(String keyword) {
        switch (keyword) {
            case "package": 
            case "as": 
            case "typealias": 
            case "class": 
            case "this": 
            case "super": 
            case "val": 
            case "var": 
            case "fun": 
            case "for": 
            case "null": 
            case "true": 
            case "false": 
            case "is": 
            case "in": 
            case "throw": 
            case "return": 
            case "break": 
            case "continue": 
            case "object": 
            case "if": 
            case "try": 
            case "else": 
            case "while": 
            case "do": 
            case "when": 
            case "interface": 
            case "typeof": {
                return true;
            }
        }
        return false;
    }

    private void tokenizeXml() {
        int length = this.source.length();
        boolean STATE_TEXT = true;
        int STATE_SLASH = 2;
        int STATE_ATTRIBUTE_NAME = 3;
        int STATE_IN_TAG = 4;
        int STATE_BEFORE_ATTRIBUTE = 5;
        int STATE_ATTRIBUTE_BEFORE_EQUALS = 6;
        int STATE_ATTRIBUTE_AFTER_EQUALS = 7;
        int STATE_ATTRIBUTE_VALUE_NONE = 8;
        int STATE_ATTRIBUTE_VALUE_SINGLE = 9;
        int STATE_ATTRIBUTE_VALUE_DOUBLE = 10;
        int STATE_CLOSE_TAG = 11;
        int STATE_ENDING_TAG = 12;
        int state = 1;
        int offset = 0;
        int attributeStart = 0;
        int prev = -1;
        block14: while (offset < length && (offset != prev || ++offset != length)) {
            prev = offset;
            char c = this.source.charAt(offset);
            switch (state) {
                case 1: {
                    if (c == '<') {
                        state = 2;
                        ++offset;
                        continue block14;
                    }
                    ++offset;
                    continue block14;
                }
                case 2: {
                    int end;
                    if (c == '!') {
                        if (this.source.startsWith("!--", offset)) {
                            this.styles.put(offset - 1, 6);
                            end = this.source.indexOf("-->", offset + 3);
                            if (end == -1) {
                                offset = length;
                                this.styles.put(offset, 1);
                                continue block14;
                            }
                            offset = end + 3;
                            this.styles.put(offset, 1);
                            state = 1;
                            continue block14;
                        }
                        if (this.source.startsWith("![CDATA[", offset)) {
                            end = this.source.indexOf("]]>", offset + 8);
                            if (end == -1) {
                                offset = length;
                                continue block14;
                            }
                            state = 1;
                            offset = end + 3;
                            continue block14;
                        }
                    } else {
                        if (c == '/') {
                            this.styles.put(offset - 1, 2);
                            state = 11;
                            ++offset;
                            continue block14;
                        }
                        if (c == '?') {
                            this.styles.put(offset - 1, 7);
                            end = this.source.indexOf(62, offset + 2);
                            if (end == -1) {
                                offset = length;
                                state = 1;
                                continue block14;
                            }
                            offset = end + 1;
                            this.styles.put(offset, 1);
                            state = 1;
                            continue block14;
                        }
                    }
                    this.styles.put(offset - 1, 2);
                    state = 4;
                    continue block14;
                }
                case 11: {
                    if (c == '>') {
                        this.styles.put(offset + 1, 1);
                        state = 1;
                    }
                    ++offset;
                    continue block14;
                }
                case 4: {
                    if (Character.isWhitespace(c)) {
                        state = 5;
                        this.styles.put(offset, 3);
                    } else if (c == '>') {
                        this.styles.put(offset + 1, 1);
                        state = 1;
                    } else if (c == '/') {
                        this.styles.put(offset + 1, 1);
                        state = 12;
                    }
                    ++offset;
                    continue block14;
                }
                case 12: {
                    if (c != '>') continue block14;
                    ++offset;
                    state = 1;
                    continue block14;
                }
                case 5: {
                    if (c == '>') {
                        this.styles.put(offset + 1, 1);
                        state = 1;
                    } else if (c != '/' && !Character.isWhitespace(c)) {
                        this.styles.put(offset, 3);
                        state = 3;
                        attributeStart = offset;
                    }
                    ++offset;
                    continue block14;
                }
                case 3: {
                    if (c == '>') {
                        this.styles.put(offset + 1, 1);
                        state = 1;
                    } else if (c == '=') {
                        this.styles.put(offset, 1);
                        state = 7;
                    } else if (Character.isWhitespace(c)) {
                        this.styles.put(offset, 1);
                        state = 6;
                    } else if (c == ':') {
                        this.styles.put(attributeStart, 4);
                        this.styles.put(offset + 1, 3);
                    }
                    ++offset;
                    continue block14;
                }
                case 6: {
                    if (c == '=') {
                        state = 7;
                    } else if (c == '>') {
                        this.styles.put(offset + 1, 1);
                        state = 1;
                    } else if (!Character.isWhitespace(c)) {
                        state = 3;
                        attributeStart = offset;
                    }
                    ++offset;
                    continue block14;
                }
                case 7: {
                    if (c == '\'') {
                        this.styles.put(offset, 5);
                        state = 9;
                    } else if (c == '\"') {
                        this.styles.put(offset, 5);
                        state = 10;
                    } else if (!Character.isWhitespace(c)) {
                        this.styles.put(offset, 5);
                        state = 8;
                    }
                    ++offset;
                    continue block14;
                }
                case 9: {
                    if (c == '\'') {
                        this.styles.put(offset + 1, 1);
                        state = 5;
                    }
                    ++offset;
                    continue block14;
                }
                case 10: {
                    if (c == '\"') {
                        this.styles.put(offset + 1, 1);
                        state = 5;
                    }
                    ++offset;
                    continue block14;
                }
                case 8: {
                    if (c == '>') {
                        this.styles.put(offset + 1, 1);
                        state = 1;
                    } else if (Character.isWhitespace(c)) {
                        this.styles.put(offset + 1, 1);
                        state = 5;
                    }
                    ++offset;
                    continue block14;
                }
            }
            assert (false) : state;
        }
    }

    private void removeRepeatedStyleSpans() {
        int length = this.source.length();
        int prevStyle = -1;
        for (Integer o : this.sortedOffsets) {
            int style = this.styles.get(o);
            if (prevStyle == style && length != o) {
                this.styles.remove(o);
                continue;
            }
            prevStyle = style;
        }
        this.updateSortedOffsets();
    }

    private void updateSortedOffsets() {
        this.sortedOffsets = Lists.newArrayList(this.styles.keySet());
        Collections.sort(this.sortedOffsets);
    }

    public void initializeLineNumberMap() {
        this.lineNumbers.put((Object)0, (Object)0);
        int lineNumber = 0;
        for (int offset = 0; offset < this.source.length(); ++offset) {
            char c = this.source.charAt(offset);
            if (c != '\n') continue;
            this.lineNumbers.put((Object)(offset + 1), (Object)(++lineNumber));
        }
        this.lineCount = lineNumber + 1;
    }

    private int getLineNumber(int offset) {
        int lineStart = this.findLineStartOffset(offset);
        Integer line = (Integer)this.lineNumbers.get((Object)lineStart);
        assert (line != null) : lineStart;
        return line;
    }

    private void insertRedundantMarker(int offset) {
        for (int o = 1; o < this.sortedOffsets.size(); ++o) {
            int begin = this.sortedOffsets.get(o - 1);
            int end = this.sortedOffsets.get(o);
            if (offset == begin || offset == end) {
                return;
            }
            if (offset >= end) continue;
            int style = this.styles.get(begin);
            this.styles.put(offset, style);
            return;
        }
    }

    private int findLineStartOffset(int offset) {
        char c;
        if (offset < 0) {
            return 0;
        }
        if (offset >= this.source.length()) {
            offset = this.source.length();
        }
        while (--offset >= 0 && (c = this.source.charAt(offset)) != '\n') {
        }
        return offset + 1;
    }

    private int findLineEndOffset(int offset) {
        char c;
        int length = this.source.length();
        while (offset < length && (c = this.source.charAt(offset)) != '\n') {
            ++offset;
        }
        return Math.min(offset, length);
    }

    public int computeDedent(int fromOffset, int toOffset) {
        toOffset = Math.min(this.source.length(), toOffset);
        fromOffset = Math.min(toOffset, fromOffset);
        boolean inWhitespace = true;
        int lineBegin = fromOffset;
        int dedent = Integer.MAX_VALUE;
        int column = 0;
        int i = fromOffset;
        while (i < toOffset) {
            char c = this.source.charAt(i);
            if (c == '\n') {
                inWhitespace = true;
                column = -1;
            } else if (c == '\t') {
                column += 3;
            } else if (!Character.isWhitespace(c) && inWhitespace) {
                dedent = Math.min(dedent, column);
                inWhitespace = false;
            }
            ++i;
            ++column;
        }
        if (dedent == Integer.MAX_VALUE || dedent == 0) {
            return 0;
        }
        return dedent - 1;
    }

    public int computeMaxLineLength(int fromOffset, int toOffset) {
        toOffset = Math.min(this.source.length(), toOffset);
        fromOffset = Math.min(toOffset, fromOffset);
        int maxLineLength = 0;
        int column = 0;
        int i = fromOffset;
        while (i < toOffset) {
            char c = this.source.charAt(i);
            if (c == '\t') {
                column += 3;
            } else if (c == '\n') {
                maxLineLength = Math.max(maxLineLength, column);
                column = -1;
            }
            ++i;
            ++column;
        }
        maxLineLength = Math.max(maxLineLength, column);
        return maxLineLength;
    }

    public void generateHtml(HtmlBuilder builder, int startHighlightOffset, int endHighlightOffset, boolean error) {
        int i;
        this.removeRepeatedStyleSpans();
        int caretLineOffset = this.findLineStartOffset(startHighlightOffset);
        int caretLineEndOffset = this.findLineEndOffset(startHighlightOffset);
        this.insertRedundantMarker(caretLineEndOffset);
        if (endHighlightOffset == -1) {
            endHighlightOffset = caretLineEndOffset;
        }
        if (this.forceSingleLineRange && caretLineEndOffset < endHighlightOffset) {
            endHighlightOffset = caretLineEndOffset;
        }
        this.insertRedundantMarker(startHighlightOffset);
        this.insertRedundantMarker(endHighlightOffset);
        int beginOffset = this.findLineStartOffset(startHighlightOffset);
        int endOffset = this.findLineEndOffset(endHighlightOffset);
        this.insertRedundantMarker(beginOffset);
        this.insertRedundantMarker(endOffset + 1);
        for (i = 0; i < HtmlReporter.CODE_WINDOW_SIZE; ++i) {
            beginOffset = this.findLineStartOffset(beginOffset - 1);
            this.insertRedundantMarker(beginOffset);
        }
        for (i = 0; i < HtmlReporter.CODE_WINDOW_SIZE; ++i) {
            endOffset = this.findLineEndOffset(endOffset + 1);
            this.insertRedundantMarker(endOffset + 1);
        }
        int currentLine = this.getLineNumber(beginOffset) + 1;
        int lineWidth = (int)Math.log10(this.lineCount) + 1;
        this.updateSortedOffsets();
        builder.beginPre("errorlines");
        int dedent = this.dedent ? this.computeDedent(beginOffset, endOffset) : 0;
        int maxWidth = this.computeMaxLineLength(beginOffset, endOffset);
        int available = 96;
        if (available - maxWidth > 0) {
            dedent = Math.max(0, dedent - (available - maxWidth));
        }
        int cropTo = 0;
        int spanBalance = 0;
        for (int o = 1; o < this.sortedOffsets.size(); ++o) {
            int from;
            String cssStyle;
            boolean isNewLine;
            int begin = this.sortedOffsets.get(o - 1);
            int end = this.sortedOffsets.get(o);
            if (end <= beginOffset || begin >= endOffset) continue;
            if (begin == caretLineOffset) {
                builder.beginClassSpan("caretline");
                ++spanBalance;
            }
            boolean bl = isNewLine = begin == 0 || this.source.charAt(begin - 1) == '\n';
            if (isNewLine) {
                builder.beginClassSpan("lineno");
                String lineString = String.format(Locale.ROOT, " %" + lineWidth + "d ", currentLine++);
                builder.addHtml(lineString);
                builder.endSpan();
                if (dedent > 0) {
                    int s;
                    cropTo = begin;
                    int column = 0;
                    int n = Math.min(s + dedent, this.source.length());
                    for (s = begin; s < n; ++s) {
                        char c = this.source.charAt(s);
                        if (c == '\t') {
                            column += 4;
                            continue;
                        }
                        if (c == '\n') {
                            cropTo = s;
                            continue;
                        }
                        if (!Character.isWhitespace(c)) break;
                        if (++column < dedent) continue;
                        cropTo = s;
                        break;
                    }
                }
            }
            int style = this.styles.get(begin);
            if (begin == startHighlightOffset) {
                builder.beginClassSpan(error ? "error" : "warning");
                ++spanBalance;
            }
            if ((cssStyle = LintSyntaxHighlighter.getStyleClass(style)) != null) {
                builder.beginClassSpan(cssStyle);
                ++spanBalance;
            }
            if ((from = Math.max(cropTo, begin)) < end) {
                this.add(builder, from, end);
            }
            if (cssStyle != null) {
                builder.endSpan();
                --spanBalance;
            }
            if (end == endHighlightOffset) {
                builder.endSpan();
                --spanBalance;
            }
            if (end != caretLineEndOffset) continue;
            if (this.padCaretLine) {
                builder.addNbsps(100 - (caretLineEndOffset - caretLineOffset));
            }
            builder.endSpan();
            --spanBalance;
        }
        if (spanBalance != 0) {
            for (int i2 = 0; i2 < spanBalance; ++i2) {
                builder.endSpan();
            }
        }
        builder.endPre();
        int lastOffset = this.sortedOffsets.get(this.sortedOffsets.size() - 1);
        this.add(builder, lastOffset, this.source.length());
    }

    void add(HtmlBuilder builder, int from, int to) {
        String substring = this.source.substring(from, to);
        if (substring.indexOf(9) != -1) {
            substring = substring.replace("\t", "    ");
        }
        builder.add(substring);
    }

    private static String getStyleClass(int style) {
        String cssStyle = "";
        switch (style) {
            case 1: {
                cssStyle = null;
                break;
            }
            case 2: {
                cssStyle = "tag";
                break;
            }
            case 4: {
                cssStyle = "prefix";
                break;
            }
            case 3: {
                cssStyle = "attribute";
                break;
            }
            case 5: {
                cssStyle = "value";
                break;
            }
            case 6: {
                cssStyle = "comment";
                break;
            }
            case 7: {
                cssStyle = "prologue";
                break;
            }
            case 8: {
                cssStyle = "cdata";
                break;
            }
            case 9: {
                cssStyle = "string";
                break;
            }
            case 10: {
                cssStyle = "number";
                break;
            }
            case 11: {
                cssStyle = "keyword";
                break;
            }
            case 12: {
                cssStyle = "javadoc";
                break;
            }
            case 13: {
                cssStyle = "annotation";
                break;
            }
            default: {
                assert (false) : style;
                break;
            }
        }
        return cssStyle;
    }

    static interface KeywordChecker {
        public boolean isKeyword(String var1);
    }
}

