/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.SdkConstants;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.tools.lint.ManualProject;
import com.android.tools.lint.ProjectInitializerKt;
import com.android.tools.lint.ProjectMetadata;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Desugaring;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.StringHelper;
import com.android.utils.XmlUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020)H\u0002J\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050\u001eH\u0002J2\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e2\u0006\u0010-\u001a\u00020\u00132\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0002J\u0012\u00100\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0012\u00101\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J \u0010\u0019\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u00132\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0005H\u0002J.\u0010\u0019\u001a\u00020\u00052\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00052\n\b\u0002\u00106\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u00107\u001a\u00020\tH\u0002J\u0018\u00108\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u00103\u001a\u000204H\u0002JN\u00109\u001a\u00020)2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0002J\\\u00109\u001a\u00020)2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0002J\u001a\u0010>\u001a\u0004\u0018\u00010\u00132\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0005H\u0002J\u001a\u0010?\u001a\u0004\u0018\u00010\u00132\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0005H\u0002J\u0010\u0010@\u001a\u00020)2\u0006\u0010A\u001a\u000204H\u0002J\u0010\u0010B\u001a\u00020'2\u0006\u0010C\u001a\u000204H\u0002J\u001c\u0010D\u001a\u00020)2\u0006\u0010E\u001a\u00020\u00132\n\b\u0002\u0010F\u001a\u0004\u0018\u00010GH\u0002J\u0016\u0010H\u001a\u00020)2\u0006\u0010I\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u0005R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u001e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00120\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020%0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/android/tools/lint/ProjectInitializer;", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "file", "Ljava/io/File;", "root", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Ljava/io/File;)V", "android", "", "baselines", "", "Lcom/android/tools/lint/detector/api/Project;", "cache", "getClient", "()Lcom/android/tools/lint/client/api/LintClient;", "dependencies", "Lcom/google/common/collect/Multimap;", "Lcom/android/tools/lint/ManualProject;", "", "desugaring", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Desugaring;", "externalAnnotations", "", "getFile", "()Ljava/io/File;", "globalClasspath", "jarAarMap", "lintChecks", "", "mergedManifests", "modules", "getRoot", "setRoot", "(Ljava/io/File;)V", "visibility", "Lcom/android/ide/common/repository/ResourceVisibilityLookup;", "computeMetadata", "Lcom/android/tools/lint/ProjectMetadata;", "computeResourceVisibility", "", "computeSourceRoots", "sources", "computeUniqueSourceRoots", "type", "typeSources", "sourceRoots", "findPackage", "findRoot", "path", "element", "Lorg/w3c/dom/Element;", "dir", "attribute", "required", "handleDesugaring", "handleSrcJars", "resources", "manifests", "classes", "list", "parseAar", "parseJar", "parseModule", "moduleElement", "parseModules", "projectElement", "reportError", "message", "node", "Lorg/w3c/dom/Node;", "unpackZipFile", "zip", "lint"})
final class ProjectInitializer {
    private final Map<String, ManualProject> modules;
    private final List<File> globalClasspath;
    private final Multimap<ManualProject, String> dependencies;
    private final Map<Project, File> mergedManifests;
    private final Map<Project, List<File>> lintChecks;
    private final List<File> externalAnnotations;
    private final Map<Project, File> baselines;
    private final Map<File, String> jarAarMap;
    private final Map<String, ResourceVisibilityLookup> visibility;
    private File cache;
    private boolean android;
    private EnumSet<Desugaring> desugaring;
    @NotNull
    private final LintClient client;
    @NotNull
    private final File file;
    @NotNull
    private File root;

    @NotNull
    public final ProjectMetadata computeMetadata() {
        boolean bl = this.file.isFile();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Document document = this.client.getXmlParser().parseXml(this.file);
        if (document == null || document.getDocumentElement() == null) {
            ProjectInitializer.reportError$default(this, "Failed to parse project descriptor " + this.file, null, 2, null);
            return new ProjectMetadata(null, null, null, null, null, null, null, null, null, null, null, false, 4095, null);
        }
        Element element = document.getDocumentElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"document.documentElement");
        return this.parseModules(element);
    }

    private final void reportError(String message, Node node) {
        Location location = node != null ? this.client.getXmlParser().getLocation(this.file, node) : Location.Companion.create(this.file);
        File file = this.file;
        LintDriver lintDriver = null;
        Project project = null;
        Project project2 = null;
        Context context = null;
        Severity severity = null;
        Configuration configuration = null;
        LintFix lintFix = null;
        TextFormat textFormat = null;
        Location location2 = location;
        LintClient.Companion.report$default((LintClient.Companion)LintClient.Companion, (LintClient)this.client, (Issue)IssueRegistry.LINT_ERROR, (String)message, (File)file, textFormat, lintFix, configuration, severity, context, project2, project, lintDriver, (Location)location2, (int)4080, null);
    }

    static /* synthetic */ void reportError$default(ProjectInitializer projectInitializer, String string, Node node, int n, Object object) {
        if ((n & 2) != 0) {
            node = null;
        }
        projectInitializer.reportError(string, node);
    }

    /*
     * Unable to fully structure code
     */
    private final ProjectMetadata parseModules(Element projectElement) {
        if (Intrinsics.areEqual((Object)projectElement.getTagName(), (Object)"project") ^ true) {
            this.reportError("Expected <project> as the root tag", projectElement);
            return new ProjectMetadata(null, null, null, null, null, null, null, null, null, null, null, false, 4095, null);
        }
        incomplete = Intrinsics.areEqual((Object)projectElement.getAttribute("incomplete"), (Object)"true");
        this.android = Intrinsics.areEqual((Object)projectElement.getAttribute("android"), (Object)"true");
        this.desugaring = this.handleDesugaring(projectElement);
        var4_3 = false;
        globalLintChecks = new ArrayList<E>();
        child = XmlUtils.getFirstSubTag((Node)projectElement);
        sdk = null;
        baseline = null;
        var8_8 = false;
        jdkBootClasspath = new ArrayList<E>();
        while (child != null) {
            tag = child.getTagName();
            if (tag == null) ** GOTO lbl-1000
            tmp = -1;
            switch (var9_13.hashCode()) {
                case 94416770: {
                    if (!var9_13.equals("cache")) break;
                    tmp = 1;
                    break;
                }
                case -8875619: {
                    if (!var9_13.equals("classpath")) break;
                    tmp = 2;
                    break;
                }
                case -1710494882: {
                    if (!var9_13.equals("jdk-boot-classpath")) break;
                    tmp = 3;
                    break;
                }
                case -1068784020: {
                    if (!var9_13.equals("module")) break;
                    tmp = 4;
                    break;
                }
                case 3506402: {
                    if (!var9_13.equals("root")) break;
                    tmp = 5;
                    break;
                }
                case -961709276: {
                    if (!var9_13.equals("annotations")) break;
                    tmp = 6;
                    break;
                }
                case 113722: {
                    if (!var9_13.equals("sdk")) break;
                    tmp = 7;
                    break;
                }
                case -1720785339: {
                    if (!var9_13.equals("baseline")) break;
                    tmp = 8;
                    break;
                }
                case -983827083: {
                    if (!var9_13.equals("lint-checks")) break;
                    tmp = 9;
                    break;
                }
            }
            switch (tmp) {
                case 4: {
                    this.parseModule(child);
                    break;
                }
                case 2: {
                    this.globalClasspath.add(ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null));
                    break;
                }
                case 9: {
                    globalLintChecks.add(ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null));
                    break;
                }
                case 6: {
                    var10_14 = this.externalAnnotations;
                    var11_15 = ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null);
                    var12_19 = false;
                    var10_14.add(var11_15);
                    break;
                }
                case 7: {
                    sdk = ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null);
                    break;
                }
                case 3: {
                    v0 = path = child.getAttribute("path");
                    Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"path");
                    var11_15 = v0;
                    var12_19 = false;
                    if (var11_15.length() > 0) {
                        for (Object s : StringsKt.split$default((CharSequence)path, (char[])new char[]{File.pathSeparatorChar}, (boolean)false, (int)0, (int)6, null)) {
                            var13_27 = jdkBootClasspath;
                            var14_34 = this.getFile((String)s, child, this.root);
                            var15_38 = false;
                            var13_27.add(var14_34);
                        }
                        break;
                    }
                    s = jdkBootClasspath;
                    var12_21 = ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null);
                    var13_28 = false;
                    s.add(var12_21);
                    break;
                }
                case 8: {
                    baseline = ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null);
                    break;
                }
                case 1: {
                    this.cache = ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null);
                    break;
                }
                case 5: {
                    dir = new File(child.getAttribute("dir"));
                    if (dir.isDirectory()) {
                        this.root = dir;
                        break;
                    }
                    this.reportError(dir + " does not exist", child);
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    this.reportError("Unexpected top level tag " + tag + " in " + this.file, child);
                }
            }
            child = XmlUtils.getNextTag((Node)child);
        }
        var9_13 = this.dependencies.entries().iterator();
        while (var9_13.hasNext()) {
            var12_22 = tag = (Map.Entry)var9_13.next();
            var13_29 = false;
            module = (ManualProject)var12_22.getKey();
            var12_22 = tag;
            var13_29 = false;
            dependencyName = (String)var12_22.getValue();
            to = this.modules.get(dependencyName);
            if (to != null) {
                module.addDirectDependency(to);
                continue;
            }
            v1 = new StringBuilder().append("No module ").append(dependencyName).append(" found (depended on by ");
            v2 = module;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"module");
            ProjectInitializer.reportError$default(this, v1.append(v2.getName()).toString(), null, 2, null);
        }
        allModules = this.modules.values();
        roots = new HashSet<ManualProject>(allModules);
        for (ManualProject project : allModules) {
            to = roots;
            v3 = project.getAllLibraries();
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"project.allLibraries");
            var13_30 = v3;
            var14_35 = false;
            TypeIntrinsics.asMutableCollection((Object)to).removeAll(var13_30);
        }
        $this$sortBy$iv = sortedModules = CollectionsKt.toMutableList((Collection)roots);
        $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            var13_31 = $this$sortBy$iv;
            var14_36 = false;
            var15_39 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    ManualProject it = (ManualProject)((Object)a);
                    boolean bl2 = false;
                    ManualProject manualProject = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)manualProject), (String)"it");
                    it = (ManualProject)((Object)b);
                    Comparable comparable = (Comparable)((Object)manualProject.getName());
                    bl2 = false;
                    ManualProject manualProject2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)manualProject2), (String)"it");
                    String string = manualProject2.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                }
            };
            CollectionsKt.sortWith((List)var13_31, (Comparator)var15_39);
        }
        if (!this.globalClasspath.isEmpty()) {
            useForAnalysis = true;
            for (ManualProject module : sortedModules) {
                if (module.getJavaLibraries(true).isEmpty()) {
                    module.setClasspath(this.globalClasspath, false);
                }
                v4 = module;
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"module");
                if (!v4.getJavaClassFolders().isEmpty()) continue;
                module.setClasspath(this.globalClasspath, useForAnalysis);
                useForAnalysis = false;
            }
        }
        this.computeResourceVisibility();
        var11_18 = this.android != false ? Platform.ANDROID_SET : Platform.JDK_SET;
        var12_26 = jdkBootClasspath;
        var13_33 = incomplete;
        var14_37 = this.mergedManifests;
        var15_40 = this.baselines;
        var16_41 = this.cache;
        var17_42 = this.externalAnnotations;
        var18_43 = this.lintChecks;
        var19_44 = globalLintChecks;
        var20_45 = baseline;
        var21_46 = sdk;
        return new ProjectMetadata(sortedModules, var20_45, var21_46, var16_41, var14_37, var15_40, var19_44, var18_43, var12_26, var11_18, var17_42, var13_33);
    }

    private final EnumSet<Desugaring> handleDesugaring(Element element) {
        String s;
        EnumSet<Enum> desugaring = null;
        if (Intrinsics.areEqual((Object)"true", (Object)element.getAttribute("android_java8_libs"))) {
            desugaring = EnumSet.of((Enum)Desugaring.JAVA_8_LIBRARY);
        }
        String string = s = element.getAttribute("desugar");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"s");
        CharSequence charSequence = string;
        boolean bl = false;
        if (!(charSequence.length() == 0)) {
            for (String option : StringsKt.split$default((CharSequence)s, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)) {
                boolean found = false;
                for (Desugaring v : Desugaring.values()) {
                    if (!StringsKt.equals((String)option, (String)v.name(), (boolean)true)) continue;
                    if (desugaring == null) {
                        desugaring = EnumSet.of((Enum)v);
                    } else {
                        desugaring.add((Enum)v);
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                try {
                    String fieldName;
                    String string2 = option;
                    boolean bl2 = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3.toUpperCase(), (String)"(this as java.lang.String).toUpperCase()");
                    Desugaring.Companion instance = Desugaring.Companion;
                    Class<Desugaring> cls = Desugaring.class;
                    Object object = cls.getField(fieldName).get(null);
                    if (!(object instanceof EnumSet)) {
                        object = null;
                    }
                    if ((EnumSet)object == null) {
                        continue;
                    }
                    if (desugaring == null) {
                        desugaring = EnumSet.noneOf(Desugaring.class);
                    }
                    EnumSet<Enum> enumSet = desugaring;
                    if (enumSet != null) {
                        EnumSet v;
                        enumSet.addAll(v);
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        return desugaring;
    }

    private final void computeResourceVisibility() {
        for (ManualProject module : this.modules.values()) {
            boolean bl = false;
            List aarDeps = new ArrayList();
            for (String dependencyName : this.dependencies.get((Object)module)) {
                ResourceVisibilityLookup visibility;
                if (this.visibility.get(dependencyName) == null) {
                    continue;
                }
                aarDeps.add(visibility);
            }
            if (aarDeps.isEmpty()) continue;
            ResourceVisibilityLookup visibilityLookup = aarDeps.size() == 1 ? (ResourceVisibilityLookup)aarDeps.get(0) : ResourceVisibilityLookup.create((List)aarDeps);
            module.setResourceVisibility(visibilityLookup);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void parseModule(Element moduleElement) {
        v0 = moduleElement.getAttribute("name");
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"moduleElement.getAttribute(ATTR_NAME)");
        name = v0;
        library = Intrinsics.areEqual((Object)moduleElement.getAttribute("library"), (Object)"true");
        android = Intrinsics.areEqual((Object)moduleElement.getAttribute("android"), (Object)"false") ^ true;
        v1 = moduleElement.getAttribute("compile-sdk-version");
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"moduleElement.getAttribu\u2026ATTR_COMPILE_SDK_VERSION)");
        buildApi = v1;
        v2 = this.handleDesugaring(moduleElement);
        if (v2 == null) {
            v2 = desugaring = this.desugaring;
        }
        if (android) {
            this.android = true;
        }
        StringsKt.indexOf$default((CharSequence)name, (char)':', (int)StringsKt.lastIndexOf$default((CharSequence)name, (char)File.separatorChar, (int)0, (boolean)false, (int)6, null), (boolean)false, (int)4, null);
        v3 = name;
        v4 = File.separator;
        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"File.separator");
        if (!StringsKt.contains$default((CharSequence)v3, (CharSequence)v4, (boolean)false, (int)2, null)) ** GOTO lbl-1000
        v5 = name;
        v6 = name;
        v7 = File.separator;
        Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"File.separator");
        if (StringsKt.indexOf$default((CharSequence)v5, (char)':', (int)StringsKt.lastIndexOf$default((CharSequence)v6, (String)v7, (int)0, (boolean)false, (int)6, null), (boolean)false, (int)4, null) != -1) {
            var8_7 = name;
            var9_8 = 0;
            v8 = name;
            v9 = name;
            v10 = File.separator;
            Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"File.separator");
            var10_10 = StringsKt.indexOf$default((CharSequence)v8, (char)':', (int)StringsKt.lastIndexOf$default((CharSequence)v9, (String)v10, (int)0, (boolean)false, (int)6, null), (boolean)false, (int)4, null);
            var11_12 = false;
            v11 = var8_7;
            if (v11 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            v12 = v11.substring(var9_8, var10_10);
            Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            var31_15 = var30_14 = v12;
            v13 = new File(var31_15);
        } else lbl-1000:
        // 2 sources

        {
            v13 = this.root;
        }
        dir = v13;
        module = new ManualProject(this.client, dir, name, library, android);
        this.modules.put(name, module);
        var10_10 = 0;
        sources = new ArrayList<E>();
        var11_12 = false;
        generatedSources = new ArrayList<E>();
        var12_17 = false;
        testSources = new ArrayList<E>();
        var13_19 = false;
        resources = new ArrayList<E>();
        var14_21 = false;
        manifests = new ArrayList<E>();
        var15_23 = false;
        classes = new ArrayList<E>();
        var16_25 = false;
        classpath = new ArrayList<E>();
        var17_27 = false;
        lintChecks = new ArrayList<E>();
        baseline = null;
        mergedManifest = null;
        child = XmlUtils.getFirstSubTag((Node)moduleElement);
        while (child != null) {
            if (child.getTagName() == null) ** GOTO lbl-1000
            tmp = -1;
            switch (var20_31.hashCode()) {
                case 114148: {
                    if (!var20_31.equals("src")) break;
                    tmp = 1;
                    break;
                }
                case -341064690: {
                    if (!var20_31.equals("resource")) break;
                    tmp = 2;
                    break;
                }
                case -8875619: {
                    if (!var20_31.equals("classpath")) break;
                    tmp = 3;
                    break;
                }
                case 130625071: {
                    if (!var20_31.equals("manifest")) break;
                    tmp = 4;
                    break;
                }
                case 853620774: {
                    if (!var20_31.equals("classes")) break;
                    tmp = 5;
                    break;
                }
                case -961709276: {
                    if (!var20_31.equals("annotations")) break;
                    tmp = 6;
                    break;
                }
                case -260399184: {
                    if (!var20_31.equals("merged-manifest")) break;
                    tmp = 7;
                    break;
                }
                case -1720785339: {
                    if (!var20_31.equals("baseline")) break;
                    tmp = 8;
                    break;
                }
                case -983827083: {
                    if (!var20_31.equals("lint-checks")) break;
                    tmp = 9;
                    break;
                }
                case 99343: {
                    if (!var20_31.equals("dep")) break;
                    tmp = 10;
                    break;
                }
                case -1000992744: {
                    if (!var20_31.equals("proguard")) break;
                    tmp = 11;
                    break;
                }
                case 96338: {
                    if (!var20_31.equals("aar")) break;
                    tmp = 12;
                    break;
                }
                case 104987: {
                    if (!var20_31.equals("jar")) break;
                    tmp = 13;
                    break;
                }
                case 2993840: {
                    if (!var20_31.equals("aidl")) break;
                    tmp = 11;
                    break;
                }
            }
            switch (tmp) {
                case 4: {
                    manifests.add(ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null));
                    break;
                }
                case 7: {
                    mergedManifest = ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null);
                    break;
                }
                case 1: {
                    file = ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null);
                    var22_33 = Intrinsics.areEqual((Object)child.getAttribute("generated"), (Object)"true");
                    if (var22_33) {
                        generatedSources.add(file);
                        break;
                    }
                    if (var22_33) break;
                    var23_39 = Intrinsics.areEqual((Object)child.getAttribute("test"), (Object)"true");
                    if (!var23_39) {
                        sources.add(file);
                        break;
                    }
                    if (!var23_39) break;
                    testSources.add(file);
                    break;
                }
                case 2: {
                    resources.add(ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null));
                    break;
                }
                case 5: {
                    classes.add(ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null));
                    break;
                }
                case 3: {
                    classpath.add(ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null));
                    break;
                }
                case 12: {
                    aar = this.parseAar(child, dir);
                    if (aar != null) {
                        var23_39 = false;
                        var24_41 = false;
                        it = var22_34;
                        $i$a$-let-ProjectInitializer$parseModule$1 = false;
                        this.dependencies.put((Object)module, (Object)aar);
                    }
                    break;
                }
                case 13: {
                    jar = this.parseJar(child, dir);
                    if (jar != null) {
                        var23_39 = false;
                        var24_41 = false;
                        it = var22_35;
                        $i$a$-let-ProjectInitializer$parseModule$2 = false;
                        this.dependencies.put((Object)module, jar);
                    }
                    break;
                }
                case 8: {
                    baseline = ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null);
                    break;
                }
                case 9: {
                    lintChecks.add(ProjectInitializer.getFile$default(this, child, dir, null, false, 12, null));
                    break;
                }
                case 6: {
                    jar = this.externalAnnotations;
                    var22_36 = ProjectInitializer.getFile$default(this, child, this.root, null, false, 12, null);
                    var23_39 = false;
                    jar.add(var22_36);
                    break;
                }
                case 10: {
                    v14 = target = child.getAttribute("module");
                    Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"target");
                    var22_37 = v14;
                    var23_39 = false;
                    if (var22_37.length() == 0) {
                        this.reportError("Invalid module dependency in " + module.getName(), child);
                    }
                    this.dependencies.put((Object)module, (Object)target);
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    this.reportError("Unexpected tag " + child.getTagName(), child);
                    return;
                }
                case 11: 
            }
            child = XmlUtils.getNextTag((Node)child);
        }
        sourceRoots = this.computeSourceRoots(sources);
        testSourceRoots = this.computeUniqueSourceRoots("test", testSources, sourceRoots);
        generatedSourceRoots = this.computeUniqueSourceRoots("generated", generatedSources, sourceRoots);
        var24_41 = false;
        resourceRoots = new ArrayList<E>();
        if (!resources.isEmpty()) {
            for (File file : resources) {
                if (file.getParentFile() == null) {
                    continue;
                }
                if (typeFolder.getParentFile() == null) {
                    continue;
                }
                if (resourceRoots.contains(res)) continue;
                resourceRoots.add(res);
            }
        }
        this.handleSrcJars(sources, resources, manifests, classes, sourceRoots);
        module.setManifests(manifests);
        module.setResources(resourceRoots, resources);
        module.setTestSources(testSourceRoots, testSources);
        module.setGeneratedSources(generatedSourceRoots, generatedSources);
        module.setSources(sourceRoots, sources);
        module.setClasspath(classes, true);
        module.setClasspath(classpath, false);
        module.setDesugaring((Set<? extends Desugaring>)desugaring);
        module.setCompileSdkVersion(buildApi);
        this.lintChecks.put(module, lintChecks);
        this.mergedManifests.put(module, mergedManifest);
        this.baselines.put(module, baseline);
        v15 = module.getDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"module.dir");
        this.client.registerProject(v15, (Project)module);
    }

    private final void handleSrcJars(List<File> sources, List<File> resources, List<File> manifests, List<File> classes, List<File> sourceRoots) {
        this.handleSrcJars(sources, sources, resources, manifests, classes, sourceRoots);
        this.handleSrcJars(resources, sources, resources, manifests, classes, sourceRoots);
        this.handleSrcJars(manifests, sources, resources, manifests, classes, sourceRoots);
        this.handleSrcJars(classes, sources, resources, manifests, classes, sourceRoots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleSrcJars(List<File> list, List<File> sources, List<File> resources, List<File> manifests, List<File> classes, List<File> sourceRoots) {
        ListIterator<File> iterator = list.listIterator();
        if (iterator.hasNext()) {
            File file = iterator.next();
            String string = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
            if (StringsKt.endsWith$default((String)string, (String)".srcjar", (boolean)false, (int)2, null)) {
                iterator.remove();
                sourceRoots.add(file);
                Closeable closeable = new ZipFile(file);
                boolean bl = false;
                Throwable throwable = null;
                try {
                    ZipFile zipFile = (ZipFile)closeable;
                    boolean bl2 = false;
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry zipEntry;
                        ZipEntry zipEntry2 = zipEntry = entries.nextElement();
                        Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry2, (String)"zipEntry");
                        if (zipEntry2.isDirectory()) continue;
                        String path = file.getPath() + "!/" + zipEntry.getName();
                        File newFile = new File(path);
                        if (StringsKt.endsWith$default((String)path, (String)"AndroidManifest.xml", (boolean)false, (int)2, null)) {
                            manifests.add(newFile);
                            continue;
                        }
                        if (StringsKt.endsWith$default((String)path, (String)".xml", (boolean)false, (int)2, null)) {
                            resources.add(newFile);
                            continue;
                        }
                        if (StringsKt.endsWith$default((String)path, (String)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".kt", (boolean)false, (int)2, null)) {
                            sources.add(newFile);
                            continue;
                        }
                        if (!StringsKt.endsWith$default((String)path, (String)".class", (boolean)false, (int)2, null)) continue;
                        classes.add(newFile);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String parseAar(Element element, File dir) {
        File classesJar;
        File resources;
        File[] fileArray;
        File aarFile = ProjectInitializer.getFile$default(this, element, dir, null, false, 12, null);
        String moduleName = this.jarAarMap.get(aarFile);
        if (moduleName != null) {
            return moduleName;
        }
        String name = aarFile.getName();
        ProjectInitializer projectInitializer = this;
        boolean bl = false;
        boolean bl2 = false;
        ProjectInitializer $this$run = projectInitializer;
        boolean bl3 = false;
        File[] expanded = $this$run.getFile(element, dir, "extracted", false);
        String string = expanded.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expanded.path");
        CharSequence charSequence = string;
        boolean bl4 = false;
        if (charSequence.length() == 0) {
            File cacheDir = $this$run.cache != null ? new File($this$run.cache, "aars") : $this$run.client.getCacheDir("aars", true);
            File target = new File(cacheDir, name);
            if (!target.isDirectory()) {
                $this$run.unpackZipFile(aarFile, target);
            }
            fileArray = target;
        } else {
            if (!expanded.isDirectory()) {
                ProjectInitializer.reportError$default($this$run, "Expanded AAR path " + expanded + " is not a directory", null, 2, null);
            }
            fileArray = expanded;
        }
        File[] expanded2 = fileArray;
        String string2 = name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
        ManualProject project = new ManualProject(this.client, (File)expanded2, string2, true, true);
        project.setReportIssues(false);
        File manifest = new File((File)expanded2, "AndroidManifest.xml");
        if (manifest.isFile()) {
            project.setManifests(CollectionsKt.listOf((Object)manifest));
        }
        if ((resources = new File((File)expanded2, "res")).isDirectory()) {
            project.setResources(CollectionsKt.listOf((Object)resources), CollectionsKt.emptyList());
        }
        bl3 = false;
        List jarList = new ArrayList();
        File jarsDir = new File((File)expanded2, "jars");
        if (jarsDir.isDirectory()) {
            File[] fileArray2 = jarsDir.listFiles();
            if (fileArray2 != null) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                expanded = fileArray2;
                boolean cacheDir = false;
                boolean target = false;
                File[] it = expanded;
                boolean bl5 = false;
                File[] fileArray3 = it;
                List list = jarList;
                boolean $i$f$filter = false;
                void var20_29 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                void var23_32 = $this$filterTo$iv$iv;
                int n = ((void)var23_32).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void file = element$iv$iv = var23_32[i];
                    boolean bl6 = false;
                    void v4 = file;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"file");
                    String string3 = v4.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"file.name");
                    if (!StringsKt.endsWith$default((String)string3, (String)".jar", (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                list.addAll(CollectionsKt.toList((Iterable)list2));
            }
        }
        if ((classesJar = new File((File)expanded2, "classes.jar")).isFile()) {
            jarList.add(classesJar);
        }
        Collection cacheDir = jarList;
        boolean target = false;
        if (!cacheDir.isEmpty()) {
            project.setClasspath(jarList, false);
        }
        this.jarAarMap.put(aarFile, name);
        this.modules.put(name, project);
        File publicResources = new File((File)expanded2, "public.txt");
        File allResources = new File((File)expanded2, "R.txt");
        ResourceVisibilityLookup resourceVisibilityLookup = ResourceVisibilityLookup.create((File)publicResources, (File)allResources, (String)name);
        Intrinsics.checkExpressionValueIsNotNull((Object)resourceVisibilityLookup, (String)"ResourceVisibilityLookup\u2026rces, allResources, name)");
        this.visibility.put(name, resourceVisibilityLookup);
        return name;
    }

    private final String parseJar(Element element, File dir) {
        String name;
        File jarFile = ProjectInitializer.getFile$default(this, element, dir, null, false, 12, null);
        String moduleName = this.jarAarMap.get(jarFile);
        if (moduleName != null) {
            return moduleName;
        }
        String string = name = jarFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        ManualProject project = new ManualProject(this.client, jarFile, string, true, false);
        project.setReportIssues(false);
        project.setClasspath(CollectionsKt.listOf((Object)jarFile), false);
        this.jarAarMap.put(jarFile, name);
        this.modules.put(name, project);
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unpackZipFile(@NotNull File zip, @NotNull File dir) throws ZipException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)zip, (String)"zip");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Closeable closeable = new ZipFile(zip);
        boolean bl = false;
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl2 = false;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry;
                ZipEntry zipEntry2 = zipEntry = entries.nextElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry2, (String)"zipEntry");
                if (zipEntry2.isDirectory()) continue;
                File targetFile = new File(dir, zipEntry.getName());
                Files.createParentDirs((File)targetFile);
                Closeable closeable2 = Files.asByteSink((File)targetFile, (FileWriteMode[])new FileWriteMode[0]).openBufferedStream();
                boolean bl3 = false;
                Throwable throwable2 = null;
                try {
                    OutputStream it = (OutputStream)closeable2;
                    boolean bl4 = false;
                    long l = ByteStreams.copy((InputStream)zipFile.getInputStream(zipEntry), (OutputStream)it);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final List<File> computeUniqueSourceRoots(String type, List<File> typeSources, List<File> sourceRoots) {
        if (typeSources.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List<File> typeSourceRoots = this.computeSourceRoots(typeSources);
        for (File root : typeSourceRoots) {
            if (!sourceRoots.contains(root)) continue;
            ProjectInitializer.reportError$default(this, StringHelper.usLocaleCapitalize((String)type) + " sources cannot be in the same " + "source root as production files; " + "source root " + root + " is also a test root", null, 2, null);
            break;
        }
        typeSourceRoots.removeAll((Collection)sourceRoots);
        return typeSourceRoots;
    }

    private final List<File> computeSourceRoots(List<? extends File> sources) {
        boolean bl = false;
        List sourceRoots = new ArrayList();
        if (!sources.isEmpty()) {
            boolean bl2 = false;
            Map dirToRootCache = new LinkedHashMap();
            for (File file : sources) {
                File file2;
                File parent;
                if (file.getParentFile() == null) {
                    continue;
                }
                File found = (File)dirToRootCache.get(parent.getPath());
                if (found != null) continue;
                File file3 = this.findRoot(file);
                if (file3 == null) {
                    file3 = file2 = file.getParentFile();
                }
                if (file3 == null) {
                    File file4 = file.getAbsoluteFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"file.absoluteFile");
                    file2 = file4.getParentFile();
                }
                if (file2 == null) {
                    continue;
                }
                File root = file2;
                String string = parent.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parent.path");
                dirToRootCache.put(string, root);
                if (sourceRoots.contains(root)) continue;
                sourceRoots.add(root);
            }
        }
        return sourceRoots;
    }

    private final File getFile(Element element, File dir, String attribute, boolean required) {
        boolean bl;
        CharSequence charSequence;
        String path = null;
        if (attribute != null) {
            String string = element.getAttribute(attribute);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.getAttribute(attribute)");
            path = string;
            charSequence = path;
            bl = false;
            if (charSequence.length() == 0 && required) {
                this.reportError("Must specify " + attribute + "= attribute", element);
            }
        } else {
            String string = element.getAttribute("file");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.getAttribute(ATTR_FILE)");
            path = string;
            charSequence = path;
            bl = false;
            if (charSequence.length() == 0) {
                String string2 = element.getAttribute("dir");
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.getAttribute(ATTR_DIR)");
                path = string2;
                charSequence = path;
                bl = false;
                if (charSequence.length() == 0) {
                    String string3 = element.getAttribute("jar");
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"element.getAttribute(ATTR_JAR)");
                    path = string3;
                }
            }
        }
        charSequence = path;
        bl = false;
        if (charSequence.length() == 0) {
            if (required) {
                ProjectInitializer.reportError$default(this, "Must specify file/dir/jar on <" + element.getTagName() + '>', null, 2, null);
            }
            return new File("");
        }
        return this.getFile(path, element, dir);
    }

    static /* synthetic */ File getFile$default(ProjectInitializer projectInitializer, Element element, File file, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return projectInitializer.getFile(element, file, string, bl);
    }

    private final File getFile(String path, Element element, File dir) {
        File source = new File(path);
        if (!source.isAbsolute()) {
            if (!source.exists()) {
                source = new File(dir, path);
                if (!source.exists()) {
                    source = new File(this.root, path);
                }
            } else {
                File file = source.getAbsoluteFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"source.absoluteFile");
                return file;
            }
        }
        if (!source.exists()) {
            String string;
            if (SdkConstants.currentPlatform() == 2) {
                String string2 = dir.getCanonicalPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dir.canonicalPath");
                String string3 = File.separator;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"File.separator");
                string = StringsKt.replace$default((String)string2, (String)string3, (String)"\\\\", (boolean)false, (int)4, null);
            } else {
                string = dir.getCanonicalPath();
            }
            String relativePath = string;
            this.reportError(path + ' ' + (!new File(path).isAbsolute() ? "(relative to " + relativePath + ") " : "") + "does not exist", element);
        }
        return source;
    }

    private final File findRoot(File file) {
        String path;
        String string = path = file.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
        if (StringsKt.endsWith$default((String)string, (String)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".kt", (boolean)false, (int)2, null)) {
            String string2;
            String string3 = this.findPackage(file);
            if (string3 == null) {
                return null;
            }
            String pkg = string3;
            File file2 = file.getParentFile();
            if (file2 == null) {
                return null;
            }
            File parent = file2;
            String string4 = path;
            int n = 0;
            int n2 = parent.getPath().length() - pkg.length();
            boolean bl = false;
            String string5 = string4.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string6 = string2 = string5;
            return new File(string6);
        }
        return null;
    }

    private final String findPackage(File file) {
        String string;
        CharSequence source = this.client.readFile(file);
        Matcher matcher = ProjectInitializerKt.access$getPACKAGE_PATTERN$p().matcher(source);
        boolean foundPackage = matcher.find();
        if (foundPackage) {
            String string2 = matcher.group(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"matcher.group(1)");
            String $this$trim$iv = string2;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final LintClient getClient() {
        return this.client;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final File getRoot() {
        return this.root;
    }

    public final void setRoot(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.root = file;
    }

    public ProjectInitializer(@NotNull LintClient client, @NotNull File file, @NotNull File root) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        this.client = client;
        this.file = file;
        this.root = root;
        ProjectInitializer projectInitializer = this;
        boolean bl = false;
        Object object = new LinkedHashMap();
        projectInitializer.modules = object;
        projectInitializer = this;
        bl = false;
        projectInitializer.globalClasspath = object = (List)new ArrayList();
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayListMultimap, (String)"ArrayListMultimap.create()");
        this.dependencies = (Multimap)arrayListMultimap;
        projectInitializer = this;
        bl = false;
        projectInitializer.mergedManifests = object = (Map)new LinkedHashMap();
        projectInitializer = this;
        bl = false;
        projectInitializer.lintChecks = object = (Map)new LinkedHashMap();
        projectInitializer = this;
        bl = false;
        projectInitializer.externalAnnotations = object = (List)new ArrayList();
        projectInitializer = this;
        bl = false;
        projectInitializer.baselines = object = (Map)new LinkedHashMap();
        projectInitializer = this;
        bl = false;
        projectInitializer.jarAarMap = object = (Map)new LinkedHashMap();
        projectInitializer = this;
        bl = false;
        projectInitializer.visibility = object = (Map)new LinkedHashMap();
    }
}

