
package com.android.tools.build.bundletool.commands;

import java.nio.file.Path;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_ValidateBundleCommand extends ValidateBundleCommand {

  private final Path bundlePath;
  private final Boolean printOutput;

  private AutoValue_ValidateBundleCommand(
      Path bundlePath,
      Boolean printOutput) {
    this.bundlePath = bundlePath;
    this.printOutput = printOutput;
  }

  @Override
  public Path getBundlePath() {
    return bundlePath;
  }

  @Override
  public Boolean getPrintOutput() {
    return printOutput;
  }

  @Override
  public String toString() {
    return "ValidateBundleCommand{"
        + "bundlePath=" + bundlePath + ", "
        + "printOutput=" + printOutput
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ValidateBundleCommand) {
      ValidateBundleCommand that = (ValidateBundleCommand) o;
      return (this.bundlePath.equals(that.getBundlePath()))
           && (this.printOutput.equals(that.getPrintOutput()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.bundlePath.hashCode();
    h *= 1000003;
    h ^= this.printOutput.hashCode();
    return h;
  }

  static final class Builder extends ValidateBundleCommand.Builder {
    private Path bundlePath;
    private Boolean printOutput;
    Builder() {
    }
    @Override
    public ValidateBundleCommand.Builder setBundlePath(Path bundlePath) {
      if (bundlePath == null) {
        throw new NullPointerException("Null bundlePath");
      }
      this.bundlePath = bundlePath;
      return this;
    }
    @Override
    public ValidateBundleCommand.Builder setPrintOutput(Boolean printOutput) {
      if (printOutput == null) {
        throw new NullPointerException("Null printOutput");
      }
      this.printOutput = printOutput;
      return this;
    }
    @Override
    public ValidateBundleCommand build() {
      String missing = "";
      if (this.bundlePath == null) {
        missing += " bundlePath";
      }
      if (this.printOutput == null) {
        missing += " printOutput";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ValidateBundleCommand(
          this.bundlePath,
          this.printOutput);
    }
  }

}
