/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.solver.widgets;

import androidx.constraintlayout.solver.widgets.ConstraintAnchor;
import androidx.constraintlayout.solver.widgets.ConstraintWidget;
import androidx.constraintlayout.solver.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.solver.widgets.ConstraintWidgetGroup;
import androidx.constraintlayout.solver.widgets.Guideline;
import androidx.constraintlayout.solver.widgets.Helper;
import androidx.constraintlayout.solver.widgets.Optimizer;
import androidx.constraintlayout.solver.widgets.ResolutionAnchor;
import androidx.constraintlayout.solver.widgets.ResolutionNode;
import java.util.ArrayList;
import java.util.List;

public class Analyzer {
    private Analyzer() {
    }

    public static void determineGroups(ConstraintWidgetContainer layoutWidget) {
        if ((layoutWidget.getOptimizationLevel() & 0x20) != 32) {
            Analyzer.singleGroup(layoutWidget);
            return;
        }
        layoutWidget.mSkipSolver = true;
        layoutWidget.mGroupsWrapOptimized = false;
        layoutWidget.mHorizontalWrapOptimized = false;
        layoutWidget.mVerticalWrapOptimized = false;
        ArrayList widgets = layoutWidget.mChildren;
        List<ConstraintWidgetGroup> widgetGroups = layoutWidget.mWidgetGroups;
        boolean horizontalWrapContent = layoutWidget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
        boolean verticalWrapContent = layoutWidget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
        boolean hasWrapContent = horizontalWrapContent || verticalWrapContent;
        widgetGroups.clear();
        for (ConstraintWidget widget : widgets) {
            widget.mBelongingGroup = null;
            widget.mGroupsToSolver = false;
            widget.resetResolutionNodes();
        }
        for (ConstraintWidget widget : widgets) {
            if (widget.mBelongingGroup != null || Analyzer.determineGroups(widget, widgetGroups, hasWrapContent)) continue;
            Analyzer.singleGroup(layoutWidget);
            layoutWidget.mSkipSolver = false;
            return;
        }
        int measuredWidth = 0;
        int measuredHeight = 0;
        for (ConstraintWidgetGroup group : widgetGroups) {
            measuredWidth = Math.max(measuredWidth, Analyzer.getMaxDimension(group, 0));
            measuredHeight = Math.max(measuredHeight, Analyzer.getMaxDimension(group, 1));
        }
        if (horizontalWrapContent) {
            layoutWidget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
            layoutWidget.setWidth(measuredWidth);
            layoutWidget.mGroupsWrapOptimized = true;
            layoutWidget.mHorizontalWrapOptimized = true;
            layoutWidget.mWrapFixedWidth = measuredWidth;
        }
        if (verticalWrapContent) {
            layoutWidget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
            layoutWidget.setHeight(measuredHeight);
            layoutWidget.mGroupsWrapOptimized = true;
            layoutWidget.mVerticalWrapOptimized = true;
            layoutWidget.mWrapFixedHeight = measuredHeight;
        }
        Analyzer.setPosition(widgetGroups, 0, layoutWidget.getWidth());
        Analyzer.setPosition(widgetGroups, 1, layoutWidget.getHeight());
    }

    private static boolean determineGroups(ConstraintWidget widget, List<ConstraintWidgetGroup> widgetGroups, boolean hasWrapContent) {
        ConstraintWidgetGroup traverseList = new ConstraintWidgetGroup(new ArrayList<ConstraintWidget>(), true);
        widgetGroups.add(traverseList);
        return Analyzer.traverse(widget, traverseList, widgetGroups, hasWrapContent);
    }

    private static boolean traverse(ConstraintWidget widget, ConstraintWidgetGroup upperGroup, List<ConstraintWidgetGroup> widgetGroups, boolean hasWrapContent) {
        if (widget == null) {
            return true;
        }
        widget.mOptimizerMeasured = false;
        ConstraintWidgetContainer layoutWidget = (ConstraintWidgetContainer)widget.getParent();
        if (widget.mBelongingGroup == null) {
            boolean wrap;
            widget.mOptimizerMeasurable = true;
            upperGroup.mConstrainedGroup.add(widget);
            widget.mBelongingGroup = upperGroup;
            if (widget.mLeft.mTarget == null && widget.mRight.mTarget == null && widget.mTop.mTarget == null && widget.mBottom.mTarget == null && widget.mBaseline.mTarget == null && widget.mCenter.mTarget == null) {
                Analyzer.invalidate(layoutWidget, widget, upperGroup);
                if (hasWrapContent) {
                    return false;
                }
            }
            if (widget.mTop.mTarget != null && widget.mBottom.mTarget != null) {
                boolean bl = wrap = layoutWidget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                if (hasWrapContent) {
                    Analyzer.invalidate(layoutWidget, widget, upperGroup);
                    return false;
                }
                if (widget.mTop.mTarget.mOwner != widget.getParent() || widget.mBottom.mTarget.mOwner != widget.getParent()) {
                    Analyzer.invalidate(layoutWidget, widget, upperGroup);
                }
            }
            if (widget.mLeft.mTarget != null && widget.mRight.mTarget != null) {
                boolean bl = wrap = layoutWidget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                if (hasWrapContent) {
                    Analyzer.invalidate(layoutWidget, widget, upperGroup);
                    return false;
                }
                if (widget.mLeft.mTarget.mOwner != widget.getParent() || widget.mRight.mTarget.mOwner != widget.getParent()) {
                    Analyzer.invalidate(layoutWidget, widget, upperGroup);
                }
            }
            if (widget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT ^ widget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mDimensionRatio != 0.0f) {
                Analyzer.resolveDimensionRatio(widget);
            } else if (widget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || widget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                Analyzer.invalidate(layoutWidget, widget, upperGroup);
                if (hasWrapContent) {
                    return false;
                }
            }
            if ((widget.mLeft.mTarget == null && widget.mRight.mTarget == null || widget.mLeft.mTarget != null && widget.mLeft.mTarget.mOwner == widget.mParent && widget.mRight.mTarget == null || widget.mRight.mTarget != null && widget.mRight.mTarget.mOwner == widget.mParent && widget.mLeft.mTarget == null || widget.mLeft.mTarget != null && widget.mLeft.mTarget.mOwner == widget.mParent && widget.mRight.mTarget != null && widget.mRight.mTarget.mOwner == widget.mParent) && widget.mCenter.mTarget == null && !(widget instanceof Guideline) && !(widget instanceof Helper)) {
                upperGroup.mStartHorizontalWidgets.add(widget);
            }
            if ((widget.mTop.mTarget == null && widget.mBottom.mTarget == null || widget.mTop.mTarget != null && widget.mTop.mTarget.mOwner == widget.mParent && widget.mBottom.mTarget == null || widget.mBottom.mTarget != null && widget.mBottom.mTarget.mOwner == widget.mParent && widget.mTop.mTarget == null || widget.mTop.mTarget != null && widget.mTop.mTarget.mOwner == widget.mParent && widget.mBottom.mTarget != null && widget.mBottom.mTarget.mOwner == widget.mParent) && widget.mCenter.mTarget == null && widget.mBaseline.mTarget == null && !(widget instanceof Guideline) && !(widget instanceof Helper)) {
                upperGroup.mStartVerticalWidgets.add(widget);
            }
        } else {
            if (widget.mBelongingGroup != upperGroup) {
                upperGroup.mConstrainedGroup.addAll(widget.mBelongingGroup.mConstrainedGroup);
                upperGroup.mStartHorizontalWidgets.addAll(widget.mBelongingGroup.mStartHorizontalWidgets);
                upperGroup.mStartVerticalWidgets.addAll(widget.mBelongingGroup.mStartVerticalWidgets);
                if (!widget.mBelongingGroup.mSkipSolver) {
                    upperGroup.mSkipSolver = false;
                }
                widgetGroups.remove(widget.mBelongingGroup);
                for (ConstraintWidget auxWidget : widget.mBelongingGroup.mConstrainedGroup) {
                    auxWidget.mBelongingGroup = upperGroup;
                }
            }
            return true;
        }
        if (widget instanceof Helper) {
            Analyzer.invalidate(layoutWidget, widget, upperGroup);
            if (hasWrapContent) {
                return false;
            }
            Helper hWidget = (Helper)widget;
            for (int widgetsCount = 0; widgetsCount < hWidget.mWidgetsCount; ++widgetsCount) {
                if (Analyzer.traverse(hWidget.mWidgets[widgetsCount], upperGroup, widgetGroups, hasWrapContent)) continue;
                return false;
            }
        }
        for (ConstraintAnchor anchor : widget.mListAnchors) {
            if (anchor.mTarget == null || anchor.mTarget.mOwner == widget.getParent()) continue;
            if (anchor.mType == ConstraintAnchor.Type.CENTER) {
                Analyzer.invalidate(layoutWidget, widget, upperGroup);
                if (hasWrapContent) {
                    return false;
                }
            } else {
                Analyzer.setConnection(anchor);
            }
            if (Analyzer.traverse(anchor.mTarget.mOwner, upperGroup, widgetGroups, hasWrapContent)) continue;
            return false;
        }
        return true;
    }

    private static void invalidate(ConstraintWidgetContainer layoutWidget, ConstraintWidget widget, ConstraintWidgetGroup group) {
        group.mSkipSolver = false;
        layoutWidget.mSkipSolver = false;
        widget.mOptimizerMeasurable = false;
    }

    private static int getMaxDimension(ConstraintWidgetGroup group, int orientation) {
        int dimension = 0;
        int offset = orientation * 2;
        List<ConstraintWidget> startWidgets = group.getStartWidgets(orientation);
        int size = startWidgets.size();
        for (int i = 0; i < size; ++i) {
            ConstraintWidget widget = startWidgets.get(i);
            boolean topLeftFlow = widget.mListAnchors[offset + 1].mTarget == null || widget.mListAnchors[offset].mTarget != null && widget.mListAnchors[offset + 1].mTarget != null;
            dimension = Math.max(dimension, Analyzer.getMaxDimensionTraversal(widget, orientation, topLeftFlow, 0));
        }
        group.mGroupDimensions[orientation] = dimension;
        return dimension;
    }

    private static int getMaxDimensionTraversal(ConstraintWidget widget, int orientation, boolean topLeftFlow, int depth) {
        ConstraintWidget parent;
        ResolutionAnchor anchor;
        int flow;
        int endOffset;
        int startOffset;
        int baselinePostDistance;
        int baselinePreDistance;
        boolean hasBaseline;
        if (!widget.mOptimizerMeasurable) {
            return 0;
        }
        int dimension = 0;
        int dimensionPre = 0;
        int dimensionPost = 0;
        boolean bl = hasBaseline = widget.mBaseline.mTarget != null && orientation == 1;
        if (topLeftFlow) {
            baselinePreDistance = widget.getBaselineDistance();
            baselinePostDistance = widget.getHeight() - widget.getBaselineDistance();
            startOffset = orientation * 2;
            endOffset = startOffset + 1;
        } else {
            baselinePreDistance = widget.getHeight() - widget.getBaselineDistance();
            baselinePostDistance = widget.getBaselineDistance();
            endOffset = orientation * 2;
            startOffset = endOffset + 1;
        }
        if (widget.mListAnchors[endOffset].mTarget != null && widget.mListAnchors[startOffset].mTarget == null) {
            flow = -1;
            int aux = startOffset;
            startOffset = endOffset;
            endOffset = aux;
        } else {
            flow = 1;
        }
        if (hasBaseline) {
            depth -= baselinePreDistance;
        }
        dimension = widget.mListAnchors[startOffset].getMargin() * flow + Analyzer.getParentBiasOffset(widget, orientation);
        int downDepth = dimension + depth;
        int postTemp = (orientation == 0 ? widget.getWidth() : widget.getHeight()) * flow;
        for (Object targetNode : widget.mListAnchors[startOffset].getResolutionNode().dependents) {
            anchor = (ResolutionAnchor)targetNode;
            dimensionPre = Math.max(dimensionPre, Analyzer.getMaxDimensionTraversal(anchor.myAnchor.mOwner, orientation, topLeftFlow, downDepth));
        }
        for (Object targetNode : widget.mListAnchors[endOffset].getResolutionNode().dependents) {
            anchor = (ResolutionAnchor)targetNode;
            dimensionPost = Math.max(dimensionPost, Analyzer.getMaxDimensionTraversal(anchor.myAnchor.mOwner, orientation, topLeftFlow, postTemp + downDepth));
        }
        if (hasBaseline) {
            dimensionPre -= baselinePreDistance;
            dimensionPost += baselinePostDistance;
        } else {
            dimensionPost += (orientation == 0 ? widget.getWidth() : widget.getHeight()) * flow;
        }
        int dimensionBaseline = 0;
        if (orientation == 1) {
            for (ResolutionNode targetNode : widget.mBaseline.getResolutionNode().dependents) {
                ResolutionAnchor anchor2 = (ResolutionAnchor)targetNode;
                if (flow == 1) {
                    dimensionBaseline = Math.max(dimensionBaseline, Analyzer.getMaxDimensionTraversal(anchor2.myAnchor.mOwner, orientation, topLeftFlow, baselinePreDistance + downDepth));
                    continue;
                }
                dimensionBaseline = Math.max(dimensionBaseline, Analyzer.getMaxDimensionTraversal(anchor2.myAnchor.mOwner, orientation, topLeftFlow, baselinePostDistance * flow + downDepth));
            }
            if (widget.mBaseline.getResolutionNode().dependents.size() > 0 && !hasBaseline) {
                dimensionBaseline = flow == 1 ? (dimensionBaseline += baselinePreDistance) : (dimensionBaseline -= baselinePostDistance);
            }
        }
        int distanceBeforeWidget = dimension;
        dimension += Math.max(dimensionPre, Math.max(dimensionPost, dimensionBaseline));
        int leftTop = depth + distanceBeforeWidget;
        int end = leftTop + postTemp;
        if (flow == -1) {
            int aux = end;
            end = leftTop;
            leftTop = aux;
        }
        if (topLeftFlow) {
            Optimizer.setOptimizedWidget(widget, orientation, leftTop);
            widget.setFrame(leftTop, end, orientation);
        } else {
            widget.mBelongingGroup.addWidgetsToSet(widget, orientation);
            widget.setRelativePositioning(leftTop, orientation);
        }
        if (widget.getDimensionBehaviour(orientation) == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mDimensionRatio != 0.0f) {
            widget.mBelongingGroup.addWidgetsToSet(widget, orientation);
        }
        if (widget.mListAnchors[startOffset].mTarget != null && widget.mListAnchors[endOffset].mTarget != null && widget.mListAnchors[startOffset].mTarget.mOwner == (parent = widget.getParent()) && widget.mListAnchors[endOffset].mTarget.mOwner == parent) {
            widget.mBelongingGroup.addWidgetsToSet(widget, orientation);
        }
        return dimension;
    }

    private static void setConnection(ConstraintAnchor originAnchor) {
        ResolutionAnchor originNode = originAnchor.getResolutionNode();
        if (originAnchor.mTarget != null && originAnchor.mTarget.mTarget != originAnchor) {
            originAnchor.mTarget.getResolutionNode().addDependent(originNode);
        }
    }

    private static void singleGroup(ConstraintWidgetContainer layoutWidget) {
        layoutWidget.mWidgetGroups.clear();
        layoutWidget.mWidgetGroups.add(0, new ConstraintWidgetGroup(layoutWidget.mChildren));
    }

    public static void setPosition(List<ConstraintWidgetGroup> groups, int orientation, int containerLength) {
        int groupsSize = groups.size();
        for (int i = 0; i < groupsSize; ++i) {
            ConstraintWidgetGroup group = groups.get(i);
            for (ConstraintWidget widget : group.getWidgetsToSet(orientation)) {
                if (!widget.mOptimizerMeasurable) continue;
                Analyzer.updateSizeDependentWidgets(widget, orientation, containerLength);
            }
        }
    }

    private static void updateSizeDependentWidgets(ConstraintWidget widget, int orientation, int containerLength) {
        boolean hasBias;
        int offset = orientation * 2;
        ConstraintAnchor startAnchor = widget.mListAnchors[offset];
        ConstraintAnchor endAnchor = widget.mListAnchors[offset + 1];
        boolean bl = hasBias = startAnchor.mTarget != null && endAnchor.mTarget != null;
        if (hasBias) {
            int start = Analyzer.getParentBiasOffset(widget, orientation) + startAnchor.getMargin();
            Optimizer.setOptimizedWidget(widget, orientation, start);
            return;
        }
        if (widget.mDimensionRatio != 0.0f && widget.getDimensionBehaviour(orientation) == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            int length = Analyzer.resolveDimensionRatio(widget);
            int start = (int)widget.mListAnchors[offset].getResolutionNode().resolvedOffset;
            int end = start + length;
            endAnchor.getResolutionNode().resolvedTarget = startAnchor.getResolutionNode();
            endAnchor.getResolutionNode().resolvedOffset = length;
            endAnchor.getResolutionNode().state = 1;
            widget.setFrame(start, end, orientation);
            return;
        }
        int end = containerLength - widget.getRelativePositioning(orientation);
        int start = end - widget.getLength(orientation);
        widget.setFrame(start, end, orientation);
        Optimizer.setOptimizedWidget(widget, orientation, start);
    }

    private static int getParentBiasOffset(ConstraintWidget widget, int orientation) {
        int offset = orientation * 2;
        ConstraintAnchor startAnchor = widget.mListAnchors[offset];
        ConstraintAnchor endAnchor = widget.mListAnchors[offset + 1];
        if (startAnchor.mTarget != null && startAnchor.mTarget.mOwner == widget.mParent && endAnchor.mTarget != null && endAnchor.mTarget.mOwner == widget.mParent) {
            int length = 0;
            int widgetDimension = 0;
            float bias = 0.0f;
            length = widget.mParent.getLength(orientation);
            bias = orientation == 0 ? widget.mHorizontalBiasPercent : widget.mVerticalBiasPercent;
            widgetDimension = widget.getLength(orientation);
            length = length - startAnchor.getMargin() - endAnchor.getMargin();
            length -= widgetDimension;
            length = (int)((float)length * bias);
            return length;
        }
        return 0;
    }

    private static int resolveDimensionRatio(ConstraintWidget widget) {
        int length = -1;
        if (widget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            length = widget.mDimensionRatioSide == 0 ? (int)((float)widget.getHeight() * widget.mDimensionRatio) : (int)((float)widget.getHeight() / widget.mDimensionRatio);
            widget.setWidth(length);
        } else if (widget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            length = widget.mDimensionRatioSide == 1 ? (int)((float)widget.getWidth() * widget.mDimensionRatio) : (int)((float)widget.getWidth() / widget.mDimensionRatio);
            widget.setHeight(length);
        }
        return length;
    }
}

