/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.solver.widgets;

import androidx.constraintlayout.solver.widgets.ConstraintAnchor;
import androidx.constraintlayout.solver.widgets.ConstraintWidget;
import androidx.constraintlayout.solver.widgets.Helper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConstraintWidgetGroup {
    public List<ConstraintWidget> mConstrainedGroup;
    int mGroupWidth = -1;
    int mGroupHeight = -1;
    public boolean mSkipSolver = false;
    public final int[] mGroupDimensions = new int[]{this.mGroupWidth, this.mGroupHeight};
    List<ConstraintWidget> mStartHorizontalWidgets = new ArrayList<ConstraintWidget>();
    List<ConstraintWidget> mStartVerticalWidgets = new ArrayList<ConstraintWidget>();
    HashSet<ConstraintWidget> mWidgetsToSetHorizontal = new HashSet();
    HashSet<ConstraintWidget> mWidgetsToSetVertical = new HashSet();
    List<ConstraintWidget> mWidgetsToSolve = new ArrayList<ConstraintWidget>();
    List<ConstraintWidget> mUnresolvedWidgets = new ArrayList<ConstraintWidget>();

    ConstraintWidgetGroup(List<ConstraintWidget> widgets) {
        this.mConstrainedGroup = widgets;
    }

    ConstraintWidgetGroup(List<ConstraintWidget> widgets, boolean skipSolver) {
        this.mConstrainedGroup = widgets;
        this.mSkipSolver = skipSolver;
    }

    public List<ConstraintWidget> getStartWidgets(int orientation) {
        if (orientation == 0) {
            return this.mStartHorizontalWidgets;
        }
        if (orientation == 1) {
            return this.mStartVerticalWidgets;
        }
        return null;
    }

    Set<ConstraintWidget> getWidgetsToSet(int orientation) {
        if (orientation == 0) {
            return this.mWidgetsToSetHorizontal;
        }
        if (orientation == 1) {
            return this.mWidgetsToSetVertical;
        }
        return null;
    }

    void addWidgetsToSet(ConstraintWidget widget, int orientation) {
        if (orientation == 0) {
            this.mWidgetsToSetHorizontal.add(widget);
        } else if (orientation == 1) {
            this.mWidgetsToSetVertical.add(widget);
        }
    }

    List<ConstraintWidget> getWidgetsToSolve() {
        if (!this.mWidgetsToSolve.isEmpty()) {
            return this.mWidgetsToSolve;
        }
        int size = this.mConstrainedGroup.size();
        for (int i = 0; i < size; ++i) {
            ConstraintWidget widget = this.mConstrainedGroup.get(i);
            if (widget.mOptimizerMeasurable) continue;
            this.getWidgetsToSolveTraversal((ArrayList)this.mWidgetsToSolve, widget);
        }
        this.mUnresolvedWidgets.clear();
        this.mUnresolvedWidgets.addAll(this.mConstrainedGroup);
        this.mUnresolvedWidgets.removeAll(this.mWidgetsToSolve);
        return this.mWidgetsToSolve;
    }

    private void getWidgetsToSolveTraversal(ArrayList<ConstraintWidget> widgetsToSolve, ConstraintWidget widget) {
        if (widget.mGroupsToSolver) {
            return;
        }
        widgetsToSolve.add(widget);
        widget.mGroupsToSolver = true;
        if (widget.isFullyResolved()) {
            return;
        }
        if (widget instanceof Helper) {
            Helper helper = (Helper)widget;
            int widgetCount = helper.mWidgetsCount;
            for (int i = 0; i < widgetCount; ++i) {
                this.getWidgetsToSolveTraversal(widgetsToSolve, helper.mWidgets[i]);
            }
        }
        int count = widget.mListAnchors.length;
        for (int i = 0; i < count; ++i) {
            ConstraintAnchor targetAnchor = widget.mListAnchors[i].mTarget;
            ConstraintWidget targetWidget = null;
            if (targetAnchor == null) continue;
            targetWidget = targetAnchor.mOwner;
            if (targetAnchor == null || targetWidget == widget.getParent()) continue;
            this.getWidgetsToSolveTraversal(widgetsToSolve, targetWidget);
        }
    }

    void updateUnresolvedWidgets() {
        int size = this.mUnresolvedWidgets.size();
        for (int i = 0; i < size; ++i) {
            ConstraintWidget widget = this.mUnresolvedWidgets.get(i);
            this.updateResolvedDimension(widget);
        }
    }

    private void updateResolvedDimension(ConstraintWidget widget) {
        int start = 0;
        int end = 0;
        if (widget.mOptimizerMeasurable) {
            if (widget.isFullyResolved()) {
                return;
            }
            boolean rightSide = widget.mRight.mTarget != null;
            ConstraintAnchor targetAnchor = rightSide ? widget.mRight.mTarget : widget.mLeft.mTarget;
            if (targetAnchor != null) {
                if (!targetAnchor.mOwner.mOptimizerMeasured) {
                    this.updateResolvedDimension(targetAnchor.mOwner);
                }
                if (targetAnchor.mType == ConstraintAnchor.Type.RIGHT) {
                    end = targetAnchor.mOwner.mX + targetAnchor.mOwner.getWidth();
                } else if (targetAnchor.mType == ConstraintAnchor.Type.LEFT) {
                    end = targetAnchor.mOwner.mX;
                }
            }
            end = rightSide ? (end -= widget.mRight.getMargin()) : (end += widget.mLeft.getMargin() + widget.getWidth());
            start = end - widget.getWidth();
            widget.setHorizontalDimension(start, end);
            if (widget.mBaseline.mTarget != null) {
                targetAnchor = widget.mBaseline.mTarget;
                if (!targetAnchor.mOwner.mOptimizerMeasured) {
                    this.updateResolvedDimension(targetAnchor.mOwner);
                }
                start = targetAnchor.mOwner.mY + targetAnchor.mOwner.mBaselineDistance - widget.mBaselineDistance;
                end = start + widget.mHeight;
                widget.setVerticalDimension(start, end);
                widget.mOptimizerMeasured = true;
                return;
            }
            boolean bottomSide = widget.mBottom.mTarget != null;
            targetAnchor = bottomSide ? widget.mBottom.mTarget : widget.mTop.mTarget;
            if (targetAnchor != null) {
                if (!targetAnchor.mOwner.mOptimizerMeasured) {
                    this.updateResolvedDimension(targetAnchor.mOwner);
                }
                if (targetAnchor.mType == ConstraintAnchor.Type.BOTTOM) {
                    end = targetAnchor.mOwner.mY + targetAnchor.mOwner.getHeight();
                } else if (targetAnchor.mType == ConstraintAnchor.Type.TOP) {
                    end = targetAnchor.mOwner.mY;
                }
            }
            end = bottomSide ? (end -= widget.mBottom.getMargin()) : (end += widget.mTop.getMargin() + widget.getHeight());
            start = end - widget.getHeight();
            widget.setVerticalDimension(start, end);
            widget.mOptimizerMeasured = true;
        }
    }
}

