/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.solver.widgets;

import androidx.constraintlayout.solver.widgets.ResolutionAnchor;
import androidx.constraintlayout.solver.widgets.ResolutionDimension;
import java.util.HashSet;

public class ResolutionNode {
    HashSet<ResolutionNode> dependents = new HashSet(2);
    public static final int UNRESOLVED = 0;
    public static final int RESOLVED = 1;
    public static final int REMOVED = 2;
    int state = 0;

    public void addDependent(ResolutionNode node) {
        this.dependents.add(node);
    }

    public void reset() {
        this.state = 0;
        this.dependents.clear();
    }

    public void invalidate() {
        this.state = 0;
        for (ResolutionNode node : this.dependents) {
            node.invalidate();
        }
    }

    public void invalidateAnchors() {
        if (this instanceof ResolutionAnchor) {
            this.state = 0;
        }
        for (ResolutionNode node : this.dependents) {
            node.invalidateAnchors();
        }
    }

    public void didResolve() {
        this.state = 1;
        for (ResolutionNode node : this.dependents) {
            node.resolve();
        }
    }

    public boolean isResolved() {
        return this.state == 1;
    }

    public void resolve() {
    }

    public void remove(ResolutionDimension resolutionDimension) {
    }
}

