/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.LifecycleObserver;
import java.util.concurrent.atomic.AtomicReference;

public abstract class Lifecycle {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    AtomicReference<Object> mInternalScopeRef = new AtomicReference();

    @MainThread
    public abstract void addObserver(@NonNull LifecycleObserver var1);

    @MainThread
    public abstract void removeObserver(@NonNull LifecycleObserver var1);

    @MainThread
    @NonNull
    public abstract State getCurrentState();

    public static enum State {
        DESTROYED,
        INITIALIZED,
        CREATED,
        STARTED,
        RESUMED;


        public boolean isAtLeast(@NonNull State state) {
            return this.compareTo(state) >= 0;
        }
    }

    public static enum Event {
        ON_CREATE,
        ON_START,
        ON_RESUME,
        ON_PAUSE,
        ON_STOP,
        ON_DESTROY,
        ON_ANY;

    }
}

