/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor.transform.resource;

import com.android.tools.build.jetifier.core.type.JavaType;
import com.android.tools.build.jetifier.core.type.PackageName;
import com.android.tools.build.jetifier.core.utils.Log;
import com.android.tools.build.jetifier.processor.archive.ArchiveFile;
import com.android.tools.build.jetifier.processor.transform.TransformationContext;
import com.android.tools.build.jetifier.processor.transform.Transformer;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J*\u0010\u0012\u001a\u00020\n2\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0011H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/resource/XmlResourcesTransformer;", "Lcom/android/tools/build/jetifier/processor/transform/Transformer;", "context", "Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;", "(Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;)V", "patterns", "", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "canTransform", "", "file", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;", "getCharset", "Ljava/nio/charset/Charset;", "isPackage", "token", "", "replaceWithPatterns", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "filePath", "Ljava/nio/file/Path;", "rewriteAnnotationsXmlPath", "path", "rewritePackage", "packageName", "rewriteType", "typeName", "runTransform", "", "tryToRewriteTypesInAnnotationFile", "type", "Companion", "jetifier-processor"})
public final class XmlResourcesTransformer
implements Transformer {
    private final List<Pattern> patterns;
    private final TransformationContext context;
    @NotNull
    public static final String TAG = "XmlResourcesTransformer";
    public static final int PATTERN_TYPE_GROUP = 1;
    @NotNull
    private static final Regex JAVA_TOKEN_MATCHER;
    public static final Companion Companion;

    @Override
    public boolean canTransform(@NotNull ArchiveFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return file.isXmlFile() && !file.isPomFile();
    }

    @Override
    public void runTransform(@NotNull ArchiveFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (Intrinsics.areEqual((Object)file.getFileName(), (Object)"maven-metadata.xml")) {
            return;
        }
        Charset charset = this.getCharset(file);
        byte[] byArray = file.getData();
        String string = new String(byArray, charset);
        String string2 = string;
        StringBuilder sb = new StringBuilder(string2);
        boolean changesDone = this.replaceWithPatterns(sb, this.patterns, file.getRelativePath());
        if (changesDone) {
            String string3 = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"sb.toString()");
            String string4 = string3;
            ArchiveFile archiveFile = file;
            String string5 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray2 = string5.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray3 = byArray2;
            archiveFile.setNewData(byArray3);
        }
        if (this.context.isInReversedMode() && changesDone && StringsKt.endsWith$default((String)((Object)file.getRelativePath()).toString(), (String)"annotations.xml", (boolean)false, (int)2, null)) {
            file.updateRelativePath(this.rewriteAnnotationsXmlPath(file.getRelativePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Charset getCharset(@NotNull ArchiveFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        try {
            Object object = file.getData();
            object = new ByteArrayInputStream((byte[])object);
            Throwable throwable = null;
            try {
                XMLStreamReader xmlReader;
                ByteArrayInputStream it = (ByteArrayInputStream)object;
                XMLStreamReader xMLStreamReader = xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(it);
                Intrinsics.checkExpressionValueIsNotNull((Object)xMLStreamReader, (String)"xmlReader");
                if (xMLStreamReader.getEncoding() == null) {
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                    Charset charset2 = charset;
                    return charset2;
                }
                Charset result = Charset.forName(xmlReader.getEncoding());
                if (result == null) {
                    Log.INSTANCE.e(TAG, "Failed to find charset for encoding '%s'", new Object[]{xmlReader.getEncoding()});
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                    Charset charset3 = charset;
                    return charset3;
                }
                Charset charset = result;
                return charset;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (XMLStreamException e) {
            Log.INSTANCE.w(TAG, "Received malformed sequence exception when trying to detect the encoding for '%s'. Defaulting to UTF-8.", new Object[]{file.getFileName()});
            StringWriter tracePrinter = new StringWriter();
            e.printStackTrace(new PrintWriter(tracePrinter));
            String string = tracePrinter.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tracePrinter.toString()");
            Log.INSTANCE.w(TAG, string, new Object[0]);
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
            return charset;
        }
    }

    private final boolean replaceWithPatterns(StringBuilder sb, List<Pattern> patterns, Path filePath) {
        boolean changesDone = false;
        for (Pattern pattern : patterns) {
            String processedInput;
            int lastSeenChar = 0;
            Intrinsics.checkExpressionValueIsNotNull((Object)sb.toString(), (String)"sb.toString()");
            sb.setLength(0);
            Matcher matcher = pattern.matcher(processedInput);
            while (matcher.find()) {
                String string;
                String replacement;
                if (lastSeenChar < matcher.start()) {
                    sb.append(processedInput, lastSeenChar, matcher.start());
                }
                String toReplace = matcher.group(1);
                String matched = matcher.group(0);
                String string2 = toReplace;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"toReplace");
                CharSequence charSequence = string2;
                Regex regex = JAVA_TOKEN_MATCHER;
                String string3 = regex.matches(charSequence) ? (this.isPackage(toReplace) ? this.rewritePackage(toReplace, filePath) : this.rewriteType(toReplace)) : (replacement = toReplace);
                if (this.context.isInReversedMode() && Intrinsics.areEqual((Object)replacement, (Object)toReplace) && StringsKt.endsWith$default((String)((Object)filePath).toString(), (String)"annotations.xml", (boolean)false, (int)2, null)) {
                    replacement = this.tryToRewriteTypesInAnnotationFile(toReplace);
                }
                changesDone = changesDone || Intrinsics.areEqual((Object)replacement, (Object)toReplace) ^ true;
                int localStart = matcher.start(1) - matcher.start();
                int localEnd = matcher.end(1) - matcher.start();
                Intrinsics.checkExpressionValueIsNotNull((Object)matched, (String)"matched");
                String string4 = replacement;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"replacement");
                CharSequence charSequence2 = string4;
                String string5 = string;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String result = ((Object)StringsKt.replaceRange((CharSequence)string5, (int)localStart, (int)localEnd, (CharSequence)charSequence2)).toString();
                sb.append(result);
                lastSeenChar = matcher.end();
            }
            if (lastSeenChar > processedInput.length() - 1) continue;
            sb.append(processedInput, lastSeenChar, processedInput.length());
        }
        return changesDone;
    }

    private final boolean isPackage(String token) {
        boolean bl;
        block1: {
            CharSequence $receiver$iv;
            CharSequence charSequence = $receiver$iv = (CharSequence)token;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv = charSequence.charAt(i);
                char it = element$iv;
                char c = it;
                if (!Character.isUpperCase(c)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return !bl;
    }

    private final String rewriteType(String typeName) {
        if (StringsKt.contains$default((CharSequence)typeName, (CharSequence)" ", (boolean)false, (int)2, null)) {
            return typeName;
        }
        JavaType type = JavaType.Companion.fromDotVersion(typeName);
        JavaType result = this.context.getTypeRewriter().rewriteType(type);
        if (result != null) {
            return result.toDotNotation();
        }
        this.context.reportNoMappingFoundFailure(TAG, type);
        return typeName;
    }

    private final String rewritePackage(String packageName, Path filePath) {
        if (!StringsKt.contains$default((CharSequence)packageName, (char)'.', (boolean)false, (int)2, null)) {
            return packageName;
        }
        PackageName pckg = PackageName.Companion.fromDotVersion(packageName);
        PackageName result = this.context.getConfig().getPackageMap().getPackageFor(pckg);
        if (result != null) {
            return result.toDotNotation();
        }
        if (this.context.getConfig().isEligibleForRewrite(pckg)) {
            this.context.reportNoPackageMappingFoundFailure(TAG, packageName, filePath);
        }
        return packageName;
    }

    private final String tryToRewriteTypesInAnnotationFile(String type) {
        List tokens = StringsKt.split$default((CharSequence)type, (String[])new String[]{" ", ",", "(", ")", "{", "}", ";"}, (boolean)false, (int)0, (int)6, null);
        String result = type;
        Iterable $receiver$iv = tokens;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            String rewritten = this.rewriteType(it);
            if (!(Intrinsics.areEqual((Object)rewritten, (Object)it) ^ true)) continue;
            result = StringsKt.replace$default((String)result, (String)it, (String)rewritten, (boolean)false, (int)4, null);
        }
        return result;
    }

    private final Path rewriteAnnotationsXmlPath(Path path) {
        File file = path.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"path.toFile()");
        String string = file.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path.toFile().path");
        String owner = StringsKt.removeSuffix((String)StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null), (CharSequence)".xml");
        JavaType type = new JavaType(owner);
        JavaType result = this.context.getTypeRewriter().rewriteType(type);
        if (result == null) {
            this.context.reportNoMappingFoundFailure("PathRewrite", type);
            return path;
        }
        if (Intrinsics.areEqual((Object)result, (Object)type) ^ true) {
            Path path2 = path.getFileSystem().getPath(result.getFullName() + ".xml", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path.fileSystem.getPath(result.fullName + \".xml\")");
            return path2;
        }
        return path;
    }

    public XmlResourcesTransformer(@NotNull TransformationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.patterns = CollectionsKt.listOf((Object[])new Pattern[]{Pattern.compile("</?([a-zA-Z0-9.]+)"), Pattern.compile("[a-zA-Z0-9:]+=\"([^\"]+)\""), Pattern.compile(">\\s*([a-zA-Z0-9.$_]+)<")});
    }

    static {
        Companion = new Companion(null);
        String string = "^[a-zA-Z0-9.$_]+$";
        JAVA_TOKEN_MATCHER = new Regex(string);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/resource/XmlResourcesTransformer$Companion;", "", "()V", "JAVA_TOKEN_MATCHER", "Lkotlin/text/Regex;", "getJAVA_TOKEN_MATCHER", "()Lkotlin/text/Regex;", "PATTERN_TYPE_GROUP", "", "TAG", "", "jetifier-processor"})
    public static final class Companion {
        @NotNull
        public final Regex getJAVA_TOKEN_MATCHER() {
            return JAVA_TOKEN_MATCHER;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

