/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor.transform.pom;

import com.android.tools.build.jetifier.core.utils.Log;
import com.android.tools.build.jetifier.processor.archive.Archive;
import com.android.tools.build.jetifier.processor.archive.ArchiveFile;
import com.android.tools.build.jetifier.processor.archive.ArchiveItem;
import com.android.tools.build.jetifier.processor.archive.ArchiveItemVisitor;
import com.android.tools.build.jetifier.processor.transform.TransformationContext;
import com.android.tools.build.jetifier.processor.transform.pom.PomDocument;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/pom/PomScanner;", "", "context", "Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;", "(Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;)V", "pomFiles", "", "Lcom/android/tools/build/jetifier/processor/transform/pom/PomDocument;", "getPomFiles", "()Ljava/util/List;", "pomFilesInternal", "", "validationFailuresCount", "", "scanArchiveForPomFile", "", "archive", "Lcom/android/tools/build/jetifier/processor/archive/Archive;", "wasErrorFound", "", "Companion", "PomScannerSession", "jetifier-processor"})
public final class PomScanner {
    private final List<PomDocument> pomFilesInternal;
    private int validationFailuresCount;
    @NotNull
    private final List<PomDocument> pomFiles;
    private final TransformationContext context;
    private static final String TAG = "PomScanner";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<PomDocument> getPomFiles() {
        return this.pomFiles;
    }

    public final boolean wasErrorFound() {
        return this.validationFailuresCount > 0;
    }

    public final void scanArchiveForPomFile(@NotNull Archive archive) {
        Intrinsics.checkParameterIsNotNull((Object)archive, (String)"archive");
        PomScannerSession session = new PomScannerSession();
        archive.accept(session);
        Iterable $receiver$iv = session.getPomFiles();
        for (Object element$iv : $receiver$iv) {
            PomDocument it = (PomDocument)element$iv;
            it.logDocumentDetails();
            if (!this.context.getIgnorePomVersionCheck() && !it.validate(this.context.getConfig().getPomRewriteRules())) {
                Log.INSTANCE.e(TAG, "Version mismatch!", new Object[0]);
                int n = this.validationFailuresCount;
                this.validationFailuresCount = n + 1;
            }
            this.pomFilesInternal.add(it);
        }
    }

    public PomScanner(@NotNull TransformationContext context) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        PomScanner pomScanner = this;
        pomScanner.pomFilesInternal = list = (List)new ArrayList();
        this.pomFiles = this.pomFilesInternal;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/pom/PomScanner$PomScannerSession;", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveItemVisitor;", "()V", "pomFiles", "", "Lcom/android/tools/build/jetifier/processor/transform/pom/PomDocument;", "getPomFiles", "()Ljava/util/Set;", "visit", "", "archive", "Lcom/android/tools/build/jetifier/processor/archive/Archive;", "archiveFile", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;", "jetifier-processor"})
    private static final class PomScannerSession
    implements ArchiveItemVisitor {
        @NotNull
        private final Set<PomDocument> pomFiles;

        @NotNull
        public final Set<PomDocument> getPomFiles() {
            return this.pomFiles;
        }

        @Override
        public void visit(@NotNull Archive archive) {
            Intrinsics.checkParameterIsNotNull((Object)archive, (String)"archive");
            for (ArchiveItem archiveItem : archive.getFiles()) {
                archiveItem.accept(this);
            }
        }

        @Override
        public void visit(@NotNull ArchiveFile archiveFile) {
            Intrinsics.checkParameterIsNotNull((Object)archiveFile, (String)"archiveFile");
            if (archiveFile.isPomFile()) {
                this.pomFiles.add(PomDocument.Companion.loadFrom(archiveFile));
            }
        }

        public PomScannerSession() {
            Set set;
            PomScannerSession pomScannerSession = this;
            pomScannerSession.pomFiles = set = (Set)new LinkedHashSet();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/pom/PomScanner$Companion;", "", "()V", "TAG", "", "jetifier-processor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

