/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor.transform.pom;

import com.android.tools.build.jetifier.core.pom.PomDependency;
import com.android.tools.build.jetifier.core.utils.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/pom/XmlUtils;", "", "()V", "Companion", "jetifier-processor"})
public final class XmlUtils {
    private static final Pattern variablePattern;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        variablePattern = Pattern.compile("\\$\\{([^}]*)}");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0015J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u000eJ&\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0015R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/pom/XmlUtils$Companion;", "", "()V", "variablePattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "addStringNodeToNode", "", "parent", "Lorg/jdom2/Element;", "id", "", "value", "convertDocumentToByteArray", "", "document", "Lorg/jdom2/Document;", "createDependencyFrom", "Lcom/android/tools/build/jetifier/core/pom/PomDependency;", "node", "properties", "", "createDocumentFromByteArray", "data", "resolveValue", "jetifier-processor"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final byte[] convertDocumentToByteArray(@NotNull Document document) {
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            XMLOutputter xmlOutput = new XMLOutputter();
            Closeable closeable = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
                xmlOutput.setFormat(Format.getPrettyFormat());
                xmlOutput.output(document, (OutputStream)it);
                byte[] byArray = it.toByteArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"it.toByteArray()");
                byte[] byArray2 = byArray;
                return byArray2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Document createDocumentFromByteArray(@NotNull byte[] data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            SAXBuilder builder = new SAXBuilder();
            Object object = data;
            object = new ByteArrayInputStream((byte[])object);
            Throwable throwable = null;
            try {
                ByteArrayInputStream it = (ByteArrayInputStream)object;
                Document document = builder.build((InputStream)it);
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"builder.build(it)");
                Document document2 = document;
                return document2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }

        public final void addStringNodeToNode(@NotNull Element parent, @NotNull String id, @Nullable String value) {
            Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            CharSequence charSequence = value;
            if (charSequence == null || charSequence.length() == 0) {
                return;
            }
            Element element = new Element(id);
            element.setText(value);
            element.setNamespace(parent.getNamespace());
            parent.getChildren().add(element);
        }

        @Nullable
        public final String resolveValue(@Nullable String value, @NotNull Map<String, String> properties) {
            Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
            if (value == null) {
                return null;
            }
            Matcher matcher = variablePattern.matcher(value);
            if (matcher.matches()) {
                String variableName = matcher.group(1);
                String varValue = properties.get(variableName);
                if (varValue == null) {
                    Log.INSTANCE.i("TAG", "Failed to resolve variable '%s'. Ignoring.", new Object[]{value});
                    return value;
                }
                return varValue;
            }
            return value;
        }

        @NotNull
        public final PomDependency createDependencyFrom(@NotNull Element node, @NotNull Map<String, String> properties) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
            String groupId = null;
            String artifactId = null;
            String version = null;
            String classifier = null;
            String type = null;
            String scope = null;
            String systemPath = null;
            String optional = null;
            Iterator iterator = node.getChildren().iterator();
            while (iterator.hasNext()) {
                String string;
                Element childNode;
                Element element = childNode = (Element)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"childNode");
                if (element.getName() == null) continue;
                int n = -1;
                switch (string.hashCode()) {
                    case 293428218: {
                        if (!string.equals("groupId")) break;
                        n = 1;
                        break;
                    }
                    case 109264468: {
                        if (!string.equals("scope")) break;
                        n = 2;
                        break;
                    }
                    case -281470431: {
                        if (!string.equals("classifier")) break;
                        n = 3;
                        break;
                    }
                    case 240640653: {
                        if (!string.equals("artifactId")) break;
                        n = 4;
                        break;
                    }
                    case -79017120: {
                        if (!string.equals("optional")) break;
                        n = 5;
                        break;
                    }
                    case 642751220: {
                        if (!string.equals("systemPath")) break;
                        n = 6;
                        break;
                    }
                    case 3575610: {
                        if (!string.equals("type")) break;
                        n = 7;
                        break;
                    }
                    case 351608024: {
                        if (!string.equals("version")) break;
                        n = 8;
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        groupId = this.resolveValue(childNode.getValue(), properties);
                        break;
                    }
                    case 4: {
                        artifactId = this.resolveValue(childNode.getValue(), properties);
                        break;
                    }
                    case 8: {
                        version = this.resolveValue(childNode.getValue(), properties);
                        break;
                    }
                    case 3: {
                        classifier = this.resolveValue(childNode.getValue(), properties);
                        break;
                    }
                    case 7: {
                        type = this.resolveValue(childNode.getValue(), properties);
                        break;
                    }
                    case 2: {
                        scope = this.resolveValue(childNode.getValue(), properties);
                        break;
                    }
                    case 6: {
                        systemPath = this.resolveValue(childNode.getValue(), properties);
                        break;
                    }
                    case 5: {
                        optional = this.resolveValue(childNode.getValue(), properties);
                    }
                }
            }
            return new PomDependency(groupId, artifactId, version, classifier, type, scope, systemPath, optional);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

