/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor.archive;

import com.android.tools.build.jetifier.processor.archive.ArchiveItem;
import com.android.tools.build.jetifier.processor.archive.ArchiveItemVisitor;
import com.android.tools.build.jetifier.processor.archive.FileSearchResult;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J$\u0010#\u001a\u00020 2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00130%2\u0006\u0010&\u001a\u00020'H\u0016J\u000e\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020\u0005J\u000e\u0010*\u001a\u00020 2\u0006\u0010)\u001a\u00020\u0005J\u000e\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020\u0003J\u0010\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020/H\u0016R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\f@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u0013@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0015\"\u0004\b\u001e\u0010\u0017\u00a8\u00060"}, d2={"Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveItem;", "relativePath", "Ljava/nio/file/Path;", "data", "", "(Ljava/nio/file/Path;[B)V", "<set-?>", "getData", "()[B", "setData", "([B)V", "", "fileName", "getFileName", "()Ljava/lang/String;", "setFileName", "(Ljava/lang/String;)V", "markedForRemoval", "", "getMarkedForRemoval", "()Z", "setMarkedForRemoval", "(Z)V", "getRelativePath", "()Ljava/nio/file/Path;", "setRelativePath", "(Ljava/nio/file/Path;)V", "wasChanged", "getWasChanged", "setWasChanged", "accept", "", "visitor", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveItemVisitor;", "findAllFiles", "selector", "Lkotlin/Function1;", "result", "Lcom/android/tools/build/jetifier/processor/archive/FileSearchResult;", "setNewData", "newData", "setNewDataSilently", "updateRelativePath", "newRelativePath", "writeSelfTo", "outputStream", "Ljava/io/OutputStream;", "jetifier-processor"})
public final class ArchiveFile
implements ArchiveItem {
    @NotNull
    private Path relativePath;
    @NotNull
    private String fileName;
    private boolean wasChanged;
    private boolean markedForRemoval;
    @NotNull
    private byte[] data;

    @Override
    @NotNull
    public Path getRelativePath() {
        return this.relativePath;
    }

    private void setRelativePath(Path path) {
        this.relativePath = path;
    }

    @Override
    @NotNull
    public String getFileName() {
        return this.fileName;
    }

    private void setFileName(String string) {
        this.fileName = string;
    }

    @Override
    public boolean getWasChanged() {
        return this.wasChanged;
    }

    private void setWasChanged(boolean bl) {
        this.wasChanged = bl;
    }

    @Override
    public boolean getMarkedForRemoval() {
        return this.markedForRemoval;
    }

    @Override
    public void setMarkedForRemoval(boolean bl) {
        this.markedForRemoval = bl;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    private final void setData(byte[] byArray) {
        this.data = byArray;
    }

    @Override
    public void findAllFiles(@NotNull Function1<? super ArchiveFile, Boolean> selector, @NotNull FileSearchResult result) {
        Intrinsics.checkParameterIsNotNull(selector, (String)"selector");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        if (((Boolean)selector.invoke((Object)this)).booleanValue()) {
            result.addFile(this);
        }
    }

    @Override
    public void accept(@NotNull ArchiveItemVisitor visitor) {
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        visitor.visit(this);
    }

    @Override
    public void writeSelfTo(@NotNull OutputStream outputStream) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
        outputStream.write(this.data);
    }

    public final void updateRelativePath(@NotNull Path newRelativePath) {
        Intrinsics.checkParameterIsNotNull((Object)newRelativePath, (String)"newRelativePath");
        if (Intrinsics.areEqual((Object)this.getRelativePath(), (Object)newRelativePath) ^ true) {
            this.setWasChanged(true);
        }
        this.setRelativePath(newRelativePath);
        this.setFileName(((Object)this.getRelativePath().getFileName()).toString());
    }

    public final void setNewData(@NotNull byte[] newData) {
        Intrinsics.checkParameterIsNotNull((Object)newData, (String)"newData");
        this.data = newData;
        this.setWasChanged(true);
    }

    public final void setNewDataSilently(@NotNull byte[] newData) {
        Intrinsics.checkParameterIsNotNull((Object)newData, (String)"newData");
        this.data = newData;
    }

    public ArchiveFile(@NotNull Path relativePath, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.relativePath = relativePath;
        this.fileName = ((Object)relativePath.getFileName()).toString();
        this.data = data;
    }

    @Override
    public boolean isPomFile() {
        return ArchiveItem.DefaultImpls.isPomFile(this);
    }

    @Override
    public boolean isClassFile() {
        return ArchiveItem.DefaultImpls.isClassFile(this);
    }

    @Override
    public boolean isXmlFile() {
        return ArchiveItem.DefaultImpls.isXmlFile(this);
    }

    @Override
    public boolean isProGuardFile() {
        return ArchiveItem.DefaultImpls.isProGuardFile(this);
    }
}

