/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor.transform.proguard;

import com.android.tools.build.jetifier.processor.archive.ArchiveFile;
import com.android.tools.build.jetifier.processor.transform.TransformationContext;
import com.android.tools.build.jetifier.processor.transform.Transformer;
import com.android.tools.build.jetifier.processor.transform.proguard.ProGuardClassFilterParser;
import com.android.tools.build.jetifier.processor.transform.proguard.ProGuardClassSpecParser;
import com.android.tools.build.jetifier.processor.transform.proguard.ProGuardTypesMapper;
import com.android.tools.build.jetifier.processor.transform.proguard.patterns.GroupsReplacer;
import com.android.tools.build.jetifier.processor.transform.proguard.patterns.ReplacersRunner;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/proguard/ProGuardTransformer;", "Lcom/android/tools/build/jetifier/processor/transform/Transformer;", "context", "Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;", "(Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;)V", "mapper", "Lcom/android/tools/build/jetifier/processor/transform/proguard/ProGuardTypesMapper;", "replacer", "Lcom/android/tools/build/jetifier/processor/transform/proguard/patterns/ReplacersRunner;", "getReplacer", "()Lcom/android/tools/build/jetifier/processor/transform/proguard/patterns/ReplacersRunner;", "canTransform", "", "file", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;", "runTransform", "", "jetifier-processor"})
public final class ProGuardTransformer
implements Transformer {
    private final ProGuardTypesMapper mapper;
    @NotNull
    private final ReplacersRunner replacer;

    @NotNull
    public final ReplacersRunner getReplacer() {
        return this.replacer;
    }

    @Override
    public boolean canTransform(@NotNull ArchiveFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return file.isProGuardFile();
    }

    @Override
    public void runTransform(@NotNull ArchiveFile file) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        byte[] byArray = file.getData();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
        Object object = charset;
        String string2 = string = new String(byArray, (Charset)object);
        String string3 = string2;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"StringBuilder(file.data.\u2026arsets.UTF_8)).toString()");
        String content = string3;
        String result = this.replacer.applyReplacers(content);
        if (Intrinsics.areEqual((Object)result, (Object)content)) {
            return;
        }
        object = result;
        ArchiveFile archiveFile = file;
        Charset charset2 = Charsets.UTF_8;
        Object object2 = object;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray2 = ((String)object2).getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray3 = byArray2;
        archiveFile.setNewData(byArray3);
    }

    public ProGuardTransformer(@NotNull TransformationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.mapper = new ProGuardTypesMapper(context);
        this.replacer = new ReplacersRunner(CollectionsKt.listOf((Object[])new GroupsReplacer[]{new ProGuardClassSpecParser(this.mapper).getReplacer(), new ProGuardClassFilterParser(this.mapper).getReplacer()}));
    }
}

