/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;

public class DirectoryWalker {
    private final Path root;
    private final Collection<Predicate<Path>> filters;
    private final FileAction action;

    public static Builder builder() {
        return new Builder();
    }

    public DirectoryWalker walk() throws IOException {
        if (!Files.exists(this.root, new LinkOption[0])) {
            return this;
        }
        EnumSet options = Sets.newEnumSet(Arrays.asList(FileVisitOption.FOLLOW_LINKS), FileVisitOption.class);
        Files.walkFileTree(this.root, options, Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                if (!DirectoryWalker.this.shouldSkipPath(path)) {
                    DirectoryWalker.this.action.call(DirectoryWalker.this.root, path);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return this;
    }

    private DirectoryWalker(FileAction action, Path start, Collection<Predicate<Path>> filters) {
        this.action = action;
        this.root = start;
        this.filters = filters;
    }

    private boolean shouldSkipPath(Path path) {
        return this.filters.stream().anyMatch(predicate -> predicate.test(path));
    }

    public static class Builder {
        private Path root;
        private final Collection<Predicate<Path>> filters = Lists.newLinkedList();
        private FileAction action;

        private Builder() {
        }

        public Builder root(Path root) {
            Preconditions.checkArgument((root != null ? 1 : 0) != 0, (Object)"cannot pass in a null root directory");
            this.root = root;
            return this;
        }

        public Builder extensions(String ... extensions) {
            Preconditions.checkArgument((extensions.length > 0 ? 1 : 0) != 0, (Object)"cannot pass in an empty array of extensions");
            for (String ext : extensions) {
                Preconditions.checkArgument((ext != null ? 1 : 0) != 0, (Object)"cannot pass in a null extension");
                Preconditions.checkArgument((ext.length() > 0 ? 1 : 0) != 0, (Object)"cannot pass in an empty extension");
            }
            return this.select(new ExtensionSelector(extensions));
        }

        public Builder filter(Predicate<Path> filter) {
            Preconditions.checkArgument((filter != null ? 1 : 0) != 0, (Object)"cannot pass in a null filter");
            this.filters.add(filter);
            return this;
        }

        public Builder select(Predicate<Path> selector) {
            return this.filter(path -> !selector.test((Path)path));
        }

        public Builder action(FileAction action) {
            Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"cannot pass in a null action");
            this.action = action;
            return this;
        }

        public Builder action(java.util.function.Supplier<? extends FileAction> supplier) {
            Preconditions.checkArgument((supplier != null ? 1 : 0) != 0, (Object)"cannot pass in a null actionSupplier");
            Supplier action = Suppliers.memoize(supplier::get);
            this.action = (arg_0, arg_1) -> Builder.lambda$action$1((java.util.function.Supplier)action, arg_0, arg_1);
            return this;
        }

        public DirectoryWalker build() {
            Preconditions.checkArgument((this.action != null ? 1 : 0) != 0, (Object)"action cannot be left unset");
            Preconditions.checkArgument((this.root != null ? 1 : 0) != 0, (Object)"root cannot be left unset");
            return new DirectoryWalker(this.action, this.root, Collections.unmodifiableCollection(this.filters));
        }

        private static /* synthetic */ void lambda$action$1(java.util.function.Supplier action, Path root, Path path) throws IOException {
            FileAction fa = (FileAction)action.get();
            Preconditions.checkNotNull((Object)fa, (Object)"action supplier cannot return null action");
            fa.call(root, path);
        }
    }

    private static class ExtensionSelector
    implements Predicate<Path> {
        private final Set<String> allowedExtensions;

        public ExtensionSelector(String ... allowedExtensions) {
            this.allowedExtensions = Sets.newHashSet((Object[])allowedExtensions);
        }

        @Override
        public boolean test(Path path) {
            return this.allowedExtensions.contains(ExtensionSelector.getExtension(path));
        }

        private static String getExtension(Path path) {
            return com.google.common.io.Files.getFileExtension((String)path.toAbsolutePath().toString());
        }
    }

    @FunctionalInterface
    public static interface FileAction {
        public void call(Path var1, Path var2) throws IOException;
    }
}

